<?php $__env->startSection('content'); ?>
    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>News and Events</h1>
                <ul>
                    <li><a href="<?php echo e(route('front.home')); ?>">Home</a> -</li>
                    <li>News and Events</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- News and Events Page Area Start Here -->
    <div class="news-page-area">
        <div class="container">
            <!-- News and Events Search Area Start Here -->
            <form id="checkout-form"  class="news-event-search">
                <div class="row">
                    <div class="col-6">
                    </div>
                <div class="d-flex col-lg-6 col-md-6 col-sm-12 mb-4 right ">
                    <input id="first-name" placeholder="Type Here...." class="form-control" type="text" name="search"
                           value="<?php echo e(request()->input('search')); ?>"/>
                    <button class="sidebar-search-btn-full disabled" type="submit" >Search</button>
                    <a class="sidebar-reset-btn-full disabled float-left" href="<?php echo e(route('news-events')); ?>">Reset</a>
                </div>
                    </div>
            </form>
            <!-- News and Events Search Area End Here -->
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="row">
                        <?php if($events->isEmpty()): ?>
                            <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                <div class="news-box">
                                    <h3 class="title-news-left-bold">Record not Found.</h3>
                                </div>
                            </div>
                        <?php else: ?>
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                    <div class="news-box">
                                        <div class="news-img-holder">
                                            <img
                                                src="<?php echo e(asset("storage/News-and-Events/thumbnail/{$event->thumbnail}")); ?>"
                                                class="img-responsive" alt="research">
                                            <ul class="news-date2">
                                                <li><?php echo e(\Carbon\Carbon::parse($event->date)->format('d M')); ?></li>
                                                <li><?php echo e(\Carbon\Carbon::parse($event->date)->format('Y')); ?></li>
                                            </ul>
                                        </div>
                                        <h1 class="sidebar-title title-news-left-bold"><a
                                                href="<?php echo e(route('news-events-details', $event->slug)); ?>"><?php echo e($event->title); ?></a>
                                        </h1>
                                        <ul class="title-bar-high news-comments">
                                            <li><a href="<?php echo e(route('news-events', ['category_id' => $event->news_and_events_category_id])); ?>"><i class="fa fa-tags" aria-hidden="true"></i><?php echo e($event->category->name); ?></a></li>
                                        </ul>
                                        <p><?php echo e($event->summary); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <ul class="pagination-center">
                                <li>
                                    <?php echo e($events->links()); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar">
                        <div class="sidebar-box">
                            <div class="sidebar-box-inner">
                                <h3 class="sidebar-title">Type</h3>
                                <ul class="sidebar-categories">
                                    <li class="<?php echo e(request()->get('type') == 'news' ? 'active' : ''); ?>"><a href="<?php echo e(route('news-events')); ?>?type=news">News</a></li>
                                    <li class="<?php echo e(request()->get('type') == 'event' ? 'active' : ''); ?>"><a href="<?php echo e(route('news-events')); ?>?type=event">Events</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="sidebar-box">
                            <div class="sidebar-box-inner">
                                <h3 class="sidebar-title">Categories</h3>
                                <ul class="sidebar-categories">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="<?php echo e(request()->get('category_id') == $category->id ? 'active' : ''); ?>">
                                            <a href="<?php echo e(route('news-events', ['category_id' => $category->id])); ?>">
                                                <?php echo e($category->name); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- News and Events Page Area End Here -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uoredu/public_html/uor/resources/views/front/news_events.blade.php ENDPATH**/ ?>