<?php $__env->startSection('content'); ?>

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Interior Design</h1>
                <ul>
                    <li><a href="<?php echo e(route('front.home')); ?>">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="<?php echo e(route('front.faculties-and-departments')); ?>">Faculties & Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper mt-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">

                <div class="content-new-wrapper table-responsive mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content">
                                    <div class="col-lg-12 g-0">
                                        <div class="course-details-inner">
                                            <h3 class="title-default-left title-bar-high">Designing Spaces, Transforming Lives</h3>
                                            <p>The Department of Interior Design is dedicated to creating environments that enhance the quality of life. Our curriculum integrates aesthetic principles with practical applications, focusing on space planning, sustainable design, and innovative solutions. Students learn to balance functionality with beauty, creating spaces that are both livable and inspiring. Our faculty, experienced designers and architects, offer personalized mentorship and guidance. In a world where environment shapes experience, join us to become a designer who makes a difference.</p>

                                            <h3 class="title-default-left title-bar-high">Why Study Interior Design?</h3>
                                            <p>Interior design is more than aesthetics; it's about creating environments that inspire, function effectively, and reflect the needs and aspirations of individuals and communities. At our department, you will:</p>
                                            <ul class="mb-4">
                                                <li><strong>Blend Creativity with Functionality:</strong> Learn to merge aesthetic principles with practical considerations like space planning, sustainability, and ergonomic design.</li>
                                                <li><strong>Hands-On Experience:</strong> Engage in studio-based learning that includes designing residential, commercial, and public spaces using industry-standard software and technologies.</li>
                                                <li><strong>Industry Insights:</strong> Benefit from the expertise of faculty who are practicing professionals, gaining insights into current trends and innovations in interior design.</li>
                                            </ul>
                                            <p>
                                            Our program, BS Interior Design, prepares students to excel in:
                                            </p>

                                            <ul >
                                                <li><strong>Spatial Design:</strong> Conceptualize and develop spatial solutions that optimize functionality and enhance user experience.</li>
                                                <li><strong>Material Selection:</strong> Explore a variety of materials and finishes, understanding their properties and applications in interior design.</li>
                                                <li><strong>Project Management:</strong> Acquire skills in project planning, budgeting, and client communication, essential for executing design projects from conception to completion.</li>
                                            </ul>

                                            <h3 class="title-default-left title-bar-high">How You Are Taught?</h3>
                                            <p>At the Department of Interior Design, learning is immersive and collaborative:</p>
                                            <ul  class="learning-outcomes mb-4">
                                                <li><strong>Studio-Based Education:</strong> Work in dedicated studio spaces equipped with tools and resources needed for hands-on learning and design experimentation.</li>
                                                <li><strong>Critique and Feedback:</strong> Participate in critiques and discussions that foster critical thinking and refinement of design concepts.</li>
                                                <li><strong>Guest Lectures and Workshops:</strong> Attend sessions by guest lecturers and industry experts, gaining valuable insights and networking opportunities within the design community.</li>
                                            </ul>

                                            <h3 class="title-default-left title-bar-high">Study Abroad and Internship Opportunities</h3>
                                            <p>Expand your horizons and gain practical experience through study abroad and internship programs:</p>
                                            <ul  class="learning-outcomes mb-4">
                                                <li><strong>Global Perspectives:</strong> Explore international design practices and cultural influences through study abroad opportunities.</li>
                                                <li><strong>Internship Placements:</strong> Gain real-world experience with leading design firms and organizations, applying your skills in professional settings.</li>
                                            </ul>

                                            <h3 class="title-default-left title-bar-high">Career Prospects</h3>
                                            <p>Graduates with a BS in Interior Design have diverse opportunities in various sectors:</p>
                                            <ul  class="learning-outcomes mb-4">
                                                <li><strong>Interior Designer:</strong> Work in design firms, architectural studios, or as freelancers, creating functional and aesthetically pleasing interior spaces for residential, commercial, and institutional clients.</li>
                                                <li><strong>Space Planner:</strong> Specialize in optimizing spatial layouts for efficiency and functionality in offices, retail spaces, hospitality venues, and healthcare facilities.</li>
                                                <li><strong>Exhibition Designer:</strong> Design immersive and engaging exhibition spaces for museums, galleries, trade shows, and events, integrating storytelling and visitor experience into spatial design.</li>
                                                <li><strong>Set Designer:</strong> Collaborate with film, television, and theater production teams to design sets that enhance storytelling and evoke desired atmospheres for productions.</li>
                                                <li><strong>Furniture Designer:</strong> Create unique furniture pieces or collaborate with manufacturers to design functional and aesthetically appealing furniture that complements interior spaces.</li>
                                                <li><strong>Retail Interior Designer:</strong> Develop interior concepts for retail environments that enhance customer experience, brand identity, and sales effectiveness.</li>
                                                <li><strong>Sustainable Designer:</strong> Focus on eco-friendly design practices, incorporating sustainable materials and techniques to create environmentally responsible interior spaces.</li>
                                            </ul>

                                            <p>A degree in BS Interior Design equips graduates with the skills to conceptualize, plan, and execute interior environments that meet client needs, aesthetic preferences, and functional requirements across diverse industries and settings.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="content-new-wrapper table-responsive">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="sidebar-box mt-4 ">
                        <div class="sidebar-box-inner">
                            <h2 class="sidebar-title">Programs </h2>
                            <ul class="sidebar-categories">
                                <h6>
                                    <li><a href="<?php echo e(URL('/')); ?>/course-detail/bs-interior-design">BS Interior Design</a></li>
                                    <li><a href="<?php echo e(URL('/')); ?>/course-detail/adp-interior-design">ADP Interior Design</a></li>
                                </h6></ul>
                        </div>
                    </div>
                    <div class="quick-link-pages pt-4 pb-2 px-3">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="<?php echo e(URL('/')); ?>/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="<?php echo e(URL('/')); ?>/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="<?php echo e(URL('/')); ?>/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true"
                                                     style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uoredu/public_html/uor/resources/views/front/department_detail/department_of_interior_design.blade.php ENDPATH**/ ?>