<?php $__env->startPush('head-scripts'); ?>
    <meta name="description" content="Welcome to the University of Rawalpindi, where learning boldly and impacting broadly define our journey. As a new institution, we honor our traditional roots while embracing the future with cutting-edge technology and AI. Our hands-on, forward-thinking curriculum is designed to prepare you for leadership and innovation in a dynamic world. Join our vibrant, inclusive community that celebrates global connections, teamwork, and personal growth. Together, let's build a transformative educational experience where you can truly learn boldly and impact broadly." />
    <meta name="keywords" content="University of Rawalpindi, UOR, University in Rawalpindi, Rawalpindi University, University Rawalpindi" />
    <meta name="author" content="University of Rawalpindi"/>
    <meta name="robots" content="index, follow" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Hero Banner Area Start Here -->

    <div class="hero-wrap style1 bg-f hero-bg-1">
        <div class="o-overlay bg-black op-7"></div>
        <div class="container">
            <div class="row">
                <div class="col-lg-7 col-md-8">
                    <div class="hero-content">
                        <h1>Your Journey To Global <br> Impact Starts Here</h1>
                        <h3><span class="px-2">Learn Boldly, Impact Broadly.</span></h3>
                        <a href="<?php echo e(route('front.programs')); ?>" class="default-big-btn mt-2">Discover Our
                            Programs</a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- About Page 1 Area Start Here -->
    <div class="about-page1-area" id="aboutArea">
        <div class="container">
            <div class="row about-page1-inner">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                    <div class="about-page-content-holder">
                        <div class="content-box">
                            <h2>Introduction</h2>
                            <p>Welcome to the University of Rawalpindi, where learning boldly and impacting broadly
                                define our journey. As a new institution, we honor our traditional roots while embracing
                                the future with cutting-edge technology and AI. Our hands-on, forward-thinking
                                curriculum is designed to prepare you for leadership and innovation in a dynamic world.
                                Join our vibrant, inclusive community that celebrates global connections, teamwork, and
                                personal growth. Together, let's build a transformative educational experience where you
                                can truly learn boldly and impact broadly.
                            </p>
                            <p>Explore more about our vision, mission, and unique journey
                                <a href="<?php echo e(route('front.about-us')); ?>">here</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                    <div class="about-page-img-holder">
                        <img src="<?php echo e('frontend/academics/'); ?>/img/about/intro.png" class="img-responsive" alt="about">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About Page 1 Area End Here -->

    <!-- Publications Area Start Here -->
    <div class="publications-area">
        <div class="container">
            <h2 class="title-default-left">Explore our Programs</h2>
        </div>
        <div class="container">
            <div class="rc-carousel" data-loop="true" data-items="4" data-margin="30" data-autoplay="true"
                 data-autoplay-timeout="10000" data-smart-speed="2000" data-dots="false" data-nav="true"
                 data-nav-speed="false" data-r-x-small="1" data-r-x-small-nav="true"
                 data-r-x-small-dots="false" data-r-x-medium="2" data-r-x-medium-nav="true" data-r-x-medium-dots="false"
                 data-r-small="3" data-r-small-nav="true" data-r-small-dots="false" data-r-medium="4"
                 data-r-medium-nav="true" data-r-medium-dots="false"
                 data-r-large="4" data-r-large-nav="true" data-r-large-dots="false">





































































































































































                 
                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_BBA.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-of-business-administration">ADP
                                   </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bachelor-of-business-administration">BS
                                </a>
                                    <h5>
                                        <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-applied-business-and-economics"  style="color: black">
                                            Business Administration
                                        </a>
                                    </h5>
                            </h3>

                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_AF.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-accounting-and-finance"> ADP </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-accounting-and-finance"> BS
                                  </a>
                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-applied-business-and-economics"  style="color: black">
                                        Accounting and
                                        Finance
                                    </a>
                                </h5>

                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>


                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_MC.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title">
                                <a href="<?php echo e(URL('/')); ?>/course-detail/adp-media-and-communication-studies"> ADP
                                    </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-media-and-communication-studies"> BS </a>


                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-behavioral-and-social-sciences"  style="color: black">
                                        Media and
                                        Communication Studies
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_DC.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-digital-design-and-computer-arts">ADP</a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-digital-design-and-computer-arts">BS
                                    </a>


                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-art-and-digital-media"  style="color: black">
                                        Digital Design and Computer
                                        Arts
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_ID.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-interior-design"> ADP
                                    </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-interior-design"> BS
                                </a>
                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-interior-design"  style="color: black">
                                        Interior Design
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_IS.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-islamic-science">ADP </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-islamic-science">BS </a>
                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-islamic-studies-and-jurisprudence"  style="color: black">
                                        Islamic
                                        Sciences
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_PSY.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-psychology">ADP
                                    </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-psychology">BS
                                </a>

                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-behavioral-and-social-sciences"  style="color: black">
                                        Psychology
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_CS.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-computer-science">ADP
                                    </a>/
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-computer-science">BS  </a>

                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-computing-and-intelligent-systems"  style="color: black">
                                        Computer
                                        Science
                                    </a>
                                </h5>
                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>


                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_SE.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-software-engineering"> ADP   </a>/
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-software-engineering"> BS </a>

                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-computing-and-intelligent-systems"  style="color: black">
                                        Software
                                        Engineering
                                    </a>
                                </h5>

                            </h3>
                        </div>
                        <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"  class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>

                <div class="single-item">
                    <div class="single-item-wrapper">
                        <div class="publications-img-wrapper">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>"><img class="img-responsive"
                                                                                    src="<?php echo e(asset('frontend/academics/img/program/ADP_EL.png')); ?>"
                                                                                    alt="program"></a>
                        </div>
                        <div class="publications-content-wrapper">
                            <h3 class="item-title"><a href="<?php echo e(URL('/')); ?>/course-detail/adp-english_and_linguistic_studies">ADP
                                    </a> /
                                <a href="<?php echo e(URL('/')); ?>/course-detail/bs-english_and_linguistic_studies">BS</a>

                                <h5>
                                    <a href="<?php echo e(URL('/')); ?>/department-detail/department-of-linguistic-and-cultural-studies"  style="color: black">
                                        English and
                                        Linguistic Studies
                                    </a>
                                </h5>
                            </h3>
                        </div>
                         <div class="buy-now-btn-area">
                            <a href="<?php echo e(url('https://admission.uor.edu.pk/')); ?>" class="ghost-btn">Apply Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Publications Area End Here -->


    <!-- Video Area Start Here -->

    <!-- Video Area End Here -->

    <!-- About Page 2 Area Start Here -->
    <div class="about-page2-area">
        <div class="container">
            <div class="row about-page2-inner">
                <div class="col-12">
                    <h2 class="title-default-left">Why Choose Us ?</h2>
                    <!-- why choose us area Start Here -->
                    <div class="faq-page-area">
                        <p>The University of Rawalpindi is embarking on an exciting journey to become a leading
                            institution
                            in the region. Here’s why you should be part of our groundbreaking story:
                        </p>
                        <div class="container p-sm-5 p-md-0">
                            <div class="faq-items" id="accordionFaq">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingOne">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                                        aria-expanded="false" aria-controls="collapseOne"><span
                                                        class="faq-count">1</span>Innovative Curriculum
                                                </button>
                                            </div>
                                            <div id="collapseOne" class="accordion-collapse collapse"
                                                 aria-labelledby="headingOne" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Embrace the future with our hands-on learning that
                                                    integrates the latest in technology and AI, ensuring you gain
                                                    practical skills that meet industry demands.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                        aria-expanded="false" aria-controls="collapseTwo"><span
                                                        class="faq-count">2</span>Strategic Location
                                                </button>
                                            </div>
                                            <div id="collapseTwo" class="accordion-collapse collapse"
                                                 aria-labelledby="headingTwo" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Study on the main GT Road near DHA-1 in
                                                    Rawalpindi. Enjoy the convenience and vibrancy of being close to the
                                                    city's rich cultural, historical, and recreational attractions.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingThree">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                        aria-expanded="false" aria-controls="collapseThree"><span
                                                        class="faq-count">3</span>Vision for Global Collaboration
                                                </button>
                                            </div>
                                            <div id="collapseThree" class="accordion-collapse collapse"
                                                 aria-labelledby="headingThree" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">We aspire to forge local and international
                                                    partnerships, providing opportunities for collaborative growth and
                                                    diverse cultural experiences.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingFour">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                                        aria-expanded="false" aria-controls="collapseFour"><span
                                                        class="faq-count">4</span>Commitment to Sustainability
                                                </button>
                                            </div>
                                            <div id="collapseFour" class="accordion-collapse collapse"
                                                 aria-labelledby="headingFour" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Our forthcoming state-of-the-art campus is being
                                                    developed with a focus on sustainability, incorporating green
                                                    technologies and responsible practices.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingFive">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseFive"
                                                        aria-expanded="false" aria-controls="collapseFive"><span
                                                        class="faq-count">5</span>Dynamic Community
                                                </button>
                                            </div>
                                            <div id="collapseFive" class="accordion-collapse collapse"
                                                 aria-labelledby="headingFive" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Join a vibrant, inclusive environment that values
                                                    diversity, global citizenship, and collaboration. Engage in a range
                                                    of extracurricular activities and student organizations.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingSix">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseSix"
                                                        aria-expanded="false" aria-controls="collapseSix"><span
                                                        class="faq-count">6</span>Entrepreneurial Spirit
                                                </button>
                                            </div>
                                            <div id="collapseSix" class="accordion-collapse collapse"
                                                 aria-labelledby="headingSix" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">We nurture creativity and entrepreneurship,
                                                    preparing you to turn ideas into impactful ventures with future
                                                    spaces dedicated to supporting innovation.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingSeven">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseSeven"
                                                        aria-expanded="false" aria-controls="collapseSeven"><span
                                                        class="faq-count">7</span>Experienced Faculty
                                                </button>
                                            </div>
                                            <div id="collapseSeven" class="accordion-collapse collapse"
                                                 aria-labelledby="headingSeven" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Learn from industry professionals and academic
                                                    experts who bring a wealth of knowledge and are dedicated to
                                                    mentoring and guiding you towards success.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingEight">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseEight"
                                                        aria-expanded="false" aria-controls="collapseEight"><span
                                                        class="faq-count">8</span>State-of-the-Art Facilities
                                                </button>
                                            </div>
                                            <div id="collapseEight" class="accordion-collapse collapse"
                                                 aria-labelledby="headingEight" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">While our future campus will feature modern
                                                    facilities, our current campus provides all the necessary tools to
                                                    support your educational journey.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingNine">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseNine"
                                                        aria-expanded="false" aria-controls="collapseNine"><span
                                                        class="faq-count">9</span>Career Opportunities
                                                </button>
                                            </div>
                                            <div id="collapseNine" class="accordion-collapse collapse"
                                                 aria-labelledby="headingNine" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">We are committed to your success beyond
                                                    graduation, offering robust career services including internships,
                                                    job fairs, and networking events with top employers.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingTen">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseTen"
                                                        aria-expanded="false" aria-controls="collapseTen"><span
                                                        class="faq-count">10</span>Holistic Development
                                                </button>
                                            </div>
                                            <div id="collapseTen" class="accordion-collapse collapse"
                                                 aria-labelledby="headingTen" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Education at UoR goes beyond academics. We offer a
                                                    wide range of extracurricular activities, ensuring you have ample
                                                    opportunities to explore your interests and develop new skills.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingEleven">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseEleven"
                                                        aria-expanded="false" aria-controls="collapseEleven"><span
                                                        class="faq-count">11</span>Supportive Community
                                                </button>
                                            </div>
                                            <div id="collapseEleven" class="accordion-collapse collapse"
                                                 aria-labelledby="headingEleven" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">You’ll find a welcoming and inclusive community at
                                                    UoR, with comprehensive student services and counseling designed to
                                                    support your growth and well-being.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="faq-item">
                                            <div class="faq-title" id="headingTwelve">
                                                <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseTwelve"
                                                        aria-expanded="false" aria-controls="collapseTwelve"><span
                                                        class="faq-count">12</span>High-Quality Accommodation
                                                </button>
                                            </div>
                                            <div id="collapseTwelve" class="accordion-collapse collapse"
                                                 aria-labelledby="headingTwelve" data-bs-parent="#accordionFaq">
                                                <div class="faq-body">Our campus offers excellent on-campus
                                                    accommodation, particularly high-quality options for female
                                                    students, ensuring a safe and comfortable living environment.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- why choose us area End Here -->
                </div>
            </div>
        </div>
    </div>
    <!-- About Page 2 Area End Here -->

    <!-- News and Event Area Start Here -->
    <div class="news-event-area">
        <div class="container">
            <div class="row">
                <h1 class="title-default-center">News and Events</h1>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 news-inner-area">
                    <?php if(count($newsAndEvents) > 0): ?>
                        <ul  class=" news-wrapper wow fadeIn" data-wow-duration="2s" data-wow-delay=".1s" style="visibility: visible; animation-duration: 2s; animation-delay: 0.1s; animation-name: fadeIn;">
                            <?php $__currentLoopData = $newsAndEvents->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li >
                                    <div class="news-img-holder">
                                        <a href="<?php echo e(route('news-events-details', $item->slug)); ?>"><img
                                                src="<?php echo e(asset("storage/News-and-Events/thumbnail/{$item->thumbnail}")); ?>"
                                                class="img-responsive" alt="news"
                                                style="max-width: 148px; max-height: 111px"></a>
                                        <span class="latest-research-content"><?php echo e($item->type); ?></span>
                                    </div>
                                    <div class="news-content-holder">
                                        <h3><a href="<?php echo e(route('news-events-details', $item->slug)); ?>"><?php echo e($item->title); ?></a></h3>
                                        <div class="post-date"><?php echo e($item->date); ?></div>
                                        <p><?php echo e($item->summary); ?></p>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <h3 class="title-news-left-bold">No News or Events found</h3>
                    <?php endif; ?>
                </div>
                <?php if(count($newsAndEvents) > 3): ?>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 news-inner-area">
                        <ul  class=" news-wrapper wow fadeIn" data-wow-duration="2s" data-wow-delay=".1s" style="visibility: visible; animation-duration: 2s; animation-delay: 0.1s; animation-name: fadeIn;">
                                <?php $__currentLoopData = $newsAndEvents->skip(3)->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li >
                                    <div class="news-img-holder">
                                        <a href="<?php echo e(route('news-events-details', $item->slug)); ?>"><img
                                                src="<?php echo e(asset("storage/News-and-Events/thumbnail/{$item->thumbnail}")); ?>"
                                                class="img-responsive" alt="news"
                                                style="max-width: 148px; max-height: 111px"></a>
                                        <div class="latest-research-content"><?php echo e($item->type); ?></div>
                                    </div>
                                    <div class="news-content-holder">
                                        <h3><a href="<?php echo e(route('news-events-details', $item->slug)); ?>"><?php echo e($item->title); ?></a></h3>
                                        <div class="post-date"><?php echo e($item->date); ?></div>
                                        <p><?php echo e($item->summary); ?></p>
                                    </div>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                    </div>
                <?php endif; ?>
                <div class="event-btn-holder">
                    <a href="<?php echo e(route('news-events')); ?>" class="view-all-accent-btn">View All</a>
                </div>
            </div>
    </div>
    </div>

    <!-- News and Event Area End Here -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer-scripts'); ?>
    <script src="<?php echo e(asset('admin/toastr/toastr.min.js')); ?>"></script>

    <?php if(Session::has('messages')): ?>
        <script>
            noti(<?php echo json_encode((Session::get('messages'))); ?>);
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uoredu/public_html/uor/resources/views/front/index.blade.php ENDPATH**/ ?>