<?php

use App\Http\Controllers\Manager\NewsandEvents\CategoryController;
use App\Http\Controllers\Manager\NewsandEvents\NewsandEventController;
use Illuminate\Support\Facades\Route;



/*
|--------------------------------------------------------------------------
| Manager Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the prefix "admin" middleware group. Now create something great!
|
*/
//Manager Routes



Route::group(['middleware' => ['auth','verified','xss','user.status','user.module:manager'], 'prefix' => 'manager','as' => 'manager.'], function() {

    //Category
    Route::resource('news-and-event-category', CategoryController::class);
    Route::get('get-news-and-event-category', [CategoryController::class, 'getIndex'])->name('get.news-and-event-category');
    Route::get('get-news-and-event-category-select', [CategoryController::class, 'getIndexSelect'])->name('get.news-and-event-category-select');
    Route::get('get-news-and-event-category-activity/{id}', [CategoryController::class, 'getActivity'])->name('get.news-and-event-category-activity');
    Route::get('get-news-and-event-category-activity-log/{id}', [CategoryController::class, 'getActivityLog'])->name('get.news-and-event-category-activity-log');
    Route::get('get-news-and-event-category-activity-trash', [CategoryController::class, 'getTrashActivity'])->name('get.news-and-event-category-activity-trash');
    Route::get('get-news-and-event-category-activity-trash-log', [CategoryController::class, 'getTrashActivityLog'])->name('get.news-and-event-category-activity-trash-log');
    Route::get('get-news-and-event-category/{id}', [CategoryController::class, 'sessionStatus'])->name('news-and-event-category-session-status');


    //News and Events
    Route::resource('news-and-event', NewsandEventController::class)->withoutMiddleware('xss');
    Route::get('get-news-and-event', [NewsandEventController::class, 'getIndex'])->name('get.news-and-event');
    Route::get('get-news-and-event-select', [NewsandEventController::class, 'getIndexSelect'])->name('get.news-and-event-select');
    Route::get('get-news-and-event-activity/{id}', [NewsandEventController::class, 'getActivity'])->name('get.news-and-event-activity');
    Route::get('get-news-and-event-activity-log/{id}', [NewsandEventController::class, 'getActivityLog'])->name('get.news-and-event-activity-log');
    Route::get('get-news-and-event-activity-trash', [NewsandEventController::class, 'getTrashActivity'])->name('get.news-and-event-activity-trash');
    Route::get('get-news-and-event-activity-trash-log', [NewsandEventController::class, 'getTrashActivityLog'])->name('get.news-and-event-activity-trash-log');
    Route::get('get-news-and-events/{id}', [NewsandEventController::class, 'sessionStatus'])->name('news-and-event-session-status');


});
