<?php

use App\Http\Controllers\Manager\ContactUs\ContactUsController;
use App\Http\Controllers\Manager\NewsandEvents\NewsandEventController;
use Illuminate\Support\Facades\Route;



/*
|--------------------------------------------------------------------------
| Manager Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the prefix "admin" middleware group. Now create something great!
|
*/
//Manager Routes



Route::group(['middleware' => ['auth','verified','xss','user.status','user.module:manager'], 'prefix' => 'manager','as' => 'manager.'], function() {

    //Category
    Route::resource('contact-us', ContactUsController::class);
    Route::get('get-contact-us', [ContactUsController::class, 'getIndex'])->name('get.contact-us');
    Route::get('get-contact-us-select', [ContactUsController::class, 'getIndexSelect'])->name('get.contact-us-select');
    Route::get('get-contact-us-activity/{id}', [ContactUsController::class, 'getActivity'])->name('get.contact-us-activity');
    Route::get('get-contact-us-activity-log/{id}', [ContactUsController::class, 'getActivityLog'])->name('get.contact-us-activity-log');
    Route::get('get-contact-us-activity-trash', [ContactUsController::class, 'getTrashActivity'])->name('get.contact-us-activity-trash');
    Route::get('get-contact-us-activity-trash-log', [ContactUsController::class, 'getTrashActivityLog'])->name('get.contact-us-activity-trash-log');
    Route::get('get-contact-us/{id}', [ContactUsController::class, 'sessionStatus'])->name('contact-us-session-status');

});
