<?php

use App\Http\Controllers\Front\CarrerAssessmentController;
use App\Http\Controllers\Front\ContactUsController;
use App\Http\Controllers\Front\DepartmentDetailController;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\HomePageController;
use App\Http\Controllers\Front\ProgramDetailController;
use App\Http\Controllers\Front\ScholarshipController;
use App\Http\Controllers\Front\SubscribersController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Frontend Routes
|--------------------------------------------------------------------------
|
| Here is where you can register frontend web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the prefix "admin" middleware group. Now create something great!
|
*/
//Frontend Routes

//Route::get('/', function () {
//    return view('front.index');
//})->name('front.home');
Route::get('/', [HomePageController::class, 'index'])->name('front.home');

//News and Events
Route::get('news-events', [HomePageController::class, 'newsEvent'])->name('news-events');
Route::get('news-event/{slug}', [HomePageController::class, 'newsEventDetail'])->name('news-events-details');

// Contact Us
Route::resource('contact-us', ContactUsController::class, ['only' => ['index', 'store']])->middleware('xss');

Route::get('about-us', function () {
    return view('front.about_us');
})->name('front.about-us');

Route::get('history-rawalpindi', function () {
    return view('front.history_rawalpindi');
})->name('front.history-rawalpindi');

//Route::get('campus-facilities', function () {
//    return view('front.campus_facilities');
//})->name('front.campus-facilities');

Route::get('programs', function () {
    return view('front.programs');
})->name('front.programs');

Route::get('fee-structure', function () {
    return view('front.fee_structure');
})->name('front.fee-structure');

Route::get('admission-faq', function () {
    return view('front.admission_faq');
})->name('front.admission-faq');

Route::get('privacy-policy', function () {
    return view('front.privacy_policy');
})->name('front.privacy-policy');

Route::get('fee-policy', function () {
    return view('front.fee_policy');
})->name('front.fee-policy');

Route::get('faculties-and-departments', function () {
    return view('front.faculties_and_departments');
})->name('front.faculties-and-departments');

//Route::get('departments', function () {
//    return view('front.departments');
//})->name('front.departments');


Route::get('student-life', function () {
    return view('front.student-life');
})->name('front.student-life');



Route::get('/career-assessment', [CarrerAssessmentController::class, 'index'])->name('enterPhone');
Route::post('/career-assessment/detail', [CarrerAssessmentController::class, 'checkPhoneNumber'])->name('career-assessment.detail');
Route::get('/assessment-detail/{id}', [CarrerAssessmentController::class, 'showDetail'])->name('assessment.detail');
Route::get('/generate-pdf/{id}', [CarrerAssessmentController::class, 'generatePDF'])->name('generate.pdf');

// scholarship
Route::get('/scholarship', [ScholarshipController::class, 'index'])->name('scholarship');
Route::get('/scholarship-detail/{slug}', [ScholarshipController::class, 'scholarshipDetail'])->name('scholarship-detail');
//Route::get('/all-scholarship', [ScholarshipController::class, 'scholarshipAll'])->name('scholarship-all');

//Route::get('news-events', function () {
//    return view('front.news_events');
//})->name('front.news-events');

//Route::get('co-curricular-activities', function () {
//    return view('front.co-curricular_activities');
//})->name('front.co-curricular-activities');
//
//Route::get('student-societies', function () {
//    return view('front.student_societies');
//})->name('front.student-societies');
//
//Route::get('housing-transport', function () {
//    return view('front.housing_transport');
//})->name('front.housing-transport');
//
//Route::get('news-letters', function () {
//    return view('front.news_letters');
//})->name('front.news-letters');



// Program Details
Route::get('course-detail/{slug}', [ProgramDetailController::class, 'index'])->name('front.course-detail');

// Department Details
Route::get('department-detail/{slug}', [DepartmentDetailController::class, 'index'])->name('front.department-detail');


//Subscriber Mailchimp
Route::post('subscribe', [SubscribersController::class, 'subscribe'])->name('front.subscribe');

Route::get('thumbnail-image/{id}',[HomePageController::class,'getThumbnailImage'])->name('thumbnail.get.image');
Route::get('cover-image/{id}',[HomePageController::class,'getCoverImage'])->name('cover.get.image');

Route::get('trainings', function () {
    return view('front.training');
});
