@extends('manager.layouts.app')
@section('page_title')
    {{(!empty($page_title) && isset($page_title)) ? $page_title : ''}}
@endsection
@push('head-scripts')
    <link rel="stylesheet" href="{{ asset('admin/select2/dist/css/select2.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin/select2/dist/css/select2-bootstrap5.min.css') }}"/>
    <link href="{{ asset('manager/cropper/cropper.min.css') }}" rel="stylesheet"/>
    <style>
        img{
            max-width: 100%;

        }
    </style>
@endpush
@section('content')
    <div class="card mt-3">
        <div class="card-body">
            {{-- Start: Page Content --}}
            <div class="d-flex justify-content-between">
                <div>
                    <h4 class="card-title mb-0">{{(!empty($p_title) && isset($p_title)) ? $p_title : ''}}</h4>
                    <div class="small text-medium-emphasis">{{(!empty($p_summary) && isset($p_summary)) ? $p_summary : ''}}</div>
                </div>
                <div class="btn-toolbar d-none d-md-block" role="toolbar" aria-label="Toolbar with buttons">
                    @can('manager_news-event_list')
                        <a href="{{(!empty($url) && isset($url)) ? $url : ''}}" class="btn btn-sm btn-primary">{{(!empty($url_text) && isset($url_text)) ? $url_text : ''}}</a>
                    @endcan
                </div>
            </div>
            <hr>
            {{-- Start: Form --}}
            <form method="{{$method}}" action="{{$action}}" enctype="{{$enctype}}">
                @csrf
                @method('PUT')
                <div class="mb-3">
                    <label class="form-label" for="name">Title</label>
                    <input type="text" disabled class="form-control @error('title') is-invalid @enderror" name="title" id="title"  placeholder="Title" value="{{(isset($data) ? $data->title : old('title'))}}">
                    @error('title')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                <div class="row">
                    <div class="col-6">
                        <div class="mb-3">
                            <label class="form-label"  for="news_and_events_category_id">Category</label>
                            <select class="form-control @error('news_and_events_category_id') is-invalid @enderror" disabled name="news_and_events_category_id">
                                @foreach($categories as $category)
                                    <option value="{{$category->id}}" {{ old('news_and_events_category_id', $data->news_and_events_category_id) == $category->id ? 'selected' : '' }}>
                                        {{$category->name}}
                                    </option>
                                @endforeach
                            </select>
                            @error('news_and_events_category_id')
                            <strong class="text-danger">{{ $message }}</strong>
                            @enderror
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="mb-3">
                            <label class="form-label" for="slug">Date</label>
                            <input type="text" disabled class="form-control @error('date') is-invalid @enderror" name="date" id="date" placeholder="Date" value="{{(isset($data) ? $data->date : old('date'))}}">
                            @error('date')
                            <strong class="text-danger">{{ $message }}</strong>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="description">Short Description</label>
                    <textarea  type="text" required  disabled rows="5"  class="form-control @error('summary') is-invalid @enderror"  name="summary">{{(isset($data) ? $data->summary : old('summary'))}} </textarea>
                    @error('summary')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label" for="description">Description</label>
                    <textarea  type="text" disabled required id="news-and-event-description"  class="form-control @error('description') is-invalid @enderror"  name="description">{!! (isset($data->description))?$data->description:old('description') !!}</textarea>
                    @error('description')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                    <div class="mb-3">
                        <label class="form-label" for="type">Type</label>
                        <select disabled
                                class="form-control form-select @error('status.*') is-invalid @enderror"
                                name="type">
                            <option value="news" {{(isset($data->type)) && $data->type == 'news'  ? 'selected' : ''}}>
                                News
                            </option>
                            <option value="event" {{(isset($data->type)) && $data->type == 'event'  ? 'selected' : ''}}>
                                Event
                            </option>
                        </select>
                        @error('type')
                        <strong class="text-danger">{{ $message }}</strong>
                        @enderror
                    </div>

                <div class="row">
                    <div class="col-md-6 mb-3" id="thumbnail_input">
                        <label class="form-label" for="thumbnail">Thumbnail</label>
                        <div class="col-6 img-fluid">
                            <img src="{{ asset("storage/News-and-Events/thumbnail/{$data->thumbnail}") }}"
                                 class="img-fluid rounded-start" alt="Event Thumbnail">
                        </div>
                        @if ($errors->has('thumbnail'))
                            <span class="text-danger">{{ $errors->first('thumbnail') }}</span>
                        @endif
                    </div>
                    <div class="col-md-6 mb-3" id="cover_input">
                        <label class="form-label" for="cover_image">Cover Image</label>
                        <div class="col-6 img-fluid">
                            <img src="{{ asset("storage/News-and-Events/Cover/{$data->cover_image}") }}"
                                 class="img-fluid rounded-start" alt="Event Thumbnail">
                        </div>                        @if ($errors->has('cover_image'))
                            <span class="text-danger">{{ $errors->first('cover_image') }}</span>
                        @endif
                    </div>
                </div>
            </form>
            {{-- End: Form --}}
            {{-- Page Description : Start --}}
            @if(!empty($p_description) && isset($p_description))
                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 mb-sm-2 mb-0">
                            <p>{{(!empty($p_description) && isset($p_description)) ? $p_description : ''}}</p>
                        </div>
                    </div>
                </div>
            @endif
            {{-- Page Description : End --}}
            {{-- End: Page Content --}}
        </div>
    </div>
@endsection
@push('footer-scripts')
    <script src="{{ asset('manager/select2/dist/js/select2.js') }}"></script>
    <script src="{{ asset('manager/cropper/cropper.js') }}"></script>
    <!-- ckeditor -->
    <script src="{{asset('manager/ckeditor/ckeditor.js')}}"></script>
    <script src="{{asset('manager/ckeditor/ckfinder/ckfinder.js')}}"></script>
    <script src="{{asset('manager/ckeditor/samples/js/sample.js')}}"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            //Select Module
            $('.select2-options-category-id').select2({
                theme: "bootstrap5",
                placeholder: 'Select Category',
                allowClear: true,
                ajax: {
                    url: '{{route('manager.get.news-and-event-category-select')}}',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    id: item.id,
                                    text: item.name,
                                }
                            })
                        };
                    },
                    cache: true
                }
            });
        })
    </script>

    <script>
        $(document).ready(function() {

            var editor = CKEDITOR.replace( 'news-and-event-description');
        });
    </script>
    {{-- Toastr : Script : Start --}}
    @if(Session::has('messages'))
        <script>
            noti({!! json_encode((Session::get('messages'))) !!});
        </script>
    @endif
    {{-- Toastr : Script : End --}}
@endpush
