@extends('manager.layouts.app')
@section('page_title')
    {{(!empty($page_title) && isset($page_title)) ? $page_title : ''}}
@endsection
@push('head-scripts')
    <link rel="stylesheet" href="{{ asset('admin/select2/dist/css/select2.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin/select2/dist/css/select2-bootstrap5.min.css') }}"/>
    <link href="{{ asset('manager/cropper/cropper.min.css') }}" rel="stylesheet"/>
    <style>
        img{
            max-width: 100%;

        }
    </style>
@endpush
@section('content')
    <div class="card mt-3">
        <div class="card-body">
            {{-- Start: Page Content --}}
            <div class="d-flex justify-content-between">
                <div>
                    <h4 class="card-title mb-0">{{(!empty($p_title) && isset($p_title)) ? $p_title : ''}}</h4>
                    <div class="small text-medium-emphasis">{{(!empty($p_summary) && isset($p_summary)) ? $p_summary : ''}}</div>
                </div>
                <div class="btn-toolbar d-none d-md-block" role="toolbar" aria-label="Toolbar with buttons">
                    @can('manager_news-event_list')
                        <a href="{{(!empty($url) && isset($url)) ? $url : ''}}" class="btn btn-sm btn-primary">{{(!empty($url_text) && isset($url_text)) ? $url_text : ''}}</a>
                    @endcan
                </div>
            </div>
            <hr>
            {{-- Start: Form --}}
            <form method="{{$method}}" action="{{$action}}" enctype="{{$enctype}}">
                @csrf
                <div class="mb-3">
                    <label class="form-label" for="name">Title</label>
                    <input type="text" required class="form-control @error('title') is-invalid @enderror" name="title" id="title"  placeholder="Title" value="{{old('title')}}">
                    @error('title')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                <div class="mb-3">
                    <div class="row">

                    <div class="col-6">
                        <div class="row gy-2 gx-3 align-items-center">
                            <label>Select Category</label>
                            <div class="col-12">
                                <select required class="select2-options-category-id form-control form-control" name="news_and_events_category_id" id="category-id" autocomplete="category-id"></select>
                            </div>
                        </div>
                        @error('news_and_events_category_id')
                        <strong class="text-danger">{{ $message }}</strong>
                        @enderror
                    </div>
                    <div class="col-6">
                        <label class="form-label" for="slug">Date</label>
                        <input type="date" required class="form-control @error('date') is-invalid @enderror" name="date" id="date" placeholder="Date" value="{{old('date')}}">
                        @error('slug')
                        <strong class="text-danger">{{ $message }}</strong>
                        @enderror
                    </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="description">Short Description</label>
                        <textarea  type="text" required  rows="5" maxlength="250" placeholder="For Summary Max length of Character is 255"  class="form-control @error('summary') is-invalid @enderror"  name="summary">{{old('summary')}}</textarea>
                        @error('summary')
                        <strong class="text-danger">{{ $message }}</strong>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="description">Description</label>
                        <textarea  type="text" required id="news-and-event-description"  class="form-control @error('description') is-invalid @enderror"  name="description">{{old('description')}}</textarea>
                        @error('description')
                        <strong class="text-danger">{{ $message }}</strong>
                        @enderror
                    </div>


                    <div class="row">
                    <div class="col-md-6 mb-3" id="thumbnail_input">
                        <label class="form-label" for="thumbnail">Thumbnail</label>
                        <input type="file"  id="thumbnail-cropper" accept=".png, .jpg, .jpeg" name="thumbnail"  class="form-control rounded-0 thumbnail-cropper @error('thumbnail') is-invalid @enderror"  value="{{('thumbnail')}}">
                        @if ($errors->has('thumbnail'))
                            <span class="text-danger">{{ $errors->first('thumbnail') }}</span>
                        @endif
                    </div>
                    <div class="col-md-6 mb-3" id="cover_input">
                        <label class="form-label" for="cover_image">Cover Image</label>
                        <input type="file"  id="cover-cropper" accept=".png, .jpg, .jpeg" name="cover_image"  class="form-control rounded-0 cover-cropper @error('cover_image') is-invalid @enderror"   value="{{('cover_image')}}">
                        @if ($errors->has('cover_image'))
                            <span class="text-danger">{{ $errors->first('cover_image') }}</span>
                        @endif
                    </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="type">Type</label>
                    <select name="type"
                            class="form-control @error('type') is-invalid @enderror">
                        <option value="">Select Type</option>
                        <option value="news">News</option>
                        <option value="event">Event</option>
                    </select>
                    @error('type')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label" for="status">Status</label>
                    <select name="status"
                            class="form-control @error('status') is-invalid @enderror">
                        <option value="1">Active</option>
                        <option value="0">In Active</option>
                    </select>
                    @error('status')
                    <strong class="text-danger">{{ $message }}</strong>
                    @enderror
                </div>
                <button type="submit" class="btn btn-sm btn-success">Submit</button>
            </form>
            {{-- End: Form --}}
            {{--            Uploading Profile Image Modal--}}
            <div class="modal fade bd-example-modal-lg imageCropImg" id="model_document" tabindex="-1" role="dialog"
                 aria-labelledby="cropperModalLabel" aria-hidden="true" data-coreui-backdrop="static">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="cropperModal">Crop Thumbnail</h5>
                            <button type="button" class="close btn-close" id="reset-image"
                                    data-coreui-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="img-container">
                                <div class="row">
                                    <div class="col-md-11">
                                        <img class="cropper-image" id="previewImage" src="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" id="reset-image-close"
                                    data-coreui-dismiss="modal">Close
                            </button>
                            <button type="button" class="btn btn-secondary crop" id="cropImage">Crop
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            {{--  End: Modal--}}
            {{--            Uploading Profile Image Modal--}}
            <div class="modal fade bd-example-modal-lg coverCropImg" id="model_cover" tabindex="-1" role="dialog"
                 aria-labelledby="cropperModalLabel" aria-hidden="true" data-coreui-backdrop="static">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="cropperModal2">Crop Cover Image</h5>
                            <button type="button" class="close btn-close" id="reset-image"
                                    data-coreui-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="img-container">
                                <div class="row">
                                    <div class="col-md-11">
                                        <img class="cropper-image" id="previewImage2" src="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" id="reset-image-close"
                                    data-coreui-dismiss="modal">Close
                            </button>
                            <button type="button" class="btn btn-secondary crop" id="cropImage2">Crop
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            {{--  End: Modal--}}
            {{-- Page Description : Start --}}
            @if(!empty($p_description) && isset($p_description))
                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 mb-sm-2 mb-0">
                            <p>{{(!empty($p_description) && isset($p_description)) ? $p_description : ''}}</p>
                        </div>
                    </div>
                </div>
            @endif
            {{-- Page Description : End --}}
            {{-- End: Page Content --}}
        </div>
    </div>
@endsection
@push('footer-scripts')
    <script src="{{ asset('manager/select2/dist/js/select2.js') }}"></script>
    <script src="{{ asset('manager/cropper/cropper.js') }}"></script>
    <!-- ckeditor -->
    <script src="{{asset('manager/ckeditor/ckeditor.js')}}"></script>
    <script src="{{asset('manager/ckeditor/ckfinder/ckfinder.js')}}"></script>
    <script src="{{asset('manager/ckeditor/samples/js/sample.js')}}"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            //Select Module
            $('.select2-options-category-id').select2({
                theme: "bootstrap5",
                placeholder: 'Select Category',
                allowClear: true,
                ajax: {
                    url: '{{route('manager.get.news-and-event-category-select')}}',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    id: item.id,
                                    text: item.name,
                                }
                            })
                        };
                    },
                    cache: true
                }
            });
        })
    </script>

    <script>
        $(document).ready(function() {

            var editor = CKEDITOR.replace( 'news-and-event-description');
        });
    </script>
    <script>
        //Cover  Cropper
        $(document).ready(function () {
            $('#reset-image').on('click', function () {
                $('#cover-cropper').val('');
            });
            var $modal = $('#model_cover');

            var image = document.getElementById('previewImage2');

            var cropper;

            $("body").on("change", "#cover-cropper", function (e) {
                e.preventDefault();
                var files = e.target.files;
                var done = function (url) {
                    image.src = url;
                    $modal.modal('show');
                };
                var reader;
                var file;
                var URL;
                if (files && files.length > 0) {
                    file = files[0];
                    if (URL) {
                        done(URL.createObjectURL(file));
                    } else if (FileReader) {
                        reader = new FileReader();
                        reader.onload = function (e) {
                            done(reader.result);
                        };
                        reader.readAsDataURL(file);
                    }
                }
            });

            $modal.on('shown.coreui.modal', function () {
                cropper = new Cropper(image, {
                    dragMode: 'move',
                    aspectRatio: 4 / 3,
                    autoCropArea: 0.75,
                    viewMode: 1,
                    restore: false,
                    guides: false,
                    center: false,
                    highlight: false,
                    cropBoxMovable: false,
                    cropBoxResizable: false,
                    toggleDragModeOnDblclick: false,
                });

            }).on('hidden.coreui.modal', function () {
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });
            $("body").on("click", "#cropImage2", function () {
                // if (cropper) {
                canvas = cropper.getCroppedCanvas({
                    //Add double width and height of image
                    width: 872,
                    height: 654,
                });

                canvas.toBlob(function (blob) {
                    // Crop & Convert it to image
                    const documentInput = document.getElementById("cover_input")
                    var x = document.createElement("INPUT");
                    x.setAttribute("type", "file");
                    x.setAttribute("name", "cover_image");
                    x.classList.add("d-none");
                    documentInput.appendChild(x);
                    const file = new File([blob], 'cover_image.jpg', {type: 'image/jpeg'});
                    const dataTransfer = new DataTransfer();
                    dataTransfer.items.add(file);
                    x.files = dataTransfer.files;

                    $modal.modal('hide');
                });
            });

        });
    </script>
    <script>
        //Profile Picture Cropper
        $(document).ready(function () {
            $('#reset-image').on('click', function () {
                $('#thumbnail-cropper').val('');
            });
            var $modal = $('#model_document');

            var image = document.getElementById('previewImage');

            var cropper;

            $("body").on("change", "#thumbnail-cropper", function (e) {
                e.preventDefault();
                var files = e.target.files;
                var done = function (url) {
                    image.src = url;
                    $modal.modal('show');
                };
                var reader;
                var file;
                var URL;
                if (files && files.length > 0) {
                    file = files[0];
                    if (URL) {
                        done(URL.createObjectURL(file));
                    } else if (FileReader) {
                        reader = new FileReader();
                        reader.onload = function (e) {
                            done(reader.result);
                        };
                        reader.readAsDataURL(file);
                    }
                }
            });

            $modal.on('shown.coreui.modal', function () {
                cropper = new Cropper(image, {
                    dragMode: 'move',
                    aspectRatio: 4  / 3,
                    autoCropArea: 0.75,
                    viewMode: 1,
                    restore: false,
                    guides: false,
                    center: false,
                    highlight: false,
                    cropBoxMovable: false,
                    cropBoxResizable: false,
                    toggleDragModeOnDblclick: false,
                });

            }).on('hidden.coreui.modal', function () {
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });
            $("body").on("click", "#cropImage", function () {
                // if (cropper) {
                canvas = cropper.getCroppedCanvas({
                    //Add double width and height of image
                    width: 420,
                    height: 315,
                });

                canvas.toBlob(function (blob) {
                    // Crop & Convert it to image
                    const documentInput = document.getElementById("thumbnail_input");
                    var x = document.createElement("INPUT");
                    x.setAttribute("type", "file");
                    x.setAttribute("name", "thumbnail");
                    x.classList.add("d-none");
                    documentInput.appendChild(x);
                        const file = new File([blob] ,'thumbnail.jpg', {type: 'image/jpeg'});
                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(file);
                        x.files = dataTransfer.files;

                    $modal.modal('hide');
                });
            });

        });
    </script>
    {{-- Toastr : Script : Start --}}
    @if(Session::has('messages'))
        <script>
            noti({!! json_encode((Session::get('messages'))) !!});
        </script>
    @endif
    {{-- Toastr : Script : End --}}
@endpush
