@extends('manager.layouts.app')

@section('page_title')
    {{(!empty($page_title) && isset($page_title)) ? $page_title : ''}}
@endsection

@push('head-scripts')
    <link href="{{ asset('admin/datatable/datatables.min.css') }}" rel="stylesheet" />
@endpush

@section('content')

    <div class="card shadow-sm border-0 rounded-3 mb-5">
        <div class="card-header  text-white" style="background-color: #3C4B64">
            <h3 class="mb-0">
                <i class="fas fa-user-check me-2"></i>Eligible
            </h3>
        </div>
        <div class="card-body">


            <div class="mb-5 p-4 bg-light rounded">
                <div class="d-flex align-items-center mb-3">
                    <i class="fas fa-file-csv text-secondary me-2 fs-5"></i>
                    <h5 class="mb-0"> Import File</h5>
                </div>

                <form method="POST" action="{{ route('manager.career-assessments.import') }}" enctype="multipart/form-data" id="importForm">
                    @csrf
                    <div class="mb-3 position-relative">
                        <input type="file" id="csvUpload" name="file" class="form-control position-absolute top-0 start-0 w-100 h-100 opacity-0" accept=".csv" required>
                        <label for="csvUpload" class="form-control text-center py-5 border border-2 border-secondary bg-white rounded" id="fileUploadLabel" style="cursor:pointer;">
                            <div>
                                <i class="fas fa-cloud-upload-alt fa-2x mb-2 text-secondary"></i>
                                <p class="mb-1">Drag & drop your file here or click to browse</p>
                                <p class="text-muted small">Supports: csv and Excel File</p>
                            </div>
                            <span id="fileName" class="d-block mt-2 text-muted small">No file selected</span>
                        </label>
                    </div>
                    <button type="submit" class="btn btn-success" id="submitBtn">
                        <i class="fas fa-upload me-2"></i>Submit
                    </button>
                </form>
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show mt-4" role="alert" id="successAlert">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show mt-4" role="alert" id="errorAlert">
                        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
            </div>

            <div class="mt-5 pt-4 border-top">
                <div class="d-flex align-items-center mb-3">
                    <i class="fas fa-file-download text-secondary me-2 fs-5"></i>
                    <h5 class="mb-0">Download Sample</h5>
                </div>
                <p class="text-muted">Download our sample to ensure proper formatting</p>
                <a href="{{ asset('manager/coreui/assets/img/uor_import.csv') }}" class="btn text-white" style="background-color: #3C4B64">
                    <i class="fas fa-download me-2"></i>Download Sample File
                </a>
            </div>



        </div>
    </div>

@endsection

@push('footer-scripts')
    <script src="{{ asset('admin/datatable/datatables.min.js') }}"></script>
    <script>
        $(document).ready(function () {
            const $fileInput = $('#csvUpload');
            const $fileNameDisplay = $('#fileName');
            const $submitBtn = $('#submitBtn');
            const $fileUploadLabel = $('#fileUploadLabel');
            const $successAlert = $('#successAlert');
            const $errorAlert = $('#errorAlert');

            if ($successAlert.length) {
                setTimeout(() => {
                    $successAlert.alert('close');
                }, 2000);
            }

            if ($errorAlert.length) {
                setTimeout(() => {
                    $errorAlert.alert('close');
                }, 2000);
            }
            

            $fileInput.on('change', function () {
                if (this.files.length > 0) {
                    $fileNameDisplay.text(this.files[0].name);
                    $submitBtn.prop('disabled', false);
                } else {
                    $fileNameDisplay.text('No file selected');
                    $submitBtn.prop('disabled', true);
                }
            });

            // Drag and drop effects
            $fileUploadLabel.on('dragenter dragover', function (e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).addClass('border-primary bg-light');
            });

            $fileUploadLabel.on('dragleave drop', function (e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).removeClass('border-primary bg-light');
            });

            $fileUploadLabel.on('drop', function (e) {
                const files = e.originalEvent.dataTransfer.files;
                $fileInput[0].files = files;
                $fileInput.trigger('change');
            });
        });
    </script>
@endpush
