@extends('front.layouts.app')
@section('content')

    <!-- Banner -->
    <div class="inner-page-banner-area"
         style="background-image: url('{{ asset('frontend/academics/img/scholarship/scholarship1.jpg') }}');">
        <div class="container">
            <div class="pagination-area">
                <h1>Special Scholarship</h1>
                <ul>
                    <li><a href="https://uor.edu.pk/">Home</a> -</li>
                    <li>Special Scholarship</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Left section  -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="course-details-inner">
                        <h2 class="title-default-left title-bar-high">Special Scholarship</h2>
                        <img src="{{ asset('frontend/academics/img/scholarship/special.jpg') }}" class="img-responsive"
                             alt="course">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <ul class="course-details-tab-btn nav" id="myTab" role="tablist">
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">Overview </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">Eligibility </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">Application
                                                Process </a></li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">Selection &
                                                Benefits
                                                For Special Scholarship
                                            </a></li>
                                    </ul>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <div class="tab-content">
                                        <div class="tab-pane tab-item animated fadeIn show active" id="menu-1"
                                             role="tabpanel" aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Overview</h3>
                                            <p>The University of Rawalpindi provides
                                                Special Scholarships and financial
                                                assistance to deserving students. Additionally,
                                                we offer family support and early
                                                admission discounts to promote inclusive education.</p>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Eligibility</h3>
{{--                                            <p>Must have achieved one of the following:</p>--}}
                                            <ol>
                                                <li>Students with real financial hurdles</li>
                                                <li>Siblings of currently enrolled students</li>
                                                <li>Students who are Hafiz ul Quran</li>
                                                <li>Students who are Orphans or from Ex FATA and Gilgit Baltistan</li>
                                                <li>Early applicants (for Early Bird Discount)</li>

                                            </ol>
                                            <!-- General Notes -->

                                            <h3 class="sidebar-title mt-2">General Notes</h3>
                                            <ol class="mb-0">
                                                <li><b>A student may only hold one scholarship at a time. </b></li>
                                                 <li><b>If eligible for multiple, the highest-value scholarship will apply.
                                                     </b></li>
                                                 <li><b>Scholarships are subject to the approval of the university’s Scholarship Committee.
                                                     </b></li>
                                                 <li><b>Policies may be revised at any time by the university.</b></li>
                                                 <li><b>A scholarship or waiver will be revoked on misconduct or failing to meet academic performance</b></li>
                                            </ol>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-skilled-lecturers">
                                                <h3 class="sidebar-title">Application Process</h3>
                                                <ol>
                                                    <li>Submit a Scholarship Form (if required by scholarship type)
                                                    </li>
                                                    <li>
                                                        Provide necessary documents depending on case:
                                                        <ol>
                                                            <li>For Hafiz-ul-Quran: Official Certificate/ Sanad</li>
                                                            <li>For orphans: Death certificate and NADRA Family Registration Certificate</li>
                                                            <li>For Ex FATA & Gilgit / Baltistan: Domicile or official document verifying residence </li>
                                                        </ol>
                                                    </li>

                                                </ol>
                                            </div>
                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-comments">
                                                <h3 class="sidebar-title mt-2">Special Scholarship</h3>


                                                    <!-- Special Scholarship -->
                                                    <div class="mb-5">

                                                        <div class="benefits">
                                                            <p>Following are the tiers and benefits of Special Scholarships.
                                                                Please read  <a href="{{ route('scholarship') }}" class="text-decoration-none text-dark"><b>Scholarship Policy</b></a>
                                                                 for more information.</p>

                                                            <table class="table table-bordered">
                                                                <thead>
                                                                </thead>
                                                                <tbody>
                                                                <tr>
                                                                    <td><b>Need Based Scholarship</b></td>
                                                                    <td><b>Waiver Amount Varies</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Sibling Scholarship</td>
                                                                    <td>A Tuition Waiver of  <b>20 %</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Hafiz-e-Qur’an Scholarship</td>
                                                                    <td>A Tuition Waiver of  <b>20 %</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Orphans and Regional Waivers</td>
                                                                    <td>A Tuition Waiver of  <b>20 %</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Early Bird Discount</td>
                                                                    <td>A Tuition Waiver of  <b>10 %</b></td>
                                                                </tr>
                                                                </tbody>
                                                            </table>

                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--Right Section Scholarship From -->
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar-box">
                        <div class="sidebar-box-inner">
                            <h3 class="sidebar-title">Search Scholarships</h3>
                            <div class="form-group">
                                <select id="scholarship-select" class="form-select" aria-label="Scholarship Select">
                                    <option value="">Select a Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/merit_scholarship">Merit Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/excellence_award_scholarship">Excellence Award</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/special_scholarship">Special Scholarship</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="sidebar-box">
                        <div class="sidebar-add-area overlay-primaryColor">
                            <img src="{{ asset('frontend/academics/img/scholarship/apply.jpg') }}"
                                 class="img-responsive" alt="banner">
                            <a href="https://admissions.uor.edu.pk/"
                               class="sidebar-ghost-btn">Apply Now!</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

@endsection
@push('footer-scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const scholarshipSelect = document.getElementById('scholarship-select');

            if (scholarshipSelect) {
                // Initialize Select2 if you're using it
                if ($.fn.select2) {
                    $(scholarshipSelect).select2({
                        dropdownParent: $(scholarshipSelect).parent(),
                        width: '100%'
                    });
                }

                // Handle change event
                scholarshipSelect.addEventListener('change', function() {
                    const url = this.value;
                    if (url) {
                        window.location.href = url;
                    }
                });
            }
        });
    </script>



@endpush
