@extends('front.layouts.app')
@section('content')
    <!-- Banner -->
    <div class="inner-page-banner-area"
         style="background-image: url('{{ asset('frontend/academics/img/scholarship/scholarship1.jpg') }}');">
        <div class="container">
            <div class="pagination-area">
                <h1>Single Course - 03</h1>
                <ul>
                    <li><a href="https://uor.edu.pk/">Home</a> -</li>
                    <li>Courses Details</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Left section  -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="course-details-inner">
                        <h2 class="title-default-left title-bar-high">Scholarship</h2>
                        <img src="{{'frontend/academics/'}}/img/scholarship/desgin.jpg" class="img-responsive"
                             alt="course">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <ul class="course-details-tab-btn nav" id="myTab" role="tablist">
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">Overview </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">Eligibility </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">Application
                                                Process </a></li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">Selection &
                                                Benefits
                                                For Merit Scholarship
                                            </a></li>
                                    </ul>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <div class="tab-content">
                                        <div class="tab-pane tab-item animated fadeIn show active" id="menu-1"
                                             role="tabpanel" aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Overview</h3>
                                            <p>The Merit Scholarship is awarded to outstanding students
                                                who have demonstrated exceptional academic performance
                                                at the intermediate level or performed well in our admission test.
                                                This scholarship is designed to reward students for
                                                their hard work and to ease their transition into undergraduate
                                                studies at University of Rawalpindi.</p>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Eligibility</h3>
                                            <p>Must have achieved one of the following:</p>
                                            <ol>
                                                <li>BISE Position Holders (any board in Pakistan)</li>
                                                <li>90% and above marks in intermediate</li>
                                                <li>80%–89.99% marks in intermediate</li>
                                                <li>Scored well in the university's admission test
                                                    and meet the eligibility criteria of the applied program.
                                                </li>
                                            </ol>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-skilled-lecturers">
                                                <ol>
                                                    <li>Submit your intermediate transcript during the admission
                                                        process.
                                                    </li>
                                                    <li>
                                                        If you are a board position holder,
                                                        submit proof from your respective BISE board.
                                                    </li>
                                                    <li>
                                                        Automatically shortlisted by the Admissions Office
                                                        if you are in top performers of admission test.
                                                    </li>
                                                </ol>
                                            </div>
                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-comments">
                                                <h3 class="sidebar-title">Selection & Benefits</h3>
                                                <ol>
                                                    <li>100% tuition fee waiver for Board Position Holders</li>
                                                    <li>20% tuition fee waiver for 90% and above</li>
                                                    <li>10% tuition fee waiver for 80–89.99%</li>
                                                </ol>
                                                <div class="scholarship-container">

                                                    <strong>Note:</strong> These scholarships apply only to the 1st
                                                    semester of the degree program.


                                                    <!-- High Achiever Scholarship -->
                                                    <div class="scholarship-card mb-5">
                                                        <h3 class="sidebar-title mt-2">High Achiever Scholarship</h3>
                                                        <div class="overview mb-4">
                                                            <h4>Overview</h4>
                                                            <p>The High Achiever Scholarship rewards continuing students
                                                                who
                                                                maintain excellent academic performance during their
                                                                degree program.
                                                                This performance-based scholarship incentivizes
                                                                consistency and academic dedication.</p>
                                                        </div>

                                                        <div class="eligibility mb-4">
                                                            <h4>Eligibility</h4>
                                                            <ol>
                                                                <li>Applicable to currently enrolled
                                                                    undergraduate/postgraduate students
                                                                </li>
                                                                <li>Must have completed at least one semester</li>
                                                                <li>No course failure or disciplinary action during the
                                                                    semester
                                                                </li>
                                                            </ol>
                                                        </div>

                                                        <div class="application mb-4">
                                                            <h4>Application Process</h4>
                                                            <ol>
                                                                <li>
                                                                    GPA is automatically evaluated by the Registrar’s
                                                                    Office at the end of each semester.
                                                                </li>
                                                                <li>No formal application is required; students are
                                                                    notified of their eligibility.
                                                                </li>
                                                            </ol>
                                                        </div>

                                                        <div>
                                                            <h4>Selection & Benefits</h4>
                                                            <p>Fee waiver in the next semester based on semester
                                                                GPA:</p>
                                                            <ol>
                                                                <li><strong>GPA 3.91 and above:</strong> 50% tuition fee
                                                                    waiver
                                                                </li>
                                                                <li><strong>GPA 3.76 to 3.90:</strong> 25% tuition fee
                                                                    waiver
                                                                </li>
                                                                <li><strong>GPA 3.50 to 3.75:</strong> 10% tuition fee
                                                                    waiver
                                                                </li>
                                                            </ol>

                                                            <strong>Note:</strong> Student must be regular, not fail any
                                                            course, and maintain good conduct.

                                                        </div>
                                                    </div>
                                                    <!-- Special Scholarship -->
                                                    <div class="mb-5">
                                                        <h3 class="sidebar-title mt-2">Special Scholarship</h3>
                                                        <div class="overview mb-4">
                                                            <h4>Overview</h4>
                                                            <p>The University of Rawalpindi provides Special
                                                                Scholarships and financial assistance to deserving
                                                                students. Additionally, we offer family support and
                                                                early admission discounts to promote inclusive
                                                                education.</p>
                                                        </div>

                                                        <div class="eligibility mb-4">
                                                            <h4>Eligibility</h4>
                                                            <ol>
                                                                <li>Students who are Orphans or from fata and tribal
                                                                    areas
                                                                </li>
                                                                <li>Siblings of currently enrolled students</li>
                                                                <li>Early applicants (for Early Bird Discount)</li>
                                                            </ol>
                                                        </div>

                                                        <div class="application mb-4">
                                                            <h4>Application Process</h4>
                                                            <ul>
                                                                <li>Submit a Financial Assistance Form along with
                                                                    proof
                                                                </li>
                                                                <li>Cases will be reviewed by the Financial Assistance
                                                                    Committee
                                                                </li>
                                                                <li>Final approval by university authorities</li>
                                                            </ul>
                                                        </div>

                                                        <div class="benefits">
                                                            <h4>Selection & Benefits</h4>
                                                            <ul>
                                                                <li><strong>20% tuition fee waiver</strong> for orphans
                                                                    and prospective students from tribal areas
                                                                </li>
                                                                <li><strong>20% tuition fee waiver</strong> for second
                                                                    and onward siblings enrolled
                                                                </li>
                                                                <li><strong>10% tuition fee waiver</strong> as Early
                                                                    Bird Discount on full degree (upon admission)
                                                                </li>
                                                                <li>Need-based aid amount varies depending on case
                                                                    assessment
                                                                </li>
                                                            </ul>
                                                            <strong>Note:</strong> All scholarships and financial aid
                                                            are subject to the committee's approval and university
                                                            policy.
                                                        </div>
                                                    </div>

                                                    <!-- General Notes -->

                                                    <h3 class="sidebar-title mt-2">General Notes</h3>
                                                    <ol class="mb-0">
                                                        <li>A student may only hold one scholarship at a time.</li>
                                                        <li>If eligible for multiple, the highest-value scholarship will
                                                            apply.
                                                        </li>
                                                        <li>Scholarships are subject to the approval of the university's
                                                            Scholarship Committee.
                                                        </li>
                                                        <li>Policies may be revised at any time by the university.</li>
                                                    </ol>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <!--Right Section Contact US From -->
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar-box">
                        <div class="sidebar-box-inner">
                            <h3 class="sidebar-title">Search for scholarship</h3>
                            <div class="sidebar-question-form">
                                <form method="POST" action="{{ route('contact-us.store') }}"
                                      id="scholarship-contact-form">
                                    @csrf
                                    <input type="hidden" name="source" value="scholarship-detail">

                                    {{-- Display session messages --}}
                                    @if(Session::has('messages'))
                                        @foreach(Session::get('messages') as $msg)
                                            <div
                                                class="alert alert-{{ $msg['message_type'] }}">{{ $msg['message'] }}</div>
                                        @endforeach
                                    @endif

                                    <div class="form-group">
                                        <input type="text" name="name" class="form-control" placeholder="Name*"
                                               required>
                                    </div>

                                    <div class="form-group">
                                        <input type="email" name="email" class="form-control" placeholder="Email*"
                                               required>
                                    </div>

                                    <div class="form-group">
                                        <textarea name="message" class="form-control" placeholder="Message*" rows="5"
                                                  maxlength="250" required></textarea>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Send Message</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="sidebar-box">
                        <div class="sidebar-add-area overlay-primaryColor">
                            <img src="{{ asset('frontend/academics/img/scholarship/apply.jpg') }}"
                                 class="img-responsive" alt="banner">
                            <a href="https://docs.google.com/forms/d/e/1FAIpQLSe5zmD-WswfvxGK6KtNX_maau0WfClzi5ScSlw8VvhZ-GLA3g/viewform" class="sidebar-ghost-btn">Apply Now!</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
