@extends('front.layouts.app')
@section('content')
<style>
    @media (max-width: 767.98px) {
        .sidebar-box,
        .sidebar-box-inner,
        .form-group {
            width: 100%;
            max-width: 100%;
            padding: 0 15px;
            box-sizing: border-box;
        }

        #scholarship-select {
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }
    }


</style>
    <!-- Banner -->
    <div class="inner-page-banner-area"
         style="background-image: url('{{ asset('frontend/academics/img/scholarship/scholarship1.jpg') }}');">
        <div class="container">
            <div class="pagination-area">
                <h1>Merit Scholarship</h1>
                <ul>
                    <li><a href="https://uor.edu.pk/">Home</a> -</li>
                    <li>Merit Scholarship</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Left section  -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="course-details-inner">
                        <h2 class="title-default-left title-bar-high">Merit Scholarship</h2>
                        <img src="{{ asset('frontend/academics/img/scholarship/merit.jpg') }}" class="img-responsive"
                             alt="course">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <ul class="course-details-tab-btn nav" id="myTab" role="tablist">
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">Overview </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">Eligibility </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">Application
                                                Process </a></li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">Selection &
                                                Benefits
                                                For Merit Scholarship
                                            </a></li>
                                    </ul>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <div class="tab-content">
                                        <div class="tab-pane tab-item animated fadeIn show active" id="menu-1"
                                             role="tabpanel" aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Overview</h3>
                                            <p>The Merit Scholarship is awarded to
                                                outstanding students who have demonstrated
                                                exceptional academic performance at the intermediate
                                                level. This scholarship is designed to
                                                reward students for their hard work and
                                                to ease their transition into undergraduate
                                                studies at University of Rawalpindi.</p>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Eligibility</h3>
                                            <p>Must have achieved one of the following:</p>
                                            <ol>
                                                <li>
                                                    BISE Position Holders (any board in Pakistan)</li>
                                                <li>
                                                    90% and above marks in intermediate
                                                </li>
                                                <li>
                                                    80%–89.99% marks in intermediate
                                                </li>
                                                <li>
                                                    70%–79.99% marks in intermediate
                                                </li>
                                            </ol>
                                            <!-- General Notes -->

                                            <h3 class="sidebar-title mt-2">General Notes</h3>
                                            <ol class="mb-0">
                                                <li><b>A student may only hold one scholarship at a time. </b></li>
                                                <li><b>If eligible for multiple, the highest-value scholarship will apply.
                                                    </b></li>
                                                <li><b>Scholarships are subject to the approval of the university’s Scholarship Committee.
                                                    </b></li>
                                                <li><b>Policies may be revised at any time by the university.</b></li>
                                                <li><b>A scholarship or waiver will be revoked on misconduct or failing to meet academic performance</b></li>
                                            </ol>



                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-skilled-lecturers">
                                                <h3 class="sidebar-title">Application Process</h3>
                                                <ol>
                                                    <li>
                                                        Submit your intermediate transcript during the admission process
                                                    </li>
                                                    <li>
                                                        If you are a board position holder, submit proof from your respective BISE board.
                                                    </li>
                                                    <li>
                                                        Automatically shortlisted by the Admissions Office.if applied by priority deadline
                                                    </li>
                                                </ol>
                                            </div>
                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-comments">
                                                <h3 class="sidebar-title mt-2">Merit Scholarship</h3>


                                                <!-- Merit Scholarship -->
                                                <div class="mb-5">
                                                    <div class="benefits">
                                                        <h4>Selection & Benefits</h4>
                                                        <p>Following are the tiers and benefits of Merit-Based Scholarships. Please read
                                                            <a href="{{ route('scholarship') }}" class="text-decoration-none text-dark"><b>Scholarship Policy</b></a> for more information.</p>

                                                        <table class="table table-bordered">
                                                            <thead>
                                                            </thead>
                                                            <tbody>
                                                            <tr>
                                                                <td><b>Tier I (90% or above marks in Inter)</b></td>
                                                                <td>A Tuition Waiver of <b>100 %</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Tier II (80 – 89.99% or above marks in Inter)</b></td>
                                                                <td>A Tuition Waiver of <b>50 %</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Tier III (70 – 79.99% or above marks in Inter)</b></td>
                                                                <td>A Tuition Waiver of <b>25 %</b></td>
                                                            </tr>
                                                            </tbody>
                                                        </table>

                                                        <strong>Note:</strong> Merit Based Scholarships for <b>Tier I and II</b> are limited and will be given on the basis of <b>First Come - First Served</b>
                                                        scenario. A student has to maintain a CGPA in order to
                                                        remain eligible for Merit Based Scholarship. If their CGPA
                                                        falls below the threshold for their tier, they will be “shifted down”
                                                        to the next lower waiver tier or forfeit the award if falling below all thresholds.

                                                        <ol>
                                                            <li><b>If semester CGPA ≥ 3.85:</b> Continues at Tier I (100%) next semester.</li>
                                                            <li><b>If semester CGPA ≥ 3.70 but < 3.85:</b> Shifted to Tier II (50%) next semester.</li>
                                                            <li><b>If semester CGPA ≥ 3.50 but < 3.70:</b> Shifted to Tier III (25%) next semester.</li>
                                                            <li><b>If semester CGPA < 3.50:</b> Merit scholarship is withdrawn.</li>
                                                        </ol>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--Right Section Scholarship From -->
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar-box">
                        <div class="sidebar-box-inner">
                            <h3 class="sidebar-title">Search Scholarships</h3>
                            <div class="form-group">
                                <select id="scholarship-select" class="form-select w-100" aria-label="Scholarship Select">
                                    <option value="">Select a Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/merit_scholarship">Merit Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/excellence_award_scholarship">Excellence Award</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/special_scholarship">Special Scholarship</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="sidebar-box">
                        <div class="sidebar-add-area overlay-primaryColor">
                            <img src="{{ asset('frontend/academics/img/scholarship/apply.jpg') }}"
                                 class="img-responsive" alt="banner">
                            <a href="https://admissions.uor.edu.pk/"
                               class="sidebar-ghost-btn">Apply Now!</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

@endsection
@push('footer-scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const scholarshipSelect = document.getElementById('scholarship-select');
            if (scholarshipSelect) {
                scholarshipSelect.addEventListener('change', function () {
                    const url = this.value;
                    if (url) {
                        window.location.href = url;
                    }
                });
            }
        });
    </script>





@endpush
