@extends('front.layouts.app')
@section('content')

    <!-- Banner -->
    <div class="inner-page-banner-area"
         style="background-image: url('{{ asset('frontend/academics/img/scholarship/scholarship1.jpg') }}');">
        <div class="container">
            <div class="pagination-area">
                <h1>Excellence Award Scholarship</h1>
                <ul>
                    <li><a href="https://uor.edu.pk/">Home</a> -</li>
                    <li>Excellence Award Scholarship</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Left section  -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="course-details-inner">
                        <h2 class="title-default-left title-bar-high">Excellence Award Scholarship</h2>
                        <img src="{{ asset('frontend/academics/img/scholarship/acheivers.png') }}"
                             class="img-responsive"
                             alt="course">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <ul class="course-details-tab-btn nav" id="myTab" role="tablist">
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">Overview </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">Eligibility </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">Application
                                                Process </a></li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">Selection &
                                                Benefits
                                                For Merit Scholarship
                                            </a></li>
                                    </ul>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <div class="tab-content">
                                        <div class="tab-pane tab-item animated fadeIn show active" id="menu-1"
                                             role="tabpanel" aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Overview</h3>
                                            <p>The Excellence Award is given to
                                                students who maintain excellent
                                                academic performance during their degree program.
                                                This performance-based scholarship
                                                incentivizes consistency and academic dedication.</p>

                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <h3 class="sidebar-title">Eligibility</h3>
                                            <p>Must have achieved one of the following:</p>
                                            <ol>
                                                <li>GPA of 3.91 or above in a semester
                                                </li>
                                                <li>GPA of 3.76–3.90 or above in a semester</li>
                                                <li>GPA of 3.50–3.75 or above in a semester</li>

                                            </ol>
                                            <h3 class="sidebar-title mt-2">Notes</h3>
                                           <p> A student must have completed at least <b>1 semester,</b>
                                               not failed any course, and maintained good conduct.</p>
                                            <!-- General Notes -->

                                            <h3 class="sidebar-title mt-2">General Notes</h3>
                                            <ol class="mb-0">
                                                <li>A student may only hold one scholarship at a time.</li>
                                                <li>If eligible for multiple, the highest-value scholarship will apply.
                                                </li>
                                                <li>Scholarships are subject to the approval of the university’s Scholarship Committee.
                                                </li>
                                                <li>Policies may be revised at any time by the university.</li>
                                                <li>A scholarship or waiver will be revoked on misconduct or failing to meet academic performance</li>
                                            </ol>


                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-skilled-lecturers">
                                                <h3 class="sidebar-title">Application Process</h3>
                                                <ol>
                                                    <li>
                                                        GPA is automatically evaluated by the Registrar’s
                                                        Office at the end of each semester.
                                                    </li>
                                                    <li>
                                                        No formal application is required; students
                                                        are notified of their eligibility.
                                                    </li>

                                                </ol>
                                            </div>
                                        </div>
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="course-details-comments">
                                                <h3 class="sidebar-title mt-2">Excellence Award Scholarship</h3>


                                                <!-- HIGER ACHIVER Scholarship -->
                                                <div class="mb-5">


                                                    <div class="benefits">
                                                        <h4>Selection & Benefits</h4>
                                                        <p>Following are the tiers and benefits of Excellence Award.
                                                            Please read  <b>Scholarship Policy</b> for more information.</p>

                                                        <table class="table table-bordered">
                                                            <thead>
                                                            </thead>
                                                            <tbody>
                                                            <tr>
                                                                <td><b>Tier I (3.91 – 4.00 semester GPA)</b></td>
                                                                <td>A Tuition Waiver of  <b>50 %</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Tier II (3.76 – 3.90 semester GPA)</b></td>
                                                                <td>A Tuition Waiver of  <b>25 %</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Tier III (3.50 – 3.75 semester GPA)</b></td>
                                                                <td>A Tuition Waiver of  <b>10 %</b></td>
                                                            </tr>
                                                            </tbody>
                                                        </table>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--Right Section Scholarship From -->
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar-box">
                        <div class="sidebar-box-inner">
                            <h3 class="sidebar-title">Search Scholarships</h3>
                            <div class="form-group">
                                <select id="scholarship-select" class="form-select" aria-label="Scholarship Select">
                                    <option value="">Select a Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/merit_scholarship">Merit Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/excellence_award_scholarship">Excellence Award Scholarship</option>
                                    <option value="{{ URL('/') }}/scholarship-detail/special_scholarship">Special Scholarship</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="sidebar-box">
                        <div class="sidebar-add-area overlay-primaryColor">
                            <img src="{{ asset('frontend/academics/img/scholarship/apply.jpg') }}"
                                 class="img-responsive" alt="banner">
                            <a href="https://admissions.uor.edu.pk/"
                               class="sidebar-ghost-btn">Apply Now!</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

@endsection
@push('footer-scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const scholarshipSelect = document.getElementById('scholarship-select');

            if (scholarshipSelect) {
                // Initialize Select2 if you're using it
                if ($.fn.select2) {
                    $(scholarshipSelect).select2({
                        dropdownParent: $(scholarshipSelect).parent(),
                        width: '100%'
                    });
                }

                // Handle change event
                scholarshipSelect.addEventListener('change', function() {
                    const url = this.value;
                    if (url) {
                        window.location.href = url;
                    }
                });
            }
        });
    </script>



@endpush
