@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Programs</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="admission-area my-5 text-center">
        <div class="container">
            <h1 class="admission-title">Programs</h1>
            <p class="text-start">The Programs at UOR offer dynamic, in-depth knowledge, guided counseling, and practical learning
                opportunities. Our 4-year-long programs are designed to equip students with the skills to analyze and
                solve complex problems, fostering diligence, curiosity, and effective efficiency. Join us at UOR to
                develop as responsible and capable citizens, ready to make an impact.</p>
        </div>
    </div>
    <!-- Admission Area End Here -->

    <!-- Courses  Area Start Here -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div class="course-details-inner">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-3 col-lg-3 col-md-3">
                                    <ul class="course-details-tab-btn nav flex-column" id="myTab" role="tablist">
                                        <button class="fac-title btn bg-red text-light py-3 my-2 w-100">FACULTY</button>

                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Engineering and Information
                                                        Technology
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Social Sciences and Management
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Languages and Humanities</div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link"
                                                                                     id="menu-4-tab"
                                                                                     data-bs-toggle="tab"
                                                                                     href="#menu-4 " role="tab"
                                                                                     aria-controls="menu-4"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Arts, Design and Architecture
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-5-tab"
                                                                                     data-bs-toggle="tab" href="#menu-5"
                                                                                     role="tab" aria-controls="menu-5"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Law, Fiqh and Islamic Shariah
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    </ul>
                                </div>

                                <!-- Faculty 1 start Here -->

                                <div class="col-xl-9 col-lg-9 col-md-9">
                                    <div class="tab-content">

                                        <div class="tab-pane tab-item animated fadeIn show active" id="menu-1"
                                             role="tabpanel" aria-labelledby="menu-1-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive program-table">
                                                    <table class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-nowrap border-1 border-light">Serial No.
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light p-width">
                                                                Program Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">Short
                                                                Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">
                                                                Duration
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light e-width">
                                                                Eligibility Criteria
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-white bg-red" colspan="5">
                                                                Faculty of Engineering and Information Technology
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="5">Department of Computing and Intelligence
                                                                Systems
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 1.</td>
                                                            <td class="align-middle">
                                                                BS Computer Science
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-computer-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> BSCS</td>
                                                            <td class="text-center align-middle">8 Semesters
                                                                (4 years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>
                                                                    <li>Candidates with a three-year associate diploma
                                                                        in Electrical/Electronics/IT/Computer
                                                                        hardware/Telecom engineering from any institute
                                                                        recognized by PBTE (Punjab Board of Technical
                                                                        Education).
                                                                    </li>
                                                                    <li>The students who have not studied Mathematics at
                                                                        intermediate level have to pass deficiency
                                                                        course of Mathematics (06 credits) in first two
                                                                        semesters.
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 2.</td>
                                                            <td class="align-middle">
                                                                ADP Computer Science
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-computer-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADPCS</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 3.</td>
                                                            <td class="align-middle">
                                                                BS Software Engineering
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-software-engineering"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> BSSE</td>
                                                            <td class="text-center align-middle">8 Semesters
                                                                (4 years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>
                                                                    <li>Intermediate with Mathematics (200
                                                                        Marks)/A-level with Mathematics/ three years
                                                                        associate diploma in Electrical/ Electronics/
                                                                        IT/ Computer hardware/ Telecom engineering from
                                                                        any Institute recognized by PBTE (Punjab Board
                                                                        of Technical Education).
                                                                    </li>
                                                                    <li>The students who have not studied Mathematics at
                                                                        intermediate level have to pass deficiency
                                                                        course of Mathematics (06 credits) in first two
                                                                        semesters.
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 4.</td>
                                                            <td class="align-middle">
                                                                ADP Software Engineering
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-software-engineering"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADPSE</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 5.</td>
                                                            <td class="align-middle">
                                                                ADP Data Science
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-data-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADP DS</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 6.</td>
                                                            <td class="align-middle">
                                                                ADP Cybersecurity
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-cyber-security"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADP CYS</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 7.</td>
                                                            <td class="align-middle">
                                                                ADP Artificial Intelligence
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-artificial-intelligence"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADP AI</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 8.</td>
                                                            <td class="align-middle">
                                                                ADP Information Technology
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-information-technology"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADP IT</td>
                                                            <td class="text-center align-middle"> 04 Semesters(02 Years)
                                                            </td>
                                                            <td>
                                                                <ul class="mx-3" style="list-style: outside">
                                                                    <li>Intermediate or equivalent level with
                                                                        Mathematics, at least 50% marks.
                                                                    </li>

                                                                </ul>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 1 End Here -->

                                        <!-- Faculty 2 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-2-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive program-table">
                                                    <table class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-nowrap border-1 border-light">Serial No.
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light p-width">
                                                                Program Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">Short
                                                                Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">
                                                                Duration
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light e-width">
                                                                Eligibility Criteria
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-white bg-red" colspan="5">
                                                                Faculty of Social Sciences and Management
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="5">Department of Applied Business and Economics
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 9.</td>
                                                            <td class="align-middle">
                                                                Bachelor of Business Administration
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bachelor-of-business-administration"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BBA</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>
                                                                <ul>
                                                                    <li>
                                                                        Intermediate or equivalent with a minimum of 45%
                                                                        marks
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>



                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 10.</td>
                                                            <td class="align-middle">
                                                                ADP Business Administration & Commerce
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-of-business-administration"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPBA&C</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>
                                                                <ul>
                                                                    <li>
                                                                        Intermediate or equivalent with a minimum of 35%
                                                                        marks
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">11.</td>
                                                            <td class="align-middle">
                                                                BS Accounting and Finance
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-accounting-and-finance"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BSAF</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 12.</td>
                                                            <td class="align-middle">
                                                                ADP Accounting and Finance
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-accounting-and-finance"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPAF</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 13.</td>
                                                            <td class="align-middle">
                                                                ADP E-Commerce and Digital Marketing
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-e-commerce-and-digital-marketing"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADP E.com</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td> Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 14.</td>
                                                            <td class="align-middle">
                                                                ADP Hospitality & Tourism Management
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-hospitality-and-tourism-management"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADP HTM</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>


                                                        </tbody>
                                                        {{-- New thead --}}
                                                        <thead>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase"
                                                                colspan="5">
                                                                Department of Behavioral and Social Sciences
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 15.</td>
                                                            <td class="align-middle"> BS Psychology
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-psychology"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BS Psy</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 16.</td>
                                                            <td class="align-middle"> ADP Psychology
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-psychology"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADP Psy</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 17.</td>
                                                            <td class="align-middle"> ADP Biotechnology
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-biotechnology"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle"> ADP BT</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td> FSc. Pre-medical with a minimum of 35% marks
                                                            </td>
                                                        </tr>


                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 2 End Here -->


                                        <!-- Faculty 3 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-3-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive program-table">
                                                    <table class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-nowrap border-1 border-light">Serial No.
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light p-width">
                                                                Program Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">Short
                                                                Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">
                                                                Duration
                                                            </th>
                                                            <th class="text-nowrap text-center e-width border-1 border-light">
                                                                Eligibility Criteria
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-white bg-red" colspan="5">
                                                                Faculty of Languages and Humanities
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="5">Department of Linguistic and Cultural
                                                                Studies

                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 18.</td>
                                                            <td class="align-middle">
                                                                BS English and Linguistic Studies
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-english_and_linguistic_studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BSEL</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 19.</td>
                                                            <td class="align-middle">
                                                                ADP English and Linguistic Studies
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-english_and_linguistic_studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPEL</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>


                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 3 End Here -->

                                        <!-- Faculty 4 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-4-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive program-table">
                                                    <table class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-nowrap border-1 border-light">Serial No.
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light p-width">
                                                                Program Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">Short
                                                                Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">
                                                                Duration
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light e-width">
                                                                Eligibility Criteria
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-white bg-red" colspan="5">
                                                                Faculty of Arts, Design and Architecture
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="5">Department of Art and Digital Media
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        {{-- New thead --}}
                                                        <tbody>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 20.</td>
                                                            <td class="align-middle"> BS Digital Design and Computer
                                                                Arts
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-digital-design-and-computer-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td class="text-center align-middle">BS DDCA
                                                            </td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 21.</td>
                                                            <td class="align-middle"> ADP Digital Design and Computer
                                                                Arts
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-digital-design-and-computer-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td class="text-center align-middle">ADP DDCA
                                                            </td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 22.</td>
                                                            <td class="align-middle">
                                                                BS Media and Communication Studies
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-media-and-communication-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BSMCS</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 23.</td>
                                                            <td class="align-middle">
                                                                ADP Media and Communication Studies
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-media-and-communication-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPMCS</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 24.</td>
                                                            <td class="align-middle">
                                                                ADP Fine Arts
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-fine-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPFA</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td> Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <thead>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase"
                                                                colspan="5">
                                                                Department of Interior Design
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 25.</td>
                                                            <td class="align-middle">BS Interior Design
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-interior-design"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BSID</td>
                                                            <td>8 semesters (4 years)</td>
                                                            <td>Intermediate with minimum 45% marks or equivalent</td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 26.</td>
                                                            <td class="align-middle">ADP Interior Design
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-interior-design"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPID</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate with minimum 35% marks or equivalent</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 4 End Here -->
                                        <!-- Faculty 5 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-5" role="tabpanel"
                                             aria-labelledby="menu-5-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive program-table">
                                                    <table class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-nowrap border-1 border-light">Serial No.
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light p-width">
                                                                Program Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">Short
                                                                Title
                                                            </th>
                                                            <th class="text-nowrap border-1 border-light">
                                                                Duration
                                                            </th>
                                                            <th class="text-nowrap text-center border-1 border-light e-width">
                                                                Eligibility Criteria
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-white bg-red" colspan="5">
                                                                Faculty of Law, Fiqah and Islamic Shariah
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="5">Department of Islamic Studies and
                                                                Jurisprudence
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 27.</td>
                                                            <td class="align-middle">
                                                                BS Islamic Sciences
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-islamic-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">BSIS</td>
                                                            <td>8 Semesters (4 years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 45% marks
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 28.</td>
                                                            <td class="align-middle">
                                                                ADP Islamic Sciences
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-islamic-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPIS</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle"> 29.</td>
                                                            <td class="align-middle">
                                                                ADP Paralegal Studies
                                                                <a class="badge bg-red align-middle bg-red ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-paralegal-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a>
                                                            </td>
                                                            <td class="text-center align-middle">ADPLS</td>
                                                            <td>04 Semesters(02 Years)</td>
                                                            <td>Intermediate or equivalent with a minimum of 35% marks
                                                            </td>
                                                        </tr>

                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 5 End Here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Courses Page 5 Area End Here -->

@endsection
