@extends('front.layouts.app')
@section('content')
    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>News and Events</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>News and Events</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- News and Events Page Area Start Here -->
    <div class="news-page-area">
        <div class="container">
            <!-- News and Events Search Area Start Here -->
            <form id="checkout-form"  class="news-event-search">
                <div class="row">
                    <div class="col-6">
                    </div>
                <div class="d-flex col-lg-6 col-md-6 col-sm-12 mb-4 right ">
                    <input id="first-name" placeholder="Type Here...." class="form-control" type="text" name="search"
                           value="{{ request()->input('search') }}"/>
                    <button class="sidebar-search-btn-full disabled" type="submit" >Search</button>
                    <a class="sidebar-reset-btn-full disabled float-left" href="{{route('news-events')}}">Reset</a>
                </div>
                    </div>
            </form>
            <!-- News and Events Search Area End Here -->
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="row">
                        @if($events->isEmpty())
                            <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                <div class="news-box">
                                    <h3 class="title-news-left-bold">Record not Found.</h3>
                                </div>
                            </div>
                        @else
                            @foreach($events as $event)
                                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                    <div class="news-box">
                                        <div class="news-img-holder">
                                            <img
                                                src="{{ asset("storage/News-and-Events/thumbnail/{$event->thumbnail}") }}"
                                                class="img-responsive" alt="research">
                                            <ul class="news-date2">
                                                <li>{{ \Carbon\Carbon::parse($event->date)->format('d M') }}</li>
                                                <li>{{ \Carbon\Carbon::parse($event->date)->format('Y') }}</li>
                                            </ul>
                                        </div>
                                        <h1 class="sidebar-title title-news-left-bold"><a
                                                href="{{route('news-events-details', $event->slug)}}">{{$event->title}}</a>
                                        </h1>
                                        <ul class="title-bar-high news-comments">
                                            <li><a href="{{ route('news-events', ['category_id' => $event->news_and_events_category_id]) }}"><i class="fa fa-tags" aria-hidden="true"></i>{{$event->category->name}}</a></li>
                                        </ul>
                                        <p>{{$event->summary}}</p>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <ul class="pagination-center">
                                <li>
                                    {{ $events->links() }}
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                    <div class="sidebar">
                        <div class="sidebar-box">
                            <div class="sidebar-box-inner">
                                <h3 class="sidebar-title">Type</h3>
                                <ul class="sidebar-categories">
                                    <li class="{{ request()->get('type') == 'news' ? 'active' : '' }}"><a href="{{ route('news-events') }}?type=news">News</a></li>
                                    <li class="{{ request()->get('type') == 'event' ? 'active' : '' }}"><a href="{{ route('news-events') }}?type=event">Events</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="sidebar-box">
                            <div class="sidebar-box-inner">
                                <h3 class="sidebar-title">Categories</h3>
                                <ul class="sidebar-categories">
                                    @foreach($categories as $category)
                                        <li class="{{ request()->get('category_id') == $category->id ? 'active' : '' }}">
                                            <a href="{{ route('news-events', ['category_id' => $category->id]) }}">
                                                {{ $category->name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- News and Events Page Area End Here -->
@endsection
