@extends('front.layouts.app')
@section('content')
    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>News and Events</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>{{$event->title}}</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->
    <!-- News Details Page Area Start Here -->
    <div class="news-details-page-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                    <div class="row news-details-page-inner">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="news-img-holder">
                                <img src="{{ asset("storage/News-and-Events/Cover/{$event->cover_image}") }}"
                                     class="img-responsive" alt="research">
                                <ul class="news-date1">
                                    <li>{{ \Carbon\Carbon::parse($event->date)->format('d M') }}</li>
                                    <li>{{ \Carbon\Carbon::parse($event->date)->format('Y') }}</li>
                                </ul>
                            </div>
                            <h3 class="sidebar-title title-default-left-bold-lowhight">{{$event->title}}</h3>
                            <p>{!! $event->description !!}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

     <!-- News Page Area End Here -->

@endsection
