@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Housing & Transport</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Life at UOR</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Housing & Transport Page Area Start Here -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div class="course-details-inner">
                        <h2 class="title-default-left title-bar-high">Housing at University of Rawalpindi</h2>
                        <p>This document outlines the rules and regulations of Girls Hostel, UOR.
                            These rules and regulations may be called The University of Rawalpindi,
                            Girls Hostel Rules and Regulations, 2024. These Rules and Regulations shall
                            come into force with an immediate effect. Hostel rules have been framed to
                            provide basic guidelines to the students for maintaining an environment conducive
                            for studies and shall apply to all hostel students of the University.</p>
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12">
                                    <h3 class="sidebar-title">General</h3>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Admission to the hostel is a privilege, not a right. However, accommodation
                                            will be provided subject to availability of rooms.
                                        </li>
                                        <li>The Hostel accommodation shall be provided only to the bonafide students
                                            (female) of the University subject to availability.
                                        </li>
                                        <li>Allotment of accommodation in the hostel will be given to students domiciled
                                            in
                                            places other than Rawalpindi.
                                        </li>
                                        <li>Maximum period of stay in hostel shall under no circumstances be more than
                                            5-academic
                                            years provided that fresh allotment is made each year by the competent
                                            authority in
                                            accordance with the allotment policy.
                                        </li>
                                        <li>The Hostels will remain closed during the summer vacation (after completion
                                            of Spring
                                            Semester up to 10 days before the start of Fall Semester). All residents are
                                            required
                                            to vacate the hostels within 7 days as and when notified.
                                        </li>
                                        <li>The residents who desire to stay in the Hostel during summer break shall
                                            have to provide
                                            a valid recommendation/justification to the Warden. The hostel charges for
                                            the stipulated
                                            period will be charged accordingly.
                                        </li>
                                        <li>Stay in the hostel shall in no way be prejudicial to the interests of other
                                            residents in
                                            the hostel.
                                        </li>
                                    </ul>
                                    <h3 class="sidebar-title">Hostel Admission</h3>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Application for allotment of accommodation in the hostel shall be made by
                                            the bonafide
                                            student of the University to the Warden on the prescribed form along with
                                            undertaking
                                            from parents.
                                        </li>
                                        <li>In case of foreign students, the recommendation and undertaking on the
                                            prescribed
                                            proformas for the admission and the guarantee for the payment of hostel dues
                                            and good
                                            behavior will be obtained from their respective embassies or consulates.
                                        </li>
                                        <li>Hostel Warden will forward the applications to the Hostel Committee to
                                            scrutinize the
                                            applications as per merit and eligibility requirements.
                                        </li>
                                        <li>In case a student recommended by the Hostel Committee, her application will
                                            be sent
                                            to UOR accounts office to issue the Challan form against the hostel dues.
                                        </li>
                                        <li>The Allotment of rooms shall be made after the students have produced the
                                            payment
                                            receipt against the hostel dues from the designated Bank or otherwise.
                                        </li>
                                        <li>The resident student shall deposit Hostel dues within specified period and
                                            submit
                                            deposit receipt in the office of the Warden.
                                        </li>
                                        <li>Rooms shall be allotted by the Warden in order of seniority. In making the
                                            allotments,
                                            the Warden will also take into consideration the eligibility of students.
                                        </li>
                                    </ul>
                                    <h3 class="sidebar-title">Hostel Admission</h3>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Hostel dues and security deposits as determined by the University from time
                                            to time
                                            are payable by the student in each regular/summer semester.
                                        </li>
                                        <li>Hostel dues once paid shall not be refunded.</li>
                                        <li>Hostel allotment of a student shall stand cancelled, if, she fails to pay
                                            Hostel dues
                                            within specified period, however, she may seek re-admission in the Hostel as
                                            admissible
                                            under the rules.
                                        </li>
                                        <li>Students are allowed to use their personal electrical appliances with
                                            permission from the
                                            hostel warden. However, they have to pay additional cost (to be decided
                                            every year by the
                                            management) along with hostel dues in advance for the following appliances:
                                            <ul class="my-3">
                                                <li>Air Conditioner</li>
                                                <li>Microwave Oven</li>
                                                <li>Refrigerator</li>
                                            </ul>
                                        </li>
                                        <li>The approved “Hostel Dues” along with “Electrical Appliances” charges are
                                            appended with this regulations as <strong>annexure-A</strong>.</li>
                                    </ul>
                                    <h3 class="sidebar-title">Discipline</h3>
                                    <h4 class="sidebar-heading">5.1 Conduct and Discipline</h4>
                                    <p>The following, among other violation of the provision of the code of conduct, shall
                                        constitute acts of indiscipline and misconduct for which action may be taken against
                                        the resident(s) by the hostel warden/ Hostel Committee / Competent Authority for imposing
                                        appropriate penalties:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Whenever the residents are vacating the hostel room they must obtain a clearance
                                            certificate from the Warden.</li>
                                        <li>No resident will sublet their hostel room to an unauthorized person/student,
                                            otherwise her seat will be cancelled without any refund.</li>
                                        <li>If a resident who has allotted UOR hostel accommodation, is not personally residing
                                            in the allocated room and is found keeping unlawful or illegal occupants, her
                                            allotment will be cancelled and the case will be referred to the Disciplinary
                                            Committee for further action.</li>
                                        <li>Keeping firearms and other lethal weapons or any other dangerous material in the hostel
                                            even if licensed.</li>
                                        <li>Allowing any unauthorized guests in the room by a resident shall be considered as breach
                                            of hostel rules and shall be fined heavily or may result in expulsion from the Hostel
                                            or the University, depending on the severity of the case and the risk it posed.</li>
                                        <li>Meetings and other functions in the hostel can only be held with the prior written
                                            permission of the Warden.</li>
                                        <li>Resident shall sign a receipt of hostel property/assets in their rooms and shall be
                                            responsible for any loss or damage thereto.</li>
                                        <li>Resident found guilty of damaging or destroying (intentionally or unintentionally
                                            or due to negligence) any hostel property shall be required to pay for the damages
                                            and shall also be liable to a fine.</li>
                                        <li>No resident shall be allowed to place any notice, placard, posters, and wall chalking
                                            or other material of any nature anywhere in the hostel premises. A central notice board
                                            for students would be provided where they can post their communication and or share
                                            general posts with other residents.</li>
                                        <li>University is declared as a smoking free zone. In hostel smoking is prohibited in the
                                            rooms as well as in the hostel premises.</li>
                                        <li>University has zero tolerance on the use and/or possession of drugs, intoxicants and
                                            alcoholic beverages within the campus and hostel premises. Residents found in possession
                                            of such illegal substances would face immediate disciplinary action / expulsion from the
                                            Hostel and the University, even on their first offence.</li>
                                        <li>The residents shall park their cars, motorcycles, and bicycles at specified locations at
                                            their own risk and responsibility.</li>
                                        <li>Keeping electric appliances such as refrigerator, air conditioner, television, oven, etc.
                                            in the room without permission of the hostel warden.</li>
                                        <li>Shouting of slogans derogatory to the prestige of the University or the reputation of its
                                            teachers and other employees.</li>
                                        <li>Use of hostel rooms or premises for group parties, political assemblies and for purpose other
                                            than those for which they are meant.</li>
                                        <li>Inviting outsiders to address hostel residents without the permission of authorities.</li>
                                        <li>Staying away from the hostel premises after sunset or longer period without prior permission
                                            from hostel authorities.</li>
                                        <li>Late comers or those leaving the hostel early will be required to sign the register at the hostel
                                            gate or reception stating the reasons for late coming or early departure.</li>
                                        <li>Always be respectful to your colleagues and hostel staff/management.</li>
                                        <li>The hostel authorities shall reserve the right to search personal belongings and baggage of the
                                            residents at the time of entering the hostel or while residing in the allotted accommodation.</li>
                                        <li>Residents must keep their rooms clean and tidy. Beds should be properly made up. Dirty clothes should
                                            be stored separately.</li>
                                        <li>Residents shall take due care of the bathrooms and taps and shall not waste the resources and facilities
                                            provided to them. Anyone found doing this intentionally will be liable to punishment.</li>
                                        <li>All waste paper and garbage must be placed in receptacles provided for the purpose.</li>
                                        <li>Every part of the hostel premises shall be freely open for inspection by Warden at all times/anytime of
                                            day or night.</li>
                                        <li>Cooking in the hostel rooms is strictly prohibited.</li>
                                        <li>Spitting in public or private rooms, verandah or stairs is prohibited.</li>
                                        <li>No pets/animals inside the rooms or hostel premises are allowed.</li>
                                        <li>Actions defamatory and derogatory to Islam and Pakistan.</li>
                                        <li>Keeping of private servant is not allowed in the hostels.</li>
                                        <li>No religious ceremony likely to hurt the feelings of other residents shall be arranged in the hostel.</li>
                                        <li>No resident shall indulge in any amusement that disturbs other residents.</li>
                                    </ul>
                                    <h4 class="sidebar-heading">Disciplinary Measures</h4>
                                    <div class="table-responsive">
                                        <table class="table housing">
                                            <tr>
                                                <th class="ps-4" style="width: 3%"> <p>1</p></th>
                                                <th  class="ps-4" >
                                                    <p class="py-3">
                                                        Violation of Hostel Rules or Disobeying the orders of Hostel Administration.
                                                        Sublet their hostel room.<br>
                                                        Placing any notice, placard, posters, and wall chalking etc.<br>
                                                        Wrongly park the car, motorcycles, and bicycles, etc.<br>
                                                        Keeping electric appliances in the room without permission of the hostel warden.<br>
                                                        Shouting of slogans.<br>
                                                        Failing to follow the hostel timings.<br>
                                                        Disgrace/misbehave with colleagues and hostel staff/management.<br>
                                                        Cooking in the hostel rooms.<br>
                                                        Bringing pets/animals inside the room or hostel premises.<br> and<br>
                                                        Indulge in any amusement that disturbs other residents.<br>
                                                    </p>
                                                </th>
                                                <th class="ps-4">
                                                    <p><b>First Time:</b><br></p>
                                                    <p> A fine upto a maximum of Rs. 2,000/- (two thousand rupees only)</p>
                                                    <p><b class="mt-4">Second Time: </b><br></p>
                                                    <p> Cancellation of hostel privilege for next sessions and/or expulsion from hostel.</p>
                                                </th>
                                            </tr>
                                            <tr>
                                                <th class="ps-4" style="width: 3%"> <p>2</p></th>
                                                <th  class="ps-4" >
                                                    <p class="py-3">
                                                        Damaging or destroying (intentionally or unintentionally or due to negligence) any hostel property.
                                                    </p>
                                                </th>
                                                <th class="ps-4">
                                                    <p><b>First Time:</b><br></p>
                                                    <p> Recovery of loss/damage as per actual cost of the item or a fine upto Rs. 10,000/- (ten thousand
                                                        rupees only) whichever is higher</p>
                                                    <p><b class="mt-4">Second Time: </b><br></p>
                                                    <p> Cancellation of hostel privilege for next sessions and/or expulsion from hostel.</p>
                                                </th>
                                            </tr>
                                            <tr>
                                                <th class="ps-4" style="width: 3%"> <p>3    </p></th>
                                                <th  class="ps-4" >
                                                    <p class="py-3">
                                                        Keeping unlawful or illegal occupants.<br>
                                                        Firearms and other lethal weapons.<br>
                                                        Allowing any unauthorized guests in the room.<br>
                                                        Meetings and other functions in the hostel without prior written permission.<br>
                                                        Smoking in room or in hostel premises.<br>
                                                        Use of hostel rooms or premises for group parties and Political assemblies etc.<br>
                                                        Inviting outsiders to address hostel residents without the permission.<br>
                                                        Actions defamatory and derogatory to Islam and Pakistan.<br> and <br>
                                                        Conducting religious ceremony likely to hurt the feelings of resident with different religious.

                                                    </p>
                                                </th>
                                                <th class="ps-4">
                                                    <p><b>First Time:</b><br></p>
                                                    <p> A fine upto a maximum of Rs. 10,000/- (ten thousand rupees only) </p>
                                                    <p><b class="mt-4">Second Time: </b><br></p>
                                                    <p> Cancellation of hostel privilege for next sessions and/or expulsion from hostel.</p>
                                                </th>
                                            </tr>
                                            <tr>
                                                <th class="ps-4" style="width: 3%"> <p>4 </p></th>
                                                <th  class="ps-4" >
                                                    <p class="py-3">
                                                        Use and/or possession of drugs, intoxicants and alcoholic beverages within the campus and hostel premises
                                                    </p>
                                                </th>
                                                <th class="ps-4">
                                                    <p><b>First Time:</b><br></p>
                                                    <p>
                                                        Room allotment will be cancelled with an immediate effect and the case may be forwarded to disciplinary
                                                        action against the resident(s) by the Warden.
                                                    </p>
                                                </th>
                                            </tr>
                                        </table>
                                    </div>
                                    <h3 class="sidebar-title">Appeal Against The Penalty</h3>
                                    <ul class="learning-outcomes mb-4">
                                        <li><b>Minor Penalty</b>
                                        <p>A student on whom any minor penalty / penalties has/have been imposed on the recommendations of the Hostel Committee
                                            may within fifteen (15) days from the date of announcement of the order, appeal against that order to the Warden.</p></li>
                                        <li><b>Major Penalty</b>
                                        <p>A student on whom any major penalty / penalties has/have been imposed on the recommendation of the Hostel Committee
                                            may within fifteen (15) days from the date of announcement of the order, appeal against that order to the Rector.
                                            The Rector may, after obtaining advice of the Discipline Committee of the University, dismiss the appeal or acquit
                                            the appellant, or order a fresh enquiry, or reduce or enhance the penalty or suspend the punishment to be re-imposed
                                            immediately on evidence of her involvement in acts of indiscipline and misconduct. Provided that in case of
                                            enhancement of penalty, prior show cause notice shall be given to the accused resident to put in his defense (if any)
                                            within the prescribed time limit.</p></li>
                                    </ul>
                                    <h3 class="sidebar-title">Hostel Mess</h3>
                                    <p>The Hostel mess is managed by hostel residents themselves under the supervision of Mess Committee and the directions
                                        of the Hostel Warden.</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Each hostel shall have a Mess Committee. The mess committee shall select a student as its secretary, who shall be
                                            responsible for managing the mess, under the direction of the Warden and the mess committee. The mess committee
                                            shall prepare a monthly menu. prescribe quantity of food items required, depending upon the number of the residents.</li>
                                        <li>Meals shall be taken in the dining hall during fixed hours for each meal. No meal will be served in a room of a
                                            resident unless she is sick.</li>
                                        <li>Each resident will be a member of the hostel mess unless she decides not to. Meals cannot be stopped for less
                                            than seven days provided the resident leave from the hostel with the permission of the Warden in writing, to
                                            stop his meals for the period stated.</li>
                                        <li>The hostel mess system records and accounts will be maintained by the mess committee who will be responsible to
                                            maintain a list of the members of the mess, work out monthly expenditures incurred per person, enter it into
                                            proper register and notify it on the notice board clearly giving the deadline for payment.</li>
                                        <li>Mess payment must be made by 7th of every month regularly. If any resident who fails to clear mess dues shall
                                            not be allowed to avail the facility and dues will be recovered from her deposited security.</li>
                                        <li>Residents must observe the mess timings for lunch and dinner as notified by the hostel warden.</li>
                                        <li>It will be the responsibility of the warden to check and ensure that the amount received from the students and
                                            its record shall be properly maintained.</li>
                                        <li>To ensure transparency, any relevant department / Committee of the University can periodically check the mess
                                            system, particularly food quality and maintenance of the record.</li>
                                    </ul>
                                    <h3 class="sidebar-title">Visitors</h3>
                                    <p>Following guidelines must be observed for visitors:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Rights of admission to the Hostel premises are reserved.</li>
                                        <li>Students must inform their intending guests about the visiting hours of the hostel.</li>
                                        <li>Following visiting hours shall be strictly observed:
                                            <ul class="my-3">
                                                <li>Summer : Sunday 8:00 am to 6:30 pm</li>
                                                <li>Winter : Sunday 8:00 am to 5:30 pm</li>
                                            </ul>
                                        </li>
                                        <li>Parents / authorized guardians of the female student(s) are allowed to see the student only in the visiting room
                                            of Girls Hostel during visiting hours.</li>
                                        <li>No female visitors are allowed to enter the rooms of hostel without seeking permission from hostel warden.</li>
                                        <li>No outsider shall be allowed to stay in the Hostel. Violation of this shall render the resident liable for expulsion
                                            from the Hostel and/or another penalty which the Warden may deem fit. The outsider found staying / residing in the
                                            Hostel may be handed over to the Police.</li>
                                        <li>The visitors should present their identification i.e. ID Card, contact number and proof of relation with the residing
                                            students.</li>
                                        <li>Residents are encouraged to submit a list of 4 names of family members, male or female, who will visit them. This list
                                            must be certified by the parents/guardians of the students.</li>
                                        <li>Residents should inform their guests about the verification procedure followed by hostel administration.</li>
                                        <li>Applications must be submitted to the hostel warden for leave at least 24 hours in advance.</li>
                                        <li>Residents cannot go outside the hostel for shopping, visiting their relatives or for recreation without verification
                                            and prior permission from the Warden.</li>
                                        <li>While going home they are required to submit leave proforma duly signed by the Warden.</li>
                                        <li>Residents going home should leave the hostel before sunset.</li>
                                        <li>Residents are required to return to the hostel before sunset.</li>
                                    </ul>
                                    <h3 class="sidebar-title">Note:</h3>
                                    <ul class="learning-outcomes mb-4">
                                        <li>University / Hostel Management reserves the right to revise the rules and regulations from time to time and will keep
                                            the resident informed of any changes in the form of notices on the hostel notice boards. Ignorance of rules will not
                                            be accepted as an excuse.</li>
                                        <li>Residents shall abide by the Hostel Regulations. Violation of any regulation or order issued by the Hostel Authority
                                            shall render a resident liable to disciplinary action including expulsion from the hostel.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Housing & Transport Page Area End Here -->

@endsection
