@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Fee Structure</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="admission-area my-5">
        <div class="container">
            <h1 class="admission-title">Fee Structure</h1>
        </div>
    </div>
    <!-- Admission Area End Here -->

    <!-- Courses Page 5 Area Start Here -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div class="course-details-inner">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-3 col-lg-3 col-md-3">
                                    <ul class="course-details-tab-btn nav flex-column" id="myTab" role="tablist">
                                        <button class="fac-title btn bg-red text-light py-3 my-2 w-100">FACULTY</button>
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Engineering and Information
                                                        Technology
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link "
                                                                                     id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Social Sciences and Management
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Languages and Humanities</div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Arts Design and Architectures
                                                    </div>
                                                </div>
                                            </a>
                                        </li>

                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-5-tab"
                                                                                     data-bs-toggle="tab" href="#menu-5"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Law, Fiqh and Islamic Shariah
                                                    </div>
                                                </div>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                                <div class="col-xl-9 col-lg-9 col-md-9">
                                    <div class="tab-content">
                                        <!-- Faculty 1 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn active" id="menu-1"
                                             role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-yellow border-1 border-light">Serial
                                                            </th>
                                                            <th colspan="2"
                                                                class="text-yellow text-center border-1 border-light">
                                                                Programs
                                                            </th>
                                                            <th colspan="2" class="text-yellow border-1 border-light">
                                                                Code
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Tution
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Enrollment
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Exam
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Total
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Degree
                                                                Fee
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-light bg-red" colspan="13">
                                                                Faculty of Engineering and Information Technology
                                                            </th>
                                                        </tr>

                                                        </thead>
                                                        <tbody>

                                                        {{-- Department of Sciences--}}
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="13">DEPARTMENT OF COMPUTING AND INTELLIGENT
                                                                SYSTEMS
                                                            </th>
                                                        </tr>


                                                        {{-- BSCS--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">1.</td>
                                                            <td colspan="2">BS Computer
                                                                Science
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-computer-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSCS
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>
                                                        {{-- ADPCS--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">2.</td>
                                                            <td colspan="2">ADP Computer
                                                                Science
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-computer-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPCS
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>
                                                        {{-- BSSE--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">3.</td>
                                                            <td colspan="2">BS Software Engineering
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-software-engineering"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSSE
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>
                                                        {{-- ADPSE--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">4.</td>
                                                            <td colspan="2">ADP Software Engineering
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-software-engineering"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPSE
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">5.</td>
                                                            <td colspan="2">     ADP Data Science
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-data-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">AD DS
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                -
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">6.</td>
                                                            <td colspan="2"> ADP Cybersecurity
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-cyber-security"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADP CYS
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                -
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">7.</td>
                                                            <td colspan="2"> ADP Artificial Intelligence
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-artificial-intelligence"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADP AI
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                -
                                                            </td>
                                                        </tr>
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">8.</td>
                                                            <td colspan="2">   ADP Information Technology
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-information-technology"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADP IT
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                -
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- Faculty 2 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn show " id="menu-2"
                                             role="tabpanel" aria-labelledby="menu-2-tab">
                                            <div class="row p-2">
                                                <!-- Fee Structure Start Here -->
                                                <div class="program-degree-area">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                            <tr class="bg-gunmetal text-white py-5 light-bold">
                                                                <th class="text-yellow border-1 border-light">Serial
                                                                </th>
                                                                <th colspan="2"
                                                                    class="text-yellow text-center border-1 border-light">
                                                                    Programs
                                                                </th>
                                                                <th colspan="2"
                                                                    class="text-yellow border-1 border-light">
                                                                    Code
                                                                </th>
                                                                <th class="text-yellow border-1 border-light">Tution
                                                                </th>
                                                                <th class="text-yellow border-1 border-light">Enrollment
                                                                </th>
                                                                <th class="text-yellow border-1 border-light">Exam
                                                                </th>
                                                                <th class="text-yellow border-1 border-light">Total
                                                                </th>
                                                                <th class="text-yellow border-1 border-light">Degree
                                                                    Fee
                                                                </th>
                                                            </tr>
                                                            <tr class="full-bold">
                                                                <th class="text-center text-light bg-red" colspan="13">
                                                                    Faculty of
                                                                    Social
                                                                    Sciences and Management
                                                                </th>
                                                            </tr>
                                                            <tr class="light-box">
                                                                <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                    colspan="13">Department of APPLIED BUSINESS AND
                                                                    ECONOMICS
                                                                </th>
                                                            </tr>

                                                            </thead>
                                                            <tbody>
                                                            {{-- BBA--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">9.</td>
                                                                <td colspan="2">Bachelor of Business Administration
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/bachelor-of-business-administration"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">BBA
                                                                </td>
                                                                <td class="text-center align-middle"> 88,750
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 101,250
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    810,000
                                                                </td>
                                                            </tr>
                                                            {{-- ADPBBA--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">10.</td>
                                                                <td colspan="2">ADP Business Administration & Commerce
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-of-business-administration"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">ADPBA&C
                                                                </td>
                                                                <td class="text-center align-middle"> 88,750
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 101,250
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    810,000
                                                                </td>
                                                            </tr>
                                                            {{-- BSAF--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">11.</td>
                                                                <td colspan="2">BS Accounting and Finance
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/bs-accounting-and-finance"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">BSAF
                                                                </td>
                                                                <td class="text-center align-middle"> 77,500
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 90,000
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    720,000
                                                                </td>
                                                            </tr>

                                                            {{-- ADPAF--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">12.</td>
                                                                <td colspan="2">ADP Accounting and Finance
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-accounting-and-finance"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">ADPAF
                                                                </td>
                                                                <td class="text-center align-middle"> 77,500
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 90,000
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    720,000
                                                                </td>
                                                            </tr>

                                                            {{-- ADP-E&D--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">13.</td>
                                                                <td colspan="2"> ADP E-Commerce and Digital Marketing
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-e-commerce-and-digital-marketing"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">ADP E.com
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">-
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                   -
                                                                </td>
                                                            </tr>


                                                            {{-- ADP-E&D--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">14.</td>
                                                                <td colspan="2">ADP Hospitality & Tourism Management
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-hospitality-and-tourism-management"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">ADP HTM
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">-
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    -
                                                                </td>
                                                            </tr>



                                                            <thead>
                                                            {{-- Department of Psychology --}}
                                                            <thead>
                                                            {{-- Department of Psychology --}}
                                                            <tr class="light-box">
                                                                <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                    colspan="13">DEPARTMENT OF BEHAVIORAL AND SOCIAL
                                                                    SCIENCES
                                                                </th>
                                                            </tr>
                                                            </thead>
                                                            {{-- BSP--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">15.</td>
                                                                <td colspan="2">BS Psychology
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/bs-psychology"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">BS Psy
                                                                </td>
                                                                <td class="text-center align-middle"> 55,000
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 67,500
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    540,000
                                                                </td>
                                                            </tr>

                                                            {{-- ADPP--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">16.</td>
                                                                <td colspan="2">ADP Psychology
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-psychology"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle">ADP Psy
                                                                </td>
                                                                <td class="text-center align-middle"> 55,000
                                                                </td>
                                                                <td class="text-center align-middle">7,500
                                                                </td>
                                                                <td class="text-center align-middle"> 5,000
                                                                </td>
                                                                <td class="text-center align-middle"> 67,500
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    540,000
                                                                </td>
                                                            </tr>

                                                            {{-- AD BOT--}}
                                                            <tr class="table-contact">
                                                                <td class="text-center align-middle">17.</td>
                                                                <td colspan="2">ADP Biotechnology
                                                                    <a class="badge bg-red light-dark align-middle ms-2"
                                                                       href="{{ URL('/') }}/course-detail/adp-biotechnology"
                                                                       target="blank"><i
                                                                            class="fa fa-angle-double-right"></i> SEE
                                                                        MORE</a></td>
                                                                <td colspan="2" class="text-center align-middle"> ADP BT
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">-
                                                                </td>
                                                                <td class="text-center align-middle">-
                                                                </td>
                                                                <td class="text-center align-middle"> -
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                   -
                                                                </td>
                                                            </tr>


                                                            </tbody>
                                                        </table>
                                                    </div>

                                                </div>
                                                <!-- Fee Structure End Here -->
                                            </div>
                                        </div>

                                        <!-- Faculty 3 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-3-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-yellow border-1 border-light">Serial
                                                            </th>
                                                            <th colspan="2"
                                                                class="text-yellow text-center border-1 border-light">
                                                                Programs
                                                            </th>
                                                            <th colspan="2" class="text-yellow border-1 border-light">
                                                                Code
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Tution
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Enrollment
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Exam
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Total
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Degree
                                                                Fee
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-light bg-red" colspan="13">
                                                                Faculty of
                                                                Languages and Humanities
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="13">DEPARTMENT of LINGUISTIC AND CULTURAL
                                                                STUDIES
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        {{-- BSEL--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">18.</td>
                                                            <td colspan="2">BS English and Linguistic Studies
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-english_and_linguistic_studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSEL
                                                            </td>
                                                            <td class="text-center align-middle"> 66,250
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 78,750
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                630,000
                                                            </td>
                                                        </tr>
                                                        {{-- ADPEL--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">19.</td>
                                                            <td colspan="2">ADP English and Linguistic Studies
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-english_and_linguistic_studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPEL
                                                            </td>
                                                            <td class="text-center align-middle"> 66,250
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 78,750
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                630,000
                                                            </td>
                                                        </tr>
                                                        {{-- BSMC--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">20.</td>
                                                            <td colspan="2">BS Media and Communication Studies
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-media-and-communication-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSMCS
                                                            </td>
                                                            <td class="text-center align-middle"> 55,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 67,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                540,000
                                                            </td>
                                                        </tr>


                                                        {{-- ADPMC--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">21.</td>
                                                            <td colspan="2">ADP Media and Communication Studies
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-media-and-communication-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPMCS
                                                            </td>
                                                            <td class="text-center align-middle"> 55,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 67,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                540,000
                                                            </td>
                                                        </tr>


                                                        </tbody>

                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 7 End Here -->

                                        <!-- Faculty 9 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-4" role="tabpanel"
                                             aria-labelledby="menu-4-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-yellow border-1 border-light">Serial
                                                            </th>
                                                            <th colspan="2"
                                                                class="text-yellow text-center border-1 border-light">
                                                                Programs
                                                            </th>
                                                            <th colspan="2" class="text-yellow border-1 border-light">
                                                                Code
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Tution
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Enrollment
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Exam
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Total
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Degree
                                                                Fee
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-light bg-red" colspan="13">
                                                                Faculty of
                                                                Arts &
                                                                Social Sciences
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="13">DEPARTMENT OF INTERIOR DESIGN
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        {{-- BSDC--}}

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">22.</td>
                                                            <td colspan="2">BS  Digital Design and Computer Arts
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-digital-design-and-computer-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle"> BS DDCA
                                                            </td>
                                                            <td class="text-center align-middle"> 55,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 67,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                540,000
                                                            </td>
                                                        </tr>

                                                        {{-- ADPCD--}}

                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">23.</td>
                                                            <td colspan="2">ADP  Digital Design and Computer Arts
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-digital-design-and-computer-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADP DDCA
                                                            </td>
                                                            <td class="text-center align-middle"> 55,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 67,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                540,000
                                                            </td>
                                                        </tr>




                                                        </tbody>
                                                        <thead>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="13">DEPARTMENT OF ARTS AND DIGITAL MEDIA
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        {{-- BSID--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">24.</td>
                                                            <td colspan="2">BS Interior Design
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-interior-design"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSID
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>

                                                        {{-- ADPID--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">25.</td>
                                                            <td colspan="2">ADP Interior Design
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-interior-design"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPID
                                                            </td>
                                                            <td class="text-center align-middle"> 100,000
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 112,500
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                900,000
                                                            </td>
                                                        </tr>

                                                        {{-- ADPFA--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">26.</td>
                                                            <td colspan="2">ADP Fine Arts
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-fine-arts"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPFA
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">
                                                               -
                                                            </td>
                                                        </tr>

                                                        </tbody>
                                                    </table>


                                                </div>

                                            </div>
                                        </div>
                                        <!-- Faculty 9 End Here -->


                                        <!-- Faculty 6 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-5" role="tabpanel"
                                             aria-labelledby="menu-5-tab">
                                            <div class="program-degree-area">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead>
                                                        <tr class="bg-gunmetal text-white py-5 light-bold">
                                                            <th class="text-yellow border-1 border-light">Serial
                                                            </th>
                                                            <th colspan="2"
                                                                class="text-yellow text-center border-1 border-light">
                                                                Programs
                                                            </th>
                                                            <th colspan="2" class="text-yellow border-1 border-light">
                                                                Code
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Tution
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Enrollment
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Exam
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Total
                                                            </th>
                                                            <th class="text-yellow border-1 border-light">Degree
                                                                Fee
                                                            </th>
                                                        </tr>
                                                        <tr class="full-bold">
                                                            <th class="text-center text-light bg-red" colspan="13">
                                                                Faculty of Law, Fiqh and Islamic Shariah
                                                            </th>
                                                        </tr>
                                                        <tr class="light-box">
                                                            <th class="text-center text-white bg-blue text-uppercase text-uppercase"
                                                                colspan="13">DEPARTMENT OF ISLAMIC STUDIES Studies AND
                                                                JURISPRUDENCE
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        {{-- BSIS--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">27.</td>
                                                            <td colspan="2">BS Islamic Sciences
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/bs-islamic-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">BSIS
                                                            </td>
                                                            <td class="text-center align-middle"> 16,250
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 28,750
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                230,000
                                                            </td>
                                                        </tr>


                                                        {{-- ADPIS--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">28.</td>
                                                            <td colspan="2">ADP Islamic Sciences
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-islamic-science"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPIS
                                                            </td>
                                                            <td class="text-center align-middle"> 16,250
                                                            </td>
                                                            <td class="text-center align-middle">7,500
                                                            </td>
                                                            <td class="text-center align-middle"> 5,000
                                                            </td>
                                                            <td class="text-center align-middle"> 28,750
                                                            </td>
                                                            <td class="text-center align-middle">
                                                                230,000
                                                            </td>
                                                        </tr>

                                                        {{-- ADPIS--}}
                                                        <tr class="table-contact">
                                                            <td class="text-center align-middle">29.</td>
                                                            <td colspan="2">ADP Paralegal Studies
                                                                <a class="badge bg-red light-dark align-middle ms-2"
                                                                   href="{{ URL('/') }}/course-detail/adp-paralegal-studies"
                                                                   target="blank"><i
                                                                        class="fa fa-angle-double-right"></i> SEE
                                                                    MORE</a></td>
                                                            <td colspan="2" class="text-center align-middle">ADPLS
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle">-
                                                            </td>
                                                            <td class="text-center align-middle"> -
                                                            </td>
                                                            <td class="text-center align-middle">
                                                               -
                                                            </td>
                                                        </tr>

                                                        </tbody>

                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Faculty 6 End Here -->
                                        <div>
                                            <h3></h3>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <h4 class="mt-2 fw-bold">Note:</h4>
                        <div class="note">
                            <p><strong>Admission Fees:</strong> At the time of admission, students are required to pay
                                the following fees:</p>
                            <ul>
                                <li>Admission Processing Fee: Rs. 1,500 (Non-Refundable)</li>
                                <li>Admission Fee: Rs. 10,000 (Non-Refundable)</li>
                                <li>ID Card Fee: Rs. 500 (Non-Refundable, charged once at admission)</li>
                                <li>Security Fee: Rs. 15,000 (Refundable after clearance)</li>
                            </ul>
                        </div>

                        <div class="note">
                            <h4><strong>Document Verifications</strong></h4>
                            <p>A fee of Rs. 1,000 will be charged for document verification (Non-Refundable).</p>
                            <h4><strong>Tuition Fees:
                                </strong></h4>
                            <p>Tuition fees are payable on a semester basis. Students must pay their tuition fees in
                                advance before the commencement of each semester.</p>
                        </div>


                        <div class="note">
                            <h4><strong>Refund Policy:
                                </strong></h4>
                            <p><strong>Security Refund:</strong> University/Hostel security will be refundable within
                                two years after issuance of final result notification but only after final fee
                                clearance. Competent authority may allow late submission of the application for a refund
                                of security in exceptional cases.</p>
                            <h4><strong>Tuition Fee Refund:
                                </strong></h4>
                            <ul>
                                <li>Within 7 days of commencement of classes or joining of classes (in case the student
                                    is admitted late): Full tuition fee will be refunded.
                                </li>
                                <li>From the 8th to the 15th day of commencement of classes: 50% of the tuition fee will
                                    be refunded.
                                </li>
                                <li>After the 15th day of commencement of classes: No refund.</li>
                            </ul>
                            <h4><strong>Payment Methods:
                                </strong></h4>
                            <p>Fees can be paid through bank transfer, online payment, or other acceptable methods as
                                specified by the university.</p>
                            <h4><strong>Important:
                                </strong></h4>
                            <ul>
                                <li>Ensure all fee payments are made on time to avoid any disruption in academic activities.
                                </li>
                                <li>For further information or assistance, please contact our admissions office at 051-8770178-9 or visit our website's FAQ section
                                </li>

                            </ul>

                        </div>


                    </div>

                </div>

                <div>

                </div>
            </div>
        </div>
    </div>
    <!-- Courses Page 5 Area End Here -->

@endsection
