@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Fee Policy</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="admission-area my-5">
        <div class="container">
            <h1 class="admission-title">FEE POLICY</h1>
            <div class="row">
                <div class="col-md-12">
                    <h4 class="sidebar-heading">1. PURPOSE</h4>
                    <p>The purpose of this document is to establish general policies and procedures for collection of student fee at University of Rawalpindi.</p>
                    <h4 class="sidebar-heading">2. SCOPE</h4>
                    <p>This policy is applicable to students, parents/guardians and staff who are involved in dealing with financial matters.</p>
                    <h4 class="sidebar-heading">3. FEE CATEGORIES</h4>
                    <p>Student will be charged fee in following categories at rates prescribed from time to time by the Finance and Planning Committee</p>
                    <p><b>3.1 Security: </b> A refundable   security (once only) will be charged at the time of
                        admission. Any amount recoverable from the student will be adjusted against security at the
                        time of his/her withdrawal /passing out.</p>
                    <p><b>3.2 Admission Fee:</b> A non-refundable admission fee (once only) will be charged at the time of
                        admission from the student being admitted in any discipline.
                    </p>
                    <p><b>3.3 Document Verification Fee:</b>Document verification fee (once only) will be charged from
                        student at the time of admission for verification of certificate/ degree from the institution last attended.
                    </p>
                    <p><b>3.4 Semester Fee:</b> Semester fee will be received in advance before the commencement of each
                        semester. Semester fee includes:

                    </p>
                    <div class="ms-2">
                        <p>a) Tuition Fee</p>
                        <p>b) Semester Registration Fee</p>
                        <p>c) Examination Fee</p>
                        <p>d) Tour Charges (to be consumed for academic tour in each semester</p>
                        <p>e)	Sports Fund (to be utilized for extracurricular activities of students)</p>
                    </div>
                    <p><b>3.5 Hostel Fee (where applicable):</b> Hostel fee will be charged annually from the students availing
                        the boarding and lodging facility of the University. However, under special circumstances, semester wise or monthly hostel fee may be charged.
                    </p>
                    <p><b>3.6 Others:</b> : Additionally, fee against the issuance of degrees, certificates and verification will
                        be charged as and when required.

                    </p>
                    <h4 class="sidebar-heading">4. FEE STRUCTURE</h4>
                    <p>Fee structure of each degree programs is approved by the Finance and Planning Committee for each session. However, university reserves the right to introduce or alter fee at any time without prior notice. A moderate increase in tuition fee will be charged annually to cover the inflationary trend in the country.</p>
                    <h4 class="sidebar-heading">5. PAYMENT OF DUES</h4>
                    <p>5.1. Applicant, who receive an offer of admission are required to pay their dues prior to
                        commencement of classes in order to secure their admission. The applicant who does not pay his/her dues within due date will forfeit his/her right of admission.
                    </p>
                    <h4 class="sidebar-heading">6. PROCEDURE OF FEE PAYMENT</h4>
                    <p>6.1 Semester fee will be received in advance.</p>
                    <p>6.2 All fee payments will be made according to the notified schedule. </p>
                    <p>6.3 Student desirous of paying fee in cash will collect fee challan from accounts department
                        for fee deposit in designated bank before one week of due date
                    </p>
                    <p>6.4 If a fee challan is lost by the student, he/she will have to pay a fine of Rs 50/- for duplicate
                        fee challan

                    </p>
                    <!-- <p>6.4 Student desirous of paying fee in cash will collect fee challan from accounts department for fee deposit in designated bank before one week of due date. Cheques of such student will be returned to them accordingly.</p> -->
                    <p>6.5 <b> Fee Installment:</b><br></p>
                    <p>Student desirous of paying fee in installments will be given following three options at the
                        time of admission or during degree program after proven need due to financial hardships.
                    </p>
                    <p class="ms-3"><b>i. Two installments:</b></p>
                    <p class="ms-4">1st installment <span class="ms-4">&nbsp;&nbsp;50 % of the tuition fee along with all other charges</span>
                    </p>
                    <p class="ms-4">2nd installment <span class="ms-4">(8 weeks after the start of classes) 50% of tuition fee</span>
                    </p>

                    <p class="ms-3"><b>ii. Three installments:</b></p>
                    <p class="ms-4">1st installment <span class="ms-4">&nbsp;&nbsp;50 % of the tuition fee along with all other charges</span>
                    </p>
                    <p class="ms-4">2nd installment <span class="ms-4">(6 weeks after the start of classes) 25% of the tuition fee</span>
                    </p>
                    <p class="ms-4">3rd installment <span class="ms-4">&nbsp;(10 weeks after the start of classes) 25% of the tuition fee</span>
                    </p>

                    <div class="ms-3"><p><b>iii. Monthly Installments: by 10th of every month</b></p>
                        <p class="ms-2">a) 5% service charges will be paid by the student along with the installment amount.</p>
                        <p class="ms-2">b)	Student will submit "Installment Request Form" minimum one week before the
                            notified date.
                        </p>
                        <p class="ms-2">c)	Postdated cheques will be submitted for each installment.
                        </p>
                        <p class="ms-2">d)	All applications for fee installment will be processed within a week of submission.
                        </p>
                        <p class="ms-2">e)	Students defaulting payment in a semester will not be entitled for installments in subsequent semesters.
                        </p>
                    </div>

                    <p>6.6 <b> Fee Extension:</b><br></p>
                    <p class="ms-2">a)	Student unable to pay fee by due date may apply for extension. Extension can be granted maximum one day before the commencement of classes on payment of late fee fine as per policy subject to approval of competent authority.</p>
                    <p class="ms-2">b)	Cheque of student availing concession will not be presented in bank.</p>
                    <p class="ms-2">c)	Cheque dishonor policy will be applied on the student applying for extension after the due date (when cheque is presented and the same is dishonored).</p>
                    <!-- <p class="ms-2">b) Cheque of student applied for extension will be hold till the decision is communicated to the student.</p>
                    <p class="ms-2">c) Cheque dishonor policy will be applied on the student availing extension in fee deposit but could not submit fee by the date (approved after extension). </p> -->
                    <h4 class="sidebar-heading">7. LATE FEE FINE</h4>
                    <p class="mb-1">In case a student fails to pay his/her dues by the specified date, late fee fine will be charged. Late fee fine for applicant of scholarship/ financial aid will not be charged upto 10 days from the date of decision in which scholarship/ financial aid has been granted or rejected. After 10 days late fee fine shall be charged as per below schedule.</p>
                    <div class="table-responsive">
                        <table class="table my-3">
                            <thead class="" style="background-color:#d6001c;">
                            <tr>
                                <th class="text-light">Sr No</th>
                                <th class="text-white">Period</th>
                                <th class="text-white">Fine (Rs)</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td><p>1.</p></td>
                                <td><p>Within 10 days after due date
                                    <p></td>
                                <td><p>500/-</p></td>
                            </tr>
                            <tr>
                                <td><p>2.</p></td>
                                <td><p>After 10 Days</p></td>
                                <td><p>2,000/-</p></td>
                            </tr>
                            <tr>
                                <td><p>3.</p></td>
                                <td><p>After one month</p></td>
                                <td><p>5,000/-</p></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>


                    <h4 class="sidebar-heading">8. WITHDRAWAL FROM ACADEMIC PROGRAM</h4>
                    <p>Student withdrawing from degree program is required to submit the student's clearance form to Registrar Office. Students who do not follow the process will not be eligible for any refund of fee or security.</p>
                    <h4 class="sidebar-heading">9. CHANGE OF PROGRAM OF STUDY</h4>
                    <p>Student will be entitled to change degree program once in an academic career and within two weeks of commencement of classes.</p>
                    <p>In case of change of degree program, student will be required to pay fee of new degree program accordingly.</p>
                    <h4 class="sidebar-heading">10. SEMESTER EXTENSION</h4>
                    <p>If duration of study in MS, MPhil & PhD programs is extended due to any reason, fee for that
                        period shall be charged (semester wise) as per his/her last semester fee.</p>
                    <h4 class="sidebar-heading">11. REFUND POLICY</h4>
                    <p>11.1. University/Hostel security will be refundable within two years after issuance of final result notification but after final fee clearance. However competent authority may condone the late submission of application for refund of security.</p>
                    <p>11.2. If a student withdraws from the academic program, following refund policy of HEC adopted by University will be applicable:</p>
                    <table class="table my-3 table-responsive">
                        <thead class="" style="background-color:#d6001c;">
                        <tr>
                            <th class="text-white border-right">Application Date</th>
                            <th class="text-white border-right">Amount to be refunded</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="border-right border-left"><p>Within 7th day of commencement of classes
                                <p></td>
                            <td class="border-right border-left"><p>Full tuition fee will be refunded</p></td>


                        </tr>
                        <tr>
                            <td class="border-right border-left"><p>From 8th - 15th day of commencement of
                                    classes</p></td>
                            <td class="border-right border-left"><p>50% of the tuition fee will be refunded</p></td>


                        </tr>

                        <tr class="border-bottom">
                            <td class="border-right border-left"><p>After 15th day of commencement of classes.</p>
                            </td>
                            <td class="border-right border-left"><p>No Refund</p></td>


                        </tr>
                        </tbody>
                    </table>
                    <p>11.3. Full fee of a student who is not promoted to next semester (for which the fee is paid)
                        will be refundable.</p>
                    <p>11.4.     Fee refund will be applicable from the date of submission of withdrawal application to Registrar Office.</p>
                    <p>11.5. Fee of the running semester will not be refundable if student is expelled / suspended due to disciplinary reason(s) during the semester.</p>
                    <h4 class="sidebar-heading">12. ADVANCE INCOME TAX UNDER SECTION 236 (I) OF INCOME TAX ORDINANCE, 2001</h4>
                    <p>12.1 As per tax rule university shall collect advance tax, on behalf of the government, @ 5%
                        on the entire amount of fee if payable fee exceeds Rs. 200,000 per annum.</p>
                    <p>12.2 The parent/guardian is required to provide NTN or CNIC number so that it can be adjusted
                        at the time of income tax return. </p>
                    <p>12.3 The University will issue tax deduction certificate.</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Admission Area End Here -->
@endsection
