@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Faculties & Departments</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="admission-area my-5">
        <div class="container">
            <h1 class="admission-title">Faculties & Departments</h1>
            <p>Offering a wide range of academic disciplines across multiple faculties, the University of Rawalpindi
                promotes interdisciplinary learning and specialized knowledge. Our dynamic and diverse learning
                environment aims to provide students with the information, abilities, and critical thinking needed to
                succeed in their chosen disciplines. Every department and faculty member is committed to providing a
                comprehensive educational experience through innovative research, creative teaching methods, and a
                supportive learning atmosphere. At the University of Rawalpindi, we believe in the transformative power
                of education to change lives and communities. Our faculties and departments are structured to provide a
                wide array of academic options, ensuring that students obtain a comprehensive education that equips them
                for future challenges. Whether your passions are in computer sciences, business administration,
                psychology, English and linguistic studies, media and communication studies, digital design and computer
                arts, interior design, or Islamic sciences, our university fosters an environment that nurtures your
                success and helps you reach your academic and career aspirations.</p>
            <p>Explore our faculties and departments to discover the unique opportunities and programs we offer.</p>
        </div>
    </div>
    <!-- Admission Area End Here -->

    <!-- Courses Page 5 Area Start Here -->
    <div class="courses-page-area5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div class="course-details-inner">
                        <div class="course-details-tab-area">
                            <div class="row">
                                <div class="col-xl-3 col-lg-3 col-md-3">
                                    <ul class="course-details-tab-btn nav flex-column" id="myTab" role="tablist">
                                        <button class="fac-title btn bg-red text-light py-3 my-2 w-100">FACULTY</button>
                                        <li class="menu-item" role="presentation"><a class="menu-link active"
                                                                                     id="menu-1-tab"
                                                                                     data-bs-toggle="tab" href="#menu-1"
                                                                                     role="tab" aria-controls="menu-1"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Engineering and Information
                                                        Technology
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link " id="menu-2-tab"
                                                                                     data-bs-toggle="tab" href="#menu-2"
                                                                                     role="tab" aria-controls="menu-2"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Social Sciences and Management
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-3-tab"
                                                                                     data-bs-toggle="tab" href="#menu-3"
                                                                                     role="tab" aria-controls="menu-3"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Languages and Humanities</div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link" id="menu-4-tab"
                                                                                     data-bs-toggle="tab" href="#menu-4"
                                                                                     role="tab" aria-controls="menu-4"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Arts Design and Architecture</div>
                                                </div>
                                            </a>
                                        </li>
                                        <li class="menu-item" role="presentation"><a class="menu-link "
                                                                                     id="menu-5-tab"
                                                                                     data-bs-toggle="tab" href="#menu-5"
                                                                                     role="tab" aria-controls="menu-5"
                                                                                     aria-selected="false">
                                                <div class="row align-items-center">
                                                    <div class="col-md-2"><i class="fa fa-external-link fac-icon"></i>
                                                    </div>
                                                    <div class="col-md-10">Faculty of Law, Fiqh and Islamic Shariah
                                                    </div>
                                                </div>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                                <div class="col-xl-9 col-lg-9 col-md-9">
                                    <div class="tab-content">
                                        <!-- Faculty 1 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn active" id="menu-1"
                                             role="tabpanel"
                                             aria-labelledby="menu-1-tab">
                                            <div class="row p-2">
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-computing-and-intelligent-systems">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-computing-and-intelligent-systems.jpg"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 1 Start Here -->

                                            </div>
                                        </div>
                                        <!-- Faculty 1 End Here -->

                                        <!-- Faculty 2 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-2" role="tabpanel"
                                             aria-labelledby="menu-2-tab">
                                            <div class="row p-2">
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-applied-business-and-economics">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-applied-business-and-economics.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 1 End Here -->


                                                <!-- Department 3 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-behavioral-and-social-sciences">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-behavioral-and-social-sciences.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 3 End Here -->
                                            </div>
                                        </div>
                                        <!-- Faculty 2 End Here -->

                                        <!-- Faculty 3 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn" id="menu-3" role="tabpanel"
                                             aria-labelledby="menu-3-tab">
                                            <div class="row p-2">
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-linguistic-and-cultural-studies">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-linguistic-and-cultural-studies.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 1 End Here -->
                                            </div>
                                        </div>
                                        <!-- Faculty 3 End Here -->

                                        <!-- Faculty 4 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn " id="menu-4"
                                             role="tabpanel" aria-labelledby="menu-4-tab">
                                            <div class="row p-2">
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-art-and-digital-media">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-art-and-digital-media.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-interior-design">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-interior-design.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Faculty 4 End Here -->

                                        <!-- Faculty 5 Start Here -->
                                        <div class="tab-pane tab-item animated fadeIn " id="menu-5"
                                             role="tabpanel" aria-labelledby="menu-5-tab">
                                            <div class="row p-2">
                                                <!-- Department 1 Start Here -->
                                                <div class="col-lg-4 col-sm-6 text-center my-3">
                                                    <a href="{{ URL('/') }}/department-detail/department-of-islamic-studies-and-jurisprudence">
                                                        <div class="card py-4 h-100 border-0">
                                                            <img id="department-thumbnail" class="svg"
                                                                 src="{{ asset('frontend/academics') }}/img/departments/2024/department-of-islamic-studies-and-jurisprudence.png"
                                                                 alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- Department 1 Start Here -->
                                            </div>
                                        </div>
                                        <!-- Faculty 5 End Here -->

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Courses Page 5 Area End Here -->

@endsection
