@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Law</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.departments')}}">Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper my-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">

                <div class="col-lg-12 fac-message p-2 ms-lg-3">
                    <div class="text-center message-wrap p-4">
                        <h1 class="hod-msg mt-2">MESSAGE OF HOD</h1>
                        <img src="{{ asset('frontend/academics') }}/img/commas-new.png" height="30" alt="" class="comma-icon img-1">
                        <img src="{{ asset('frontend/academics') }}/img/commas-new.png" height="30" alt="" class="comma-icon img-2">
                        <div class="message-wrap">
                            <div class="image-handling">
                                <img src="{{ asset('frontend/academics') }}/img/hod/2024/department-of-law-hod.jpg" class="float-start me-3">
                            </div>
                            <p></p><p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-size:12.0pt"><span style="line-height:150%"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">I extend a warm and enthusiastic welcome to all students, faculty, and esteemed stakeholders of the Law Department. As the Head of the Department, leading this community of aspiring legal professionals is a tremendous privilege.</span></span></span></span></span></span></p>

                            <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-size:12.0pt"><span style="line-height:150%"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">In our commitment to excellence in legal education and research, the Department of Law at Green International University takes pride in its dedication to practical education. We believe in providing a transformative learning experience, equipping our students not just with theoretical knowledge but with practical skills crucial for navigating the dynamic legal field.</span></span></span></span></span></span></p>

                            <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-size:12.0pt"><span style="line-height:150%"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">Our distinguished faculty, experts in their respective domains, are committed to creating a nurturing and collaborative learning environment. At Green International University, the Department of Law stands as a hub for practical education, where law moots simulate courtroom experiences, guest lecture series bring real-world insights, law clinics offer practical legal services, and workshops provide opportunities for skill enhancement. This approach ensures that our graduates are not only well-versed in legal theory but are also equipped with practical skills needed in their professional journey. Beyond practical training, we foster a sense of community, legal ethics, and social responsibility.</span></span></span></span></span></span></p>

                            <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-size:12.0pt"><span style="line-height:150%"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">&nbsp;Thank you for choosing the Department of Law at Green International University. Let's shape the future of law together!</span></span></span></span></span></span></p><p></p>
                            <div class="text-end">
                                <h5 class="mb-0">MS. Shafaq Ijaz</h5>
                                <p class="text-end mt-0">Acting Head, Department of Law</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row  pb-5 faculty-detail-mv">
                    <div class="col-lg-6 qec-vision-mision ">
                        <div class="qec-vision-block text-center bg-red  py-2 my-2 px-sm-4 ms-lg-3">
                            <h3 class="pt-3"><span class="text-white">VISION</span></h3>
                        </div>
                        <div class="vision-mision-content card-body px-md-4 mt-3 ms-lg-3">
                            <p>Green International University's Law Department envisions defining the future of law with excellence, innovation, and the cultivation of brilliant minds.</p>
                        </div>
                    </div>
                    <div class="col-lg-6 qec-vision-mision">
                        <div class="qec-vision-block text-center bg-red text-white  py-2 my-2 px-sm-4">
                            <h3 class="pt-3"><span class="text-white">MISSION</span></h3>
                        </div>
                        <div class="vision-mision-content card-body px-md-4 mt-3">
                            <p>Embarking on a mission of educational excellence, the Department of Law at GIU is committed to delivering top-tier legal education. Our overarching goal is to cultivate graduates who will emerge as leaders in the legal profession and academia, contributing significantly to society. Through cutting-edge and globally acclaimed research, our commitment is to champion the principles of the rule of law and safeguard the rights of individuals. Furthermore, our dedication extends to innovative teaching methods, aligning Pakistani law education with global standards. Join us on this transformative journey as we shape not only legal professionals but visionaries poised to make a lasting impact.</p>
                        </div>
                    </div>
                </div>

                <div class="content-new-wrapper table-responsive">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content mt-lg-5">
                                    <div class="col-lg-12 g-0">

                                        <div class="fac-obj-border mt-lg-4 mt-5">
                                            <h1>OBJECTIVE</h1>
                                        </div>
                                        <ul style="list-style-type:circle">
                                            <li style="list-style-type:none">
                                                <ul style="list-style-type:circle">
                                                    <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:200%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">The Law Department at Green International University aims to foster a profound understanding of substantive and procedural laws, aligning students with a commitment to excellence. Our objective is to cultivate future Researchers or Academicians, exposing them to diverse research techniques that adhere to global standards. We prioritize practical knowledge through exposure to legal arenas, bridging theory with real-world applications. Furthermore, we educate students on professional obligations, emphasizing ethical standards, social responsibility, and moral development to nurture well-rounded individuals committed to ethical practices in the legal profession.</span></span></span></span></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="row fac-scope-content">
                                    <div class="col-lg-12 g-0">
                                        <div class="fac-sco-border">
                                            <h1>ABOUT US</h1>
                                        </div>
                                        <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:200%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">Welcome to the Green International University Law Department, where academic excellence and practical legal education converge. We are dedicated to shaping future legal professionals through innovative teaching, hands-on experiences, and a commitment to real-world application.</span></span></span></span></p>

                                        <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:200%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">Our distinguished faculty, composed of seasoned legal experts, fosters a dynamic and collaborative learning environment. At the heart of our approach is the belief that practical education is paramount. We go beyond theory, providing students with the skills and experiences necessary for success in the evolving legal landscape.</span></span></span></span></p>

                                        <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:200%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">As a department, we are at the forefront of cutting-edge research, addressing contemporary legal challenges, and actively contributing to the advancement of the legal profession. Our curriculum is designed to align with industry demands, producing graduates who are not only knowledgeable but also adept practitioners.</span></span></span></span></p>

                                        <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:200%"><span style="font-family:Calibri,&quot;sans-serif&quot;"><span style="font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">Thank you for choosing the Green International University Law Department. Join us on a transformative journey of intellectual growth, practical education, and a collective commitment to shaping the future of law.</span></span></span></span></p>
                                    </div>
                                </div>
                                <div class="row fac-career-content mt-1">
                                    <div class="col-lg-12 g-0">
                                        <div class="fac-car-border">
                                            <h1>CAREER OPPORTUNITIES</h1>
                                        </div>
                                        <p style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="font-family:Calibri,&quot;sans-serif&quot;">A degree in LL.B. opens up a broad spectrum of career prospects, offering graduates diverse opportunities to contribute to the legal field and beyond. Here are some potential career paths for LL.B. graduates:</span></span></span></p>

                                        <ul>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Practicing Lawyer</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Judiciary Careers</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Corporate Sector Opportunities</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Government Roles</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Legal Consulting</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">ADR Specialists</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Academia</span></span></span></span></li>
                                            <li style="text-align:justify"><span style="font-size:11pt"><span style="line-height:150%"><span style="tab-stops:list .5in"><span style="font-family:Calibri,&quot;sans-serif&quot;">Legal Journalism</span></span></span></span></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="quick-link-pages pt-4 pb-2 px-3">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="{{ URL('/') }}/login" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true" style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

@endsection
