@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Islamic <br>Studies and Jurisprudence</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.faculties-and-departments')}}">Faculties & Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper mt-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">


                <div class="content-new-wrapper table-responsive mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content">
                                    <div class="col-lg-12 g-0">

                                    </div>
                                </div>
                                <div class="course-details-inner">
                                    <h3 class="title-default-left title-bar-high">Guiding Principles, Contemporary Applications</h3>
                                    <p>The Department of Islamic Studies and Jurisprudence at the University of Rawalpindi offers a profound exploration of Islamic law and its relevance in today’s world. Our comprehensive programs cover Islamic legal principles, Fiqh, and Shariah, preparing students for roles in academia, legal practice, and religious leadership. We emphasize a critical and ethical approach to Islamic jurisprudence, ensuring that students are well-equipped to navigate and apply these principles in modern contexts. Our esteemed faculty brings a wealth of scholarly and practical knowledge, fostering an environment of intellectual rigor and ethical reflection. Join us to explore the depths of Islamic law and contribute to the pursuit of justice and knowledge.</p>

                                    <h3 class="title-default-left title-bar-high">Why Study Islamic Sciences?</h3>
                                    <p>Studying Islamic Sciences at our department offers a deep dive into:</p>
                                    <ul>
                                        <li><strong>Islamic Law (Shariah):</strong> Gain insights into the principles and application of Islamic jurisprudence, covering diverse aspects such as family law, commercial transactions, and personal ethics.</li>
                                        <li><strong>Islamic History and Theology:</strong> Explore the historical development of Islamic thought and theology, understanding the evolution of Islamic scholarship and its relevance in modern times.</li>
                                        <li><strong>Ethical Framework:</strong> Learn ethical principles rooted in Islamic teachings, fostering a holistic approach to personal and professional conduct.</li>
                                    </ul>

                                    <p>Our program BS Islamic Sciences, equips students with:</p>
                                    <ul >
                                        <li><strong>Comprehensive Knowledge:</strong> Acquire a thorough understanding of classical and contemporary Islamic jurisprudence through rigorous academic study and practical applications.</li>
                                        <li><strong>Critical Thinking:</strong> Develop analytical skills to interpret and apply Islamic legal principles to contemporary issues and challenges.</li>
                                        <li><strong>Research and Debate:</strong> Engage in scholarly debates and research projects that contribute to the ongoing discourse within Islamic jurisprudence and ethics.</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">Learning Environment</h3>
                                    <p>At the Department of Islamic and Jurisprudence, we provide:</p>
                                    <ul  class="learning-outcomes mb-4">
                                        <li><strong>Scholarly Guidance:</strong> Learn from esteemed faculty members who are scholars in Islamic law and theology, offering mentorship and expertise in diverse areas of Islamic sciences.</li>
                                        <li><strong>Interactive Seminars:</strong> Participate in seminars and discussions that encourage critical thinking and deeper engagement with Islamic legal texts and principles.</li>
                                        <li><strong>Library Resources:</strong> Access a rich collection of Islamic manuscripts, texts, and digital resources to support your academic pursuits and research endeavors.</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">Study Abroad and Internship Opportunities</h3>
                                    <p>Prepare for global engagement and practical experience through:</p>
                                    <ul  class="learning-outcomes mb-4">
                                        <li><strong>Study Abroad Programs:</strong> Explore opportunities to study Islamic jurisprudence and comparative law in international contexts, gaining insights into different cultural and legal frameworks.</li>
                                        <li><strong>Internship Placements:</strong> Gain hands-on experience with legal institutions, NGOs, and research centers focused on Islamic studies and human rights advocacy.</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">Career Prospects</h3>
                                    <p>Graduates of BS Islamic Sciences are well-equipped for diverse professional roles:</p>
                                    <ul  class="learning-outcomes mb-4">
                                        <li><strong>Islamic Scholar:</strong> Enter academia or religious institutions as a researcher, educator, or cleric, contributing to the preservation and dissemination of Islamic knowledge.</li>
                                        <li><strong>Legal Consultant:</strong> Apply Islamic jurisprudence in legal practice, specializing in areas such as family law, inheritance law, and arbitration, serving both individuals and institutions seeking guidance on Islamic legal principles.</li>
                                        <li><strong>Community Leader:</strong> Assume leadership roles within communities, mosques, or Islamic centers, guiding congregations on matters of Islamic ethics, jurisprudence, and community welfare.</li>
                                        <li><strong>Public Service:</strong> Serve in governmental and non-governmental organizations focusing on social justice, human rights, and Islamic affairs, advocating for policies that uphold Islamic values and principles.</li>
                                        <li><strong>Researcher:</strong> Conduct research in Islamic studies, contributing to academic publications and scholarly discussions on contemporary issues within Islamic jurisprudence and theology.</li>
                                    </ul>

                                    <p>A degree in BS Islamic Sciences opens avenues to careers that blend deep knowledge of Islamic principles with practical applications in law, education, community leadership, and social advocacy, preparing graduates to make meaningful contributions to both local and global Islamic communities.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="content-new-wrapper table-responsive">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="sidebar-box mt-4 ">
                        <div class="sidebar-box-inner">
                            <h2 class="sidebar-title">Programs </h2>
                            <ul class="sidebar-categories">
                                <h6>
                                    <li><a href="{{ URL('/') }}/course-detail/bs-islamic-science">BS Islamic Sciences</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-islamic-science">ADP Islamic Sciences</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-paralegal-studies">ADP Paralegal Studies</a></li>
                                </h6></ul>
                        </div>
                    </div>
                    <div class="quick-link-pages pt-4 pb-2 px-3">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="{{url('https://admission.uor.edu.pk/')}}" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true"
                                                     style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

@endsection
