@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Behavioral <br> and Social Sciences</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.faculties-and-departments')}}">Faculties & Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper my-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">

                <div class="content-new-wrapper table-responsive mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content">
                                    <div class="col-lg-12 g-0">
                                        <div class="course-details-inner">
                                            <h3 class="title-default-left title-bar-high">Exploring the Human
                                                Experience</h3>
                                            <p>Dive into the intricate world of human behavior and societal structures
                                                with the Department of Behavioral and Social Sciences. Our
                                                interdisciplinary approach combines psychology, sociology, and
                                                anthropology, offering students a comprehensive perspective on social
                                                dynamics. Through rigorous research and critical analysis, we strive to
                                                address societal challenges and promote human well-being. Our faculty, a
                                                blend of researchers and practitioners, are dedicated to guiding
                                                students in their exploration of the human condition. Join us to make a
                                                meaningful impact on society through informed and compassionate
                                                action.</p>


                                            <h3 class="title-default-left title-bar-high">Why Study Behavioral and
                                                Social Sciences?</h3>
                                            <p>The study of behavioral and social sciences is crucial for understanding
                                                and improving the human experience. It involves the analysis of
                                                behaviors, mental processes, and societal structures, encompassing a
                                                wide range of topics from individual development to group dynamics and
                                                cultural phenomena.</p>
                                            <ul class="mb-4">
                                                <li><strong>Multidisciplinary Approach:</strong> The field combines
                                                    insights from biology, medicine, chemistry, physics, computer
                                                    science, mathematics, and philosophy, offering a broad perspective
                                                    on human behavior.
                                                </li>
                                                <li><strong>Real-World Applications:</strong> Knowledge gained in this
                                                    field has practical applications in various sectors, including
                                                    healthcare, education, business, and public policy.
                                                </li>
                                                <li><strong>Diverse Career Opportunities:</strong> Graduates can pursue
                                                    careers in research, clinical practice, counseling, human resources,
                                                    social work, and more, with opportunities to make meaningful
                                                    contributions to society.
                                                </li>
                                            </ul>
                                            <p>We are currently offering BS Psychology.</p>

                                            <h3 class="title-default-left title-bar-high">How You Are Taught?</h3>
                                            <p>Our teaching philosophy is research-led, ensuring that students are
                                                exposed to the latest developments and methodologies in the field.</p>
                                            <ul class="learning-outcomes mb-4">
                                                <li><strong>Research-Driven Curriculum:</strong> Students benefit from a
                                                    curriculum shaped by internationally-recognized researchers who
                                                    bring their expertise into the classroom.
                                                </li>
                                                <li><strong>Practical Experience:</strong> Through field surveys,
                                                    laboratory experiments, and practical classes, students apply
                                                    theoretical concepts to real-world situations.
                                                </li>
                                                <li><strong>Skill Development:</strong> The program emphasizes critical
                                                    thinking, problem-solving, and research skills, as well as enhancing
                                                    oral and written communication abilities.
                                                </li>
                                                <li><strong>Comprehensive Assessment:</strong> Students are assessed
                                                    through various methods, including exams, coursework, and project
                                                    presentations, ensuring a well-rounded evaluation of their skills.
                                                </li>
                                            </ul>

                                            <h3 class="title-default-left title-bar-high">Study Abroad and Summer
                                                Vacation Internships</h3>
                                            <p>The Department of Behavioral and Social Sciences is committed to
                                                providing students with opportunities to expand their academic and
                                                professional horizons.</p>
                                            <ul class="learning-outcomes mb-4">
                                                <li><strong>Global Exposure:</strong> We strive to help students secure
                                                    foreign scholarships and participate in study abroad programs,
                                                    gaining diverse perspectives and experiences.
                                                </li>
                                                <li><strong>Professional Internships:</strong> The department will
                                                    assist students in identifying potential NGOs and organizations
                                                    offering internships in Pakistan and abroad, enhancing their
                                                    practical experience and employability.
                                                </li>
                                                <li><strong>Support and Guidance:</strong> Our dedicated team works
                                                    diligently to connect students with the right opportunities,
                                                    ensuring they maximize their potential and gain meaningful
                                                    experiences.
                                                </li>
                                            </ul>

                                            <h3 class="title-default-left title-bar-high">Career Prospects</h3>
                                            <p>A degree in behavioral and social sciences opens doors to a wide range of
                                                career opportunities. Graduates are well-equipped to pursue roles in
                                                various fields, contributing to research, practice, and
                                                policy-making.</p>
                                            <ul class="learning-outcomes mb-4">
                                                <li><strong>High Employability:</strong> Graduates are in high demand
                                                    across various sectors, including healthcare, education, business,
                                                    and public services.
                                                </li>
                                                <li><strong>Diverse Career Paths:</strong> The skills and knowledge
                                                    acquired through our programs enable graduates to explore careers in
                                                    clinical and counseling psychology, educational psychology, social
                                                    work, human resources, and more.
                                                </li>
                                                <li><strong>Further Education:</strong> Many graduates opt to further
                                                    their education through advanced degrees, specializing in areas of
                                                    interest and contributing to research and development in their
                                                    fields.
                                                </li>
                                            </ul>

                                            <p>Join the Department of Behavioral and Social Sciences at the University
                                                of Rawalpindi to embark on a journey of academic excellence and
                                                professional success.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="sidebar-box mt-4 ">
                        <div class="sidebar-box-inner">
                            <h2 class="sidebar-title">Programs </h2>
                            <ul class="sidebar-categories">
                                <h6>
                                    <li><a href="{{ URL('/') }}/course-detail/bs-psychology">BS Psychology </a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-psychology">ADP Psychology </a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-biotechnology">ADP Biotechnology</a></li>
                                </h6>
                            </ul>
                        </div>
                    </div>

                    <div class="quick-link-pages pt-4 pb-2 px-3">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="{{url('https://admission.uor.edu.pk/')}}" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true"
                                                     style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

@endsection
