@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Art & Digital Media</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.faculties-and-departments')}}">Faculties & Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper mt-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">


                <div class="content-new-wrapper table-responsive mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content">
                                    <div class="col-lg-12 g-0">

                                    </div>
                                </div>
                                <div class="course-details-inner">
                                    <h3 class="title-default-left title-bar-high">Where Creativity Meets Innovation</h3>
                                    <p>Welcome to the Department of Art & Digital Media, a nexus of creativity and technology. Our programs encompass a wide range of disciplines, including graphic design, digital filmmaking, and interactive media. Students are encouraged to explore and experiment, guided by accomplished artists and industry experts. The department is a vibrant community where ideas are brought to life, and creative potential is realized. Whether you aspire to be an animator, a filmmaker, or a digital artist, our comprehensive curriculum and state-of-the-art facilities provide the perfect platform to launch your career.</p>

                                    <h3 class="title-default-left title-bar-high">Why Study Art & Digital Media?</h3>
                                    <p>In today's digital landscape, the intersection of art and technology is crucial for shaping visual culture and communication. Our programs offer students:</p>
                                    <ul class="mb-4">
                                        <li><strong>Creative Fusion:</strong> Explore the seamless integration of artistic expression with digital tools, fostering a deep understanding of how technology enhances and transforms visual storytelling.</li>
                                        <li><strong>Hands-On Experience:</strong> Gain practical skills in digital design, multimedia production, and interactive media, using state-of-the-art facilities and software.</li>
                                        <li><strong>Industry-Relevant Expertise:</strong> Learn from faculty who are industry professionals, bringing real-world insights and mentorship to help you develop a strong portfolio and professional network.</li>
                                    </ul>

                                    <p>Our programs include:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>BS Media and Communication Studies</li>
                                        <li>BS Digital Design and Computer Arts</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">How You Are Taught?</h3>
                                    <p>At the Department of Art & Digital Media, learning is immersive and hands-on:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li><strong>Project-Based Learning:</strong> Engage in projects that simulate real-world challenges, from concept development to execution, under the guidance of experienced mentors.</li>
                                        <li><strong>Interdisciplinary Collaboration:</strong> Collaborate with students and faculty from diverse backgrounds, enriching your creative process and expanding your perspective on art and technology.</li>
                                        <li><strong>Facilities and Resources:</strong> Access cutting-edge equipment and studios tailored for digital media production, ensuring you have the tools to bring your creative visions to life.</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">Study Abroad and Internship Opportunities</h3>
                                    <p>Broaden your horizons and gain valuable experience through our study abroad and internship programs:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li><strong>Global Exchanges:</strong> Explore international study opportunities that expose you to different cultural perspectives and artistic traditions.</li>
                                        <li><strong>Internship Placements:</strong> Connect with leading organizations and NGOs locally and globally, gaining practical experience that enhances your resume and prepares you for the competitive job market.</li>
                                    </ul>

                                    <h3 class="title-default-left title-bar-high">Career Paths</h3>
                                    <p>A degree from our department opens doors to diverse career paths in the creative industries:</p>
                                    <ul class="learning-outcomes mb-4">
                                        <li><strong>Digital Content Creation:</strong> Produce compelling multimedia content for digital platforms, ranging from social media campaigns to interactive websites.</li>
                                        <li><strong>Visual Communication:</strong> Shape brand identities and visual narratives through graphic design, animation, and visual effects.</li>
                                        <li><strong>Artistic Direction:</strong> Lead creative teams in developing innovative solutions for advertising, entertainment, and digital media production.</li>
                                    </ul>

                                    <p>Join us at the Department of Art & Digital Media to unleash your creativity, explore new technologies, and prepare for a dynamic career where art meets innovation. Experience a supportive environment that encourages experimentation and empowers you to push the boundaries of digital expression.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="content-new-wrapper table-responsive">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="sidebar-box mt-4 ">
                        <div class="sidebar-box-inner">
                            <h2 class="sidebar-title">Programs </h2>
                            <ul class="sidebar-categories">
                                <h6> <li><a href="{{ URL('/') }}/course-detail/bs-digital-design-and-computer-arts">BS Digital Design and Computer Arts</a></li>
                                 <li><a href="{{ URL('/') }}/course-detail/adp-digital-design-and-computer-arts">ADP Digital Design and Computer Arts</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/bs-media-and-communication-studies">BS Media and Communication Studies </a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-media-and-communication-studies">ADP Media and Communication Studies </a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-fine-arts">ADP Fine Arts</a></li>
                                </h6></ul>
                        </div>
                    </div>
                    <div class="quick-link-pages pt-4 pb-2 px-3">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="{{url('https://admission.uor.edu.pk/')}}" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true"
                                                     style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

@endsection
