@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Department of Applied <br>Business and Economics</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Academic <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.faculties-and-departments')}}">Faculties & Departments</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Department Detail Area Start Here -->
    <div class="container main-fac-new-wrapper mt-5">
        <div class="row fac-profile mt-3">
            <div class="col-lg-9 col-md-12 mt-2 order-lg-2 px-0">
                <div class="content-new-wrapper table-responsive mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 order-lg-2 ms-lg-1">
                                <div class="row fac-objective-content">
                                    <div class="col-lg-12 g-0">

                                    </div>
                                </div>
                                <div class="course-details-inner">
                                    <h3 class="title-default-left title-bar-high">Shaping Leaders for a Dynamic
                                        World</h3>
                                    <p>The Department of Applied Business and Economics is your gateway to understanding
                                        and mastering the complexities of the global economy. Our programs are tailored
                                        to provide a balanced mix of academic rigor and practical insights, covering
                                        critical areas such as market analysis, financial management, and economic
                                        theory. Led by a distinguished faculty with real-world experience, we foster an
                                        environment where future business leaders and economists can thrive. Embark on a
                                        journey that prepares you to tackle economic challenges with confidence and
                                        expertise.</p>

                                    <h3 class="title-default-left title-bar-high">Why Study Applied Business and Economics?</h3>
                                    <p>
                                        In today's fast-paced and interconnected world, understanding the intricacies of business and economics is essential for driving organizational success and fostering economic development. The field of applied business and economics equips students with the analytical and strategic skills necessary to make informed decisions and create value in various sectors.
                                    </p>
                                    <p>
                                        Global Relevance: Knowledge in business and economics is applicable across industries, providing graduates with a versatile and sought-after skill set.
                                    </p>
                                    <p>
                                        Strategic Insights: The study of market analysis, financial management, and economic theory enables students to understand and predict economic trends, enhancing their strategic decision-making abilities.
                                    </p>
                                    <p>
                                        Career Versatility: Graduates can pursue careers in finance, consulting, marketing, management, and more, with opportunities to work in diverse settings from multinational corporations to innovative startups.
                                    </p>
                                    <p>
                                        We are currently offering two programs: BS Accounting and Finance, and Bachelor of Business Administration (BBA).
                                    </p>
                                    <h3 class="title-default-left title-bar-high">How You Are Taught?</h3>
                                    <p>
                                        Our teaching methodology is research-led, ensuring that students benefit from the latest insights and developments in the field. The curriculum is crafted and delivered by distinguished faculty members who are experts in their respective domains.
                                    </p>
                                    <ul class="learning-outcomes mb-4">
                                        <li><strong>Innovative Curriculum: </strong>Our courses are continuously updated to incorporate the latest industry trends and technological advancements.
                                        </li>
                                        <li><strong>Practical Application:  </strong>Students engage in practical classes, case studies, and project work, applying theoretical concepts to real-world business scenarios.
                                        </li>
                                        <li><strong>Skill Development: </strong>The program hones critical thinking, problem-solving, and analytical skills, along with enhancing oral and written communication abilities.
                                        </li>
                                        <li><strong>Assessment Methods: </strong>Students are evaluated through various methods, including formal exams, coursework, and project presentations, ensuring a comprehensive assessment of their competencies.
                                        </li>
                                    </ul>
                                    <h3 class="title-default-left title-bar-high">Study Abroad and Summer Vacation Internships</h3>
                                    <p>
                                        The Department of Applied Business and Economics is committed to providing students with opportunities to broaden their academic and professional horizons.
                                    </p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>Global Opportunities: We will strive to help students secure foreign scholarships and study abroad programs, offering exposure to different cultures and business practices.
                                        </li>
                                        <li>Professional Internships: The department will assist students in identifying potential NGOs and organizations offering valuable internships in Pakistan and abroad, enhancing their practical experience and employability.
                                        </li>
                                        <li>Support and Guidance: Our dedicated team works diligently to connect students with the right opportunities, ensuring they maximize their potential and gain meaningful experiences.
                                        </li>

                                    </ul>
                                    <h3 class="title-default-left title-bar-high">Career Prospects</h3>
                                    <p>
                                        A degree from the Department of Applied Business and Economics opens doors to a wide range of career opportunities. Graduates are well-equipped to pursue roles in various fields, including finance, consulting, marketing, and management.
                                    </p>
                                    <ul class="learning-outcomes mb-4">
                                        <li>High Employability: Our graduates are in high demand, with a strong track record of securing positions in top-tier organizations.
                                        </li>
                                        <li>Diverse Career Paths: The skills and knowledge acquired through our programs enable graduates to explore careers in both the private and public sectors, as well as entrepreneurial ventures.
                                        </li>
                                        <li>Continued Education: Many graduates opt to further their education through advanced degrees, specializing in areas of interest and contributing to research and development in their fields.
                                        </li>

                                    </ul>
                                    <p>Join the Department of Applied Business and Economics at the University of Rawalpindi to embark on a journey of academic excellence and professional success.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-3 col-md-12">
                <div class="row">
                    <div class="sidebar-box mt-4 ">
                        <div class="sidebar-box-inner">
                            <h2 class="sidebar-title">Programs </h2>
                            <ul class="sidebar-categories">
                                <h6>
                                    <li><a href="{{ URL('/') }}/course-detail/bachelor-of-business-administration">Bachelor of Business Administration (BBA).</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-of-business-administration">ADP Business Administration (BBA).</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/bs-accounting-and-finance"> BS Accounting and Finance</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-accounting-and-finance"> ADP Accounting and Finance</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-e-commerce-and-digital-marketing"> ADP E-Commerce and Digital Marketing</a></li>
                                    <li><a href="{{ URL('/') }}/course-detail/adp-hospitality-and-tourism-management"> ADP Hospitality & Tourism Management</a></li>

                                </h6>
                            </ul>
                        </div>
                    </div>
                    <div class="quick-link-pages pt-4 pb-2 px-3 mt-4">
                        <div class="heading">
                            <button class="btn py-3 w-100">QUICK LINKS</button>
                        </div>
                        <div class="pages mt-5">
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us"><p>Introducing UOR</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/history-rawalpindi"><p>History of Rawalpindi</p></a>
                                </div>
                            </div>
                            <div class="d-flex my-3">
                                <div class="tab-icon">
                                    <i class="fa fa-external-link pe-2"></i>
                                </div>
                                <div class="tab-texts">
                                    <a href="{{ URL('/') }}/about-us#visionMission"><p>Vision & Mission</p></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="fac-admission-open my-5">
                        <div class="text-center pt-4">
                            <p class="p-admission mb-0 text-white">ADMISSIONS </p>
                            <p class="p-open text-white mt-2">OPEN 2025</p>
                        </div>
                        <div class="row my-5 ">
                            <div class="col-lg-12 fac-btn-apply">
                                <a href="{{url('https://admission.uor.edu.pk/')}}" target="_blank">
                                    <button class="btn btn-danger fac-btn-1 ">
                                        APPLY NOW <i class="fa fa-angle-right ms-1" aria-hidden="true"
                                                     style="font-size:1.75rem"></i>
                                    </button>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Department Detail Area End Here -->

@endsection
