@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="https://admission.giu.edu.pk/">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Under Graduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">10 Semesters, 5 years</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">180</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="2">
                                        <p class="fs-5 pt-2">Intermediate (Pre-Medical)/ Equivalent with minimum 60%
                                            marks</p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <h2 class="bg-red py-2 w-100 text-white">QUICK LINKS</h2>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities" class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3">Doctor of Physical Therapy</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Objectives</h2>
                        <ul>
                            <li>To provide pupils with a fundamental understanding of medicine.</li>
                            <li>To provide a solid foundation for patient evaluation, counselling, and rehabilitation,
                                both short and long term.
                            </li>
                            <li>To offer leadership, management, effective oral and written communication abilities, and
                                uphold high ethical and professional standards.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Role and Scope</h2>
                        <ul>
                            <li>Working as a clinical practitioner in acute care hospitals, rehabilitation facilities,
                                and non-governmental organisations.
                            </li>
                            <li>Clinical specialist for outpatients.</li>
                            <li>Hospital consultant on-site.</li>
                            <li>A geriatrician who performs extended care in older adults' homes.</li>
                            <li>Sports trauma rehabilitation specialist.</li>
                            <li>Hospice clinical practise</li>
                            <li>In special education schools, community-based rehabilitation specialists.</li>
                            <li>In fitness facilities, physical therapists and fitness instructors.</li>
                            <li>Workplace expert/ergonomist.</li>
                            <li>Working as a physical therapist in an industrial or occupational setting.</li>
                            <li>Working as a lecturer in a university environment.</li>
                            <li>Officers in research organisations who do evidence-based research.</li>
                            <li>Policymakers at the local, state, and federal levels.</li>
                        </ul>
                        <h2 class="my-3 sub-title">Semesters and Courses</h2>
                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 1</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="93">GEC-6101</td>
                                            <td width="408">Functional English</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">GEC-6102</td>
                                            <td width="408">Ideology and Constitution of Pakistan</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">GEC-6103</td>
                                            <td width="408">Quantitative Reasoning-I</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">IDAC-6201</td>
                                            <td width="408">Anatomy –I</td>
                                            <td width="102">4(3+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">IDAC-6202</td>
                                            <td width="408">Physiology-I</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">DPT-6301</td>
                                            <td width="408">Kinesiology-I</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">NCC-6401</td>
                                            <td width="408">Teaching of Holy Quran with Translation I</td>
                                            <td width="102">N.C</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 2</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="93">GEC-6104</td>
                                            <td width="408">Expository Writing</td>
                                            <td width="102">3(3+0</td>
                                        </tr>
                                        <tr>
                                            <td width="93">GEC-6105</td>
                                            <td width="408">Applications of Information and Communication Technologies
                                            </td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">GEC-6106</td>
                                            <td width="408">Islamic Studies</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">GEC-6107</td>
                                            <td width="408">Ethics</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">IDAC-6203</td>
                                            <td width="408">Anatomy –II</td>
                                            <td width="102">4(3+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">IDAC-6204</td>
                                            <td width="408">Physiology-II</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">DPT-6302</td>
                                            <td width="408">Kinesiology-II</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="93">NCC-6402</td>
                                            <td width="408">Teaching of the Holy Quran with Translation II</td>
                                            <td width="102">N.C</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 3</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">GEC-6108</td>
                                            <td width="408">Introduction to Physics</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">GEC-6109</td>
                                            <td width="408">Quantitative Reasoning-II</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">GEC-6110</td>
                                            <td width="408">Civics and Community Engagement</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">GEC-6111</td>
                                            <td width="408">Entrepreneurship</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6205</td>
                                            <td width="408">Anatomy –III</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6206</td>
                                            <td width="408">Physiology-III</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6303</td>
                                            <td width="408">Biomechanics &amp; Ergonomics-I</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">NCC-6403</td>
                                            <td width="408">Teaching of Holy Quran with Translation III</td>
                                            <td width="102">N.C</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>19</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 4</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">GEC-6112</td>
                                            <td width="408">History of South Asia</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">GEC-6113</td>
                                            <td width="408">Introduction to Psychology</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6207</td>
                                            <td width="408">Anatomy-IV (Neuro Anatomy)</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6304</td>
                                            <td width="408">Biomechanics &amp; Ergonomics-II</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6305</td>
                                            <td width="408">Exercise Physiology</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6208</td>
                                            <td width="408">Medical Physics</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6209</td>
                                            <td width="408">Molecular Biology &amp; Genetics</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">NCC-6404</td>
                                            <td width="408">Teaching of Holy Quran with Translation IV</td>
                                            <td width="102">N.C</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 5</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">IDAC-6210</td>
                                            <td width="408">Biostatistics</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6211</td>
                                            <td width="408">Pathology &amp; Microbiology I</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6212</td>
                                            <td width="408">Biochemistry I</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6213</td>
                                            <td width="408">Pharmacology &amp; Therapeutics I</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6306</td>
                                            <td width="408">Physical Agents &amp; Electrotherapy I</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6307</td>
                                            <td width="408">Therapeutic Exercises &amp; Techniques</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6308</td>
                                            <td width="408">Supervised Clinical Practice I</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 6</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">IDAC-6214</td>
                                            <td width="408">Pathology &amp; Microbiology II</td>
                                            <td width="102">2(1+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6215</td>
                                            <td width="408">Pharmacology &amp; Therapeutics II</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6309</td>
                                            <td width="408">Physical Agents &amp; Electrotherapy –II</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6216</td>
                                            <td width="408">Community Medicine &amp; Rehabilitation</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6217</td>
                                            <td width="408">Biochemistry II</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6310</td>
                                            <td width="408">Health &amp; Wellness</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6311</td>
                                            <td width="408">Supervised Clinical Practice II</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 7</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">IDAC-6218</td>
                                            <td width="408">Medicine I</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6219</td>
                                            <td width="408">Surgery I</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6220</td>
                                            <td width="408">Radiology &amp; Diagnostic Imaging</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6312</td>
                                            <td width="408">Musculoskeletal Physical Therapy</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6313</td>
                                            <td width="408">Evidence Based Practice</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6314</td>
                                            <td width="408">Supervised Clinical Practice III</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 8</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">IDAC-6221</td>
                                            <td width="408">Medicine II</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">IDAC-6222</td>
                                            <td width="408">Surgery II</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6315</td>
                                            <td width="408">Neurological Physical Therapy</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6316</td>
                                            <td width="408">Emergency Procedures &amp; Primary Care In Physical
                                                Therapy
                                            </td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6317</td>
                                            <td width="408">Supervised Clinical Practice IV</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6318</td>
                                            <td width="408">Scientific Inquiry &amp; Research Methodology</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 9</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">DPT-6319</td>
                                            <td width="408">Cardiopulmonary Physical Therapy</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6320</td>
                                            <td width="408">Prosthetics &amp; Orthotics</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6321</td>
                                            <td width="408">Clinical Decision Making &amp; Differential Diagnosis</td>
                                            <td width="102">3(3+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6322</td>
                                            <td width="408">Manual Therapy</td>
                                            <td width="102">3(2+1)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6323</td>
                                            <td width="408">Professional Practice (Laws , Ethics &amp;Administration)
                                            </td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6324</td>
                                            <td width="408">Integumentary Physical Therapy</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6325</td>
                                            <td width="408">Supervised Clinical Practice V</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>18</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="semester-detail">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="toper-text">
                                        <h2>Semester 10</h2>
                                    </div>

                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th class="text-center min-width">Course Code</th>
                                            <th class="width  border-left">Course Title</th>
                                            <th class="width text-center border-left ">Credit Hours</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td width="90">DPT-6326</td>
                                            <td width="408">Obstetrics &amp; Gynecological Physical Therapy</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6327</td>
                                            <td width="408">Pediatrics Physical Therapy</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6328</td>
                                            <td width="408">Gerontology &amp; Geriatric Physical Therapy</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6329</td>
                                            <td width="408">Sports Physical Therapy</td>
                                            <td width="102">2(2+0)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">DPT-6330</td>
                                            <td width="408">Supervised Clinical Practice VI</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">CPC-6601</td>
                                            <td width="408">Capstone Project</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="90">ISC-6501</td>
                                            <td width="408">Field Experience/ Internship</td>
                                            <td width="102">3(0+3)</td>
                                        </tr>
                                        <tr>
                                            <td width="130">&nbsp;</td>
                                            <td width="453"><strong>Total Credit Hours</strong></td>
                                            <td width="102"><strong>17</strong></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <p><b>Total Credit Hours Doctor of Physical Therapy(DPT) are 180 </b></p>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('footer-scripts')

@endpush
