@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">8 Semesters, (4 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">133</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate with minimum 45% marks or equivalent</p>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3">BS Media and Communication Studies</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>The Bachelor of Science (BS) in Media and Communication curriculum at the University of
                            Rawalpindi has been thoroughly designed to provide a thorough understanding of the media
                            landscape and communication techniques. The goal of this program is to give students the
                            theoretical understanding and hands-on training they need to succeed in the fast-paced media
                            and communication industries. The curriculum includes specific subjects like journalism,
                            media production, and public relations in addition to covering the fundamentals of media
                            studies, communication theory, and digital media. Our objective is to produce competent
                            media workers who can succeed in a variety of capacities both inside and beyond the media
                            sector.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Explore journalism, media production, digital marketing, and public relations, ensuring
                                a well-rounded media education that prepares you for various roles in the media
                                industry.
                            </li>
                            <li>Utilize the university's media labs and studios to create professional-grade content,
                                gaining hands-on experience that enhances your technical skills and creative
                                capabilities.
                            </li>
                            <li>Network with media professionals and alumni, providing valuable connections and insights
                                that can lead to internships and job opportunities.
                            </li>
                            <li>Engage in cutting-edge media projects, including digital storytelling and multimedia
                                production, fostering creativity and practical expertise.
                            </li>
                            <li>Study the impact of media on society, culture, and politics, preparing you for a career
                                in an interconnected world where media plays a crucial role in shaping public opinion
                                and cultural narratives.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Journalism: Reporters, editors, news anchors
                            </li>
                            <li>Media Production: Producers, directors, video editors
                            </li>
                            <li>Public Relations: PR specialists, corporate communications managers
                            </li>
                            <li>Advertising: Advertising executives, copywriters
                            </li>
                            <li>Digital Media: Social media managers, content strategists
                            </li>
                            <li>Film and Television: Scriptwriters, film critics
                            </li>
                            <li>Marketing: Marketing managers, brand strategists
                            </li>
                            <li>Communication Research: Media analysts, communication consultants
                            </li>
                        </ul>

                        <div class="semester-detail table-responsive">
                            <h2 class="my-3 sub-title">Semesters and Courses</h2>
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-104</td>
                                                <td width="372">Ideology and Constitution of Pakistan</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-107</td>
                                                <td width="372">Functional English</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-102</td>
                                                <td width="372">Applications of Information & Communication Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MATH-105</td>
                                                <td width="372">Basic Mathematics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-121</td>
                                                <td width="372">Introduction to Mass Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-122</td>
                                                <td width="372">Introduction to Digital Media</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ISL-101</td>
                                                <td width="372">Islamic Studies</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-108</td>
                                                <td width="372">Expository Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-124</td>
                                                <td width="372">Mass Media and Society</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-125</td>
                                                <td width="372">Mass Media in Pakistan</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-130</td>
                                                <td width="372">Contemporary World Media</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">PSY-112</td>
                                                <td width="372">Introduction to Psychology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ENG-201</td>
                                                <td width="372">Technical Report Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-203</td>
                                                <td width="372">Community Service Learning</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">STAT-301</td>
                                                <td width="372">Statistics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-129</td>
                                                <td width="372">Introduction to Political Science</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-131</td>
                                                <td width="372">Introduction to Broadcast Media</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-213</td>
                                                <td width="372">Human Resource Management</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">MC-144</td>
                                                <td width="372">Introduction to Advertising and Public Relations</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-138</td>
                                                <td width="372">Introduction to Film & Theatre</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-141</td>
                                                <td width="372">Media Ethics and Laws</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-154</td>
                                                <td width="372">Current Affairs</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-315</td>
                                                <td width="372">Management Information Systems</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-205</td>
                                                <td width="372">Entrepreneurship</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 5</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-310</td>
                                                <td width="372">Research Methodology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-201</td>
                                                <td width="372">Theories of Mass Communication-I</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-188</td>
                                                <td width="372">Digital Media Literacy</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-169</td>
                                                <td width="372">Development Support Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-147</td>
                                                <td width="372">International Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>


                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 6</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-106</td>
                                                <td width="372">Logical & Critical Thinking</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ELL-418</td>
                                                <td width="372">Corpus Linguistics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ELL-415</td>
                                                <td width="372">Language Testing and Assessment</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ELL-411</td>
                                                <td width="372">Literary Theory and Practice</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ARAB-101</td>
                                                <td width="372">Arabic Language - I</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 7</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">MC-199</td>
                                                <td width="372">Online Journalism</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-234</td>
                                                <td width="372">Media Management</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-198</td>
                                                <td width="372">Photo Journalism</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-205</td>
                                                <td width="372">Development Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-241</td>
                                                <td width="372">Electronic News Gathering</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 8</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-304</td>
                                                <td width="372">Professional Practices</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-416</td>
                                                <td width="372">Media Seminar</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-428</td>
                                                <td width="372">Digital Media Analytics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MC-419</td>
                                                <td width="372">Media Regulations</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-401</td>
                                                <td width="372">Final Year Project/ Dissertation</td>
                                                <td width="133">6</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Admission Area End Here -->
@endsection
