@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">8 Semesters, (4 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">133</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate or equivalent with a minimum of 45% marks</p>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3">BS English and Linguistic Studies</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>The University of Rawalpindi's Bachelor of Science (BS) in English Literature and Linguistics
                            curriculum is carefully structured to offer a comprehensive grasp of the literary and
                            linguistic facets of the English language. The goal of this curriculum is to give students a
                            strong foundation in literature and language structures as well as analytical and critical
                            thinking abilities. Along with more specific subjects like sociolinguistics,
                            psycholinguistics, and global literature, the curriculum covers the fundamentals of literary
                            analysis, linguistic theory, and critical theory. Our goal is to produce well-rounded
                            academics with professional, cultural, and scholarly contributions.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Gain a profound understanding of both literary analysis and linguistic theory,
                                encompassing classic and contemporary literature, fostering a versatile appreciation of
                                language and storytelling.
                            </li>
                            <li>Learn from distinguished professors who are not only scholars but also active
                                contributors to the fields of literature and linguistics, providing a rich academic
                                environment.
                            </li>
                            <li>Engage in in-depth research projects and literary critiques, enhancing your analytical
                                skills and academic portfolio, and preparing you for advanced studies or professional
                                writing careers.
                            </li>
                            <li>Participate in literary festivals, workshops, and seminars hosted by the university,
                                creating a vibrant intellectual community that encourages creative expression and
                                critical discourse.
                            </li>
                            <li>Equip yourself for diverse career paths in education, publishing, media, and beyond,
                                with strong communication, critical thinking, and cultural literacy skills that are
                                highly valued in various industries.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Education: Teachers, lecturers, curriculum developers
                            </li>
                            <li>Publishing: Editors, proofreaders, literary agents
                            </li>
                            <li>Media: Journalists, content writers, scriptwriters
                            </li>
                            <li>Research: Linguistic researchers, literary analysts
                            </li>
                            <li>Translation: Translators, interpreters
                            </li>
                            <li>Cultural Organizations: Cultural program coordinators, museum curators
                            </li>
                            <li>Public Relations: PR specialists, corporate communications managers
                            </li>
                            <li>Advertising: Copywriters, brand strategists
                            </li>
                        </ul>

                        <div class="semester-detail table-responsive">
                            <h2 class="my-3 sub-title">Semesters and Courses</h2>
                            <div class="semester-detail table-responsive">
                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 1</h2>
                                            </div>

                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">GEN-104</td>
                                                    <td width="372">Ideology and Constitution of Pakistan</td>
                                                    <td width="133">2</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ENG-107</td>
                                                    <td width="372">Functional English</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">CS-102</td>
                                                    <td width="372">Applications of Information & Communication Technologies</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-112</td>
                                                    <td width="372">Introduction to Literature</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-113</td>
                                                    <td width="372">Introduction to Linguistics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-118</td>
                                                    <td width="372">Study Skills</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>17</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>

                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 2</h2>
                                            </div>

                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">ISL-101</td>
                                                    <td width="372">Islamic Studies</td>
                                                    <td width="133">2</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ENG-108</td>
                                                    <td width="372">Expository Writing</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-114</td>
                                                    <td width="372">Advanced English Grammar</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-116</td>
                                                    <td width="372">Phonetics and Phonology</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-117</td>
                                                    <td width="372">History of English Literature</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">PSY-112</td>
                                                    <td width="372">Introduction to Psychology</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>17</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>


                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 3</h2>
                                            </div>

                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">ENG-201</td>
                                                    <td width="372">Technical Report Writing</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">GEN-203</td>
                                                    <td width="372">Community Service Learning</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">STAT-301</td>
                                                    <td width="372">Statistics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-212</td>
                                                    <td width="372">Classical and Renaissance Drama</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-213</td>
                                                    <td width="372">Classical Poetry</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">MGT-213</td>
                                                    <td width="372">Human Resource Management</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>18</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>

                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 4</h2>
                                            </div>

                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">ELL-214</td>
                                                    <td width="372">Semantics and Pragmatics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-218</td>
                                                    <td width="372">Rise of the Novel - 18th to 19th Century</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-319</td>
                                                    <td width="372">Modern Drama</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-215</td>
                                                    <td width="372">Psycholinguistics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">MGT-315</td>
                                                    <td width="372">Management Information Systems</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">GEN-205</td>
                                                    <td width="372">Entrepreneurship</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>18</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>


                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 5</h2>
                                            </div>
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">GEN-310</td>
                                                    <td width="372">Research Methodology</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-217</td>
                                                    <td width="372">English Language Teaching</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-313</td>
                                                    <td width="372">Romantic and Victorian Poetry</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-318</td>
                                                    <td width="372">Modern Novel</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">MC-147</td>
                                                    <td width="372">International Communication</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>15</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>


                                        </div>
                                    </div>
                                </div>
                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 6</h2>
                                            </div>
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">GEN-106</td>
                                                    <td width="372">Logical & Critical Thinking</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-418</td>
                                                    <td width="372">Corpus Linguistics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-415</td>
                                                    <td width="372">Language Testing and Assessment</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-411</td>
                                                    <td width="372">Literary Theory and Practice</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ARAB-101</td>
                                                    <td width="372">Arabic Language - I</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>15</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>
                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 7</h2>
                                            </div>
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">ELL-317</td>
                                                    <td width="372">Modern Poetry</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-417</td>
                                                    <td width="372">World Literature</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-412</td>
                                                    <td width="372">Prose</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-413</td>
                                                    <td width="372">Stylistics</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-316</td>
                                                    <td width="372">Critical Discourse Analysis</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>15</strong></td>
                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>

                                <div class="semester-detail">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="toper-text">
                                                <h2>Semester 8</h2>
                                            </div>
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th class="text-center min-width">Course Code</th>
                                                    <th class="width border-left">Course Title</th>
                                                    <th class="width text-center border-left">Credit Hours</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td width="133">GEN-304</td>
                                                    <td width="372">Professional Practices</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-414</td>
                                                    <td width="372">Postcolonial Studies</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-416</td>
                                                    <td width="372">Literary Criticism</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">ELL-312</td>
                                                    <td width="372">World Englishes</td>
                                                    <td width="133">3</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">GEN-401</td>
                                                    <td width="372">Final Year Project/ Dissertation</td>
                                                    <td width="133">6</td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Credit Hours:</strong></td>
                                                    <td width="133"><strong>18</strong></td>
                                                </tr>
                                                <tr>
                                                    <td width="133">&nbsp;</td>
                                                    <td width="372"><strong>Total Credit Hours:</strong></td>
                                                    <td width="133"><strong>133</strong></td>

                                                </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

    <!-- Admission Area End Here -->
@endsection
