@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">8 Semesters, (4 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">133</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate or equivalent with a minimum of 45% marks</p>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3">BS  Digital Design and Computer Arts</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>A thorough examination of digital media, graphic design, and computer-aided design (CAD) is
                            provided by the carefully crafted Bachelor of Science (BS) in Digital Design and Computer
                            Arts program at the University of Rawalpindi. The goal of this program is to give students
                            the practical knowledge and abilities necessary for success in the rapidly changing fields
                            of computer graphics and digital design. The program covers specialist topics including user
                            experience (UX) design and game design in addition to diving deeply into fundamental ideas
                            of visual communication, digital imagery, 3D modeling, animation, and interactive design.
                            Our goal is to produce creative and technically proficient designers who can lead innovation
                            and succeed in a variety of fields.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Explore digital media, graphic design, 3D modeling, animation, and interactive design,
                                fostering both creativity and technical skills that are essential in the digital design
                                industry.
                            </li>
                            <li>Access advanced software and tools used in the industry, ensuring you stay ahead in the
                                rapidly evolving field of digital design.
                            </li>
                            <li>Build a professional portfolio through diverse projects and assignments, showcasing your
                                design talents and technical proficiency to potential employers.
                            </li>
                            <li>Learn from instructors with industry experience and connections, keeping you informed
                                about the latest trends, practices, and technological advancements in digital design.
                            </li>
                            <li>Prepare for diverse roles in graphic design, web development, animation, game design,
                                and more, equipping you with the skills needed to adapt to various career paths in the
                                digital and creative industries.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Graphic Design: Graphic designers, creative directors
                            </li>
                            <li>Web Design and Development: Web designers, front-end developers
                            </li>
                            <li>Animation and Motion Graphics: Animators, visual effects (VFX) artists
                            </li>
                            <li>User Experience (UX) Design: UX designers, usability specialists
                            </li>
                            <li>Game Design: Game designers, level designers
                            </li>
                            <li>Digital Marketing: Digital marketers, content strategists
                            </li>
                            <li>Advertising: Art directors, advertising designers
                            </li>
                            <li>Multimedia Production: Multimedia artists, multimedia developers
                            </li>
                        </ul>

                        <div class="semester-detail table-responsive">
                            <h2 class="my-3 sub-title">Semesters and Courses</h2>
{{--                            <div class="semester-detail">--}}
{{--                                <div class="row">--}}
{{--                                    <div class="col-md-12">--}}
{{--                                        <table class="table">--}}
{{--                                            <thead>--}}
{{--                                            <tr>--}}
{{--                                                <th class="text-center min-width">Courses:</th>--}}
{{--                                                <th class="text-center min-width">Projects/Thesis</th>--}}
{{--                                                <th class="text-center min-width">Internship</th>--}}
{{--                                                <th class="text-center min-width">Total</th>--}}
{{--                                            </tr>--}}
{{--                                            </thead>--}}
{{--                                            <tbody>--}}
{{--                                            <tr>--}}
{{--                                                <td class="text-center min-width">126 Credits</td>--}}
{{--                                                <td class="text-center min-width">09 Credits</td>--}}
{{--                                                <td class="text-center min-width">Non-Credit</td>--}}
{{--                                                <td class="text-center min-width">135 Credits</td>--}}
{{--                                            </tr>--}}
{{--                                            </tbody>--}}
{{--                                        </table>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-104</td>
                                                <td width="372">Ideology and Constitution of Pakistan</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-107</td>
                                                <td width="372">Functional English</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-102</td>
                                                <td width="372">Applications of Information & Communication Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-410</td>
                                                <td width="372">History of Art in Ancient Civilizations</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-400</td>
                                                <td width="372">Basic Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-420</td>
                                                <td width="372">Basic Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ISL-101</td>
                                                <td width="372">Islamic Studies</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-108</td>
                                                <td width="372">Expository Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 411</td>
                                                <td width="372">History of Western Arts</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 402</td>
                                                <td width="372">Still Life Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 412</td>
                                                <td width="372">History of Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">PSY-112</td>
                                                <td width="372">Introduction to Psychology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ENG-201</td>
                                                <td width="372">Technical Report Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">STAT-301</td>
                                                <td width="372">Statistics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 403</td>
                                                <td width="372">Landscape Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 421</td>
                                                <td width="372">Graphic Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 440</td>
                                                <td width="372">Drafting</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-203</td>
                                                <td width="372">Community Service Learning</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CA 404</td>
                                                <td width="372">Portrait Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 470</td>
                                                <td width="372">Fundamentals of Photography</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 423</td>
                                                <td width="372">Computer Graphics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 430</td>
                                                <td width="372">Basic Animation</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-315</td>
                                                <td width="372">Management Information Systems</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-205</td>
                                                <td width="372">Entrepreneurship</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 5</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-310</td>
                                                <td width="372">Research Methodology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 405</td>
                                                <td width="372">Anatomy Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 442</td>
                                                <td width="372">Idea Development and Script Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 471</td>
                                                <td width="372">Digital Photography</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 424</td>
                                                <td width="372">Communication Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 6</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-106</td>
                                                <td width="372">Logical & Critical Thinking</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 406</td>
                                                <td width="372">Figure Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ID-315</td>
                                                <td width="372">Advanced Digital Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 450</td>
                                                <td width="372">Basic Video Production</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ARAB-101</td>
                                                <td width="372">Arabic Language - I</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>


                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 7</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CA 460</td>
                                                <td width="372">Introduction to Web Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 452</td>
                                                <td width="372">Scenography</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 457</td>
                                                <td width="372">Documentary Production</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 425</td>
                                                <td width="372">Illustration</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 431</td>
                                                <td width="372">Introduction to 3D Modeling</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 8</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CA 413</td>
                                                <td width="372">Art Appreciation</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 434</td>
                                                <td width="372">Character Design and Animation</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 456</td>
                                                <td width="372">TV & Film Direction</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA 453</td>
                                                <td width="372">Digital Audio Tools</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-401</td>
                                                <td width="372">Final Year Project/ Dissertation</td>
                                                <td width="133">6</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Total Credit Hours:</strong></td>
                                                <td width="133"><strong>133</strong></td>

                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text bg-">
                                            <h2>Specialization on Graphics </h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th>Course Code</th>
                                                <th class="width text-center border-left">Course Title</th>
                                                <th class="text-center border-left">Credit Hours</th>
                                                <th class="text-center border-left">Lecture Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>CA 426</td>
                                                <td>Typography</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 427</td>
                                                <td>Campaign Development</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 428</td>
                                                <td>Creative Advertising</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 462</td>
                                                <td>User interface Design</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 463</td>
                                                <td>Desktop Publishing</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <p>&nbsp;</p>
                                        <div class="toper-text">
                                            <h2>Specialization: Animation</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th>Course Code</th>
                                                <th class="width text-center border-left">Course Title</th>
                                                <th class="text-center border-left">Credit Hours</th>
                                                <th class="text-center border-left">Lecture Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>CA 431</td>
                                                <td>Introduction to 3dmodeling</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 432</td>
                                                <td>Stop motion Animation</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 433</td>
                                                <td>Texturing and lighting techniques in 3d</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 434</td>
                                                <td>Character Design and Animation</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 435</td>
                                                <td>Animation and production techniques in 3d</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <p>&nbsp;</p>
                                        <div class="toper-text">
                                            <h2>Specialization: Video Production</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th>Course Code</th>
                                                <th class="width text-center border-left">Course Title</th>
                                                <th class="text-center border-left">Credit Hours</th>
                                                <th class="text-center border-left">Lecture Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>CA 454</td>
                                                <td>Light & camera techniques in video production</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 455</td>
                                                <td>Post production effects</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 456</td>
                                                <td>TV & Film Direction</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 457</td>
                                                <td>Documentary production</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 458</td>
                                                <td>Drama and Theatre</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            <tr>
                                                <td>CA 453</td>
                                                <td>Digital Audio tools</td>
                                                <td class="text-center">3</td>
                                                <td class="text-center">3</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Admission Area End Here -->
@endsection
