@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">8 Semesters, 4 years</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">133</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <ul class="mx-4 text-start">
                                            <li>Intermediate or equivalent level with Mathematics at least 50% marks.
                                            </li>
                                            <li>Candidates with a three-year associate diploma in
                                                Electrical/Electronics/IT/Computer hardware/Telecom engineering from any
                                                institute recognized by PBTE (Punjab Board of Technical Education).
                                            </li>
                                            <li>The students who have not studied Mathematics at intermediate level have
                                                to
                                                pass deficiency course of Mathematics (06 credits) in first two
                                                semesters.
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">
                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->
                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3"> BS Computer Science</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>The University of Rawalpindi offers a comprehensive curriculum for its Computer Science
                            program that builds a solid foundation in both theoretical and applied computer science.
                            Students who complete the course of study will be prepared to succeed in a wide range of
                            technologically advanced fields. Basic computer ideas, programming, data structures,
                            algorithms, and more advanced topics like Cybersecurity, Software Engineering, Artificial
                            Intelligence (AI), and Machine Learning (ML) are all covered. Our mission is to generate
                            flexible computer scientists capable of leading and innovating in the rapidly evolving
                            Information and Communications Technology (ICT) sector.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Cover core areas of computer science, including programming, algorithms, data
                                structures, artificial intelligence, and cybersecurity, providing a solid foundation in
                                computing.
                            </li>
                            <li>Work on projects and internships that provide practical experience in software
                                development, IT solutions, and real-world applications of computer science.
                            </li>
                            <li>Engage in cutting-edge research projects and stay updated with the latest advancements
                                in technology, fostering a culture of innovation and discovery.
                            </li>
                            <li>Network with industry leaders, opening doors to job opportunities, mentorship, and
                                career advancement in the tech industry.
                            </li>
                            <li>Gain valuable skills in problem-solving, analytical thinking, and technical expertise,
                                making you highly competitive in the job market and prepared for various roles in the
                                tech industry.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Software Development: Software engineers, application developers.
                            </li>
                            <li>Data Science: Data analysts, data scientists.
                            </li>
                            <li>Cybersecurity: Security analysts, penetration testers.
                            </li>
                            <li>Network Administration: Network administrators, systems administrators.
                            </li>
                            <li>Research and Development: Research scientists, IT researchers.
                            </li>
                        </ul>

                        <h2 class="my-3 sub-title">Semesters and Courses</h2>
                        <div class="semester-detail table-responsive">
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width  border-left">Course Title</th>
                                                <th class="width text-center border-left ">Credit Hours</th>
{{--                                                <th class="width text-center border-left ">Category</th>--}}
{{--                                                <th class="width text-center border-left ">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="93">GEN-104</td>
                                                <td width="408">Ideology and Constitution of Pakistan</td>
                                                <td width="102">2</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="93">ISL-103</td>--}}
{{--                                                <td width="408">Teaching of Holy Quran I</td>--}}
{{--                                                <td width="102">Non-Credit</td>--}}
{{--                                                <td width="150">Compulsory</td>--}}
{{--                                                <td width="150">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="93">ENG-107</td>
                                                <td width="408">Functional English</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">CS-102</td>
                                                <td width="408">Application of Information and Communication
                                                    Technologies
                                                </td>
                                                <td width="102">3</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">CS-111</td>
                                                <td width="408">Programming Fundamentals</td>
                                                <td width="102">4</td>
{{--                                                <td width="150">Computing Core</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">PHY-103</td>
                                                <td width="408">Applied Physics</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="93">MATH-105</td>--}}
{{--                                                <td width="408">Basic Math-I (Deficiency Subject for Pre-Medical--}}
{{--                                                    Students)--}}
{{--                                                </td>--}}
{{--                                                <td width="102">3(3-0)</td>--}}
{{--                                                <td width="150">Compulsory for Pre-Med</td>--}}
{{--                                                <td width="150">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="130">&nbsp;</td>
                                                <td width="453"><strong>Credit Hours</strong></td>
                                                <td width="102"><strong> 15 </strong></td>
{{--                                                <td colspan="2">&nbsp;</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width  border-left">Course Title</th>
                                                <th class="width text-center border-left ">Credit Hours</th>
{{--                                                <th class="width text-center border-left ">Category</th>--}}
{{--                                                <th class="width text-center border-left ">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="93">ISL-101</td>
                                                <td width="408">Islamic Studies</td>
                                                <td width="102">2</td>
{{--                                                <td rowspan="2" width="150">General Education</td>--}}
{{--                                                <td rowspan="2" width="150">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="93">ETH-100</td>--}}
{{--                                                <td width="408">Ethics</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="93">ENG-108</td>
                                                <td width="408">Expository Writing</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">MATH-214</td>
                                                <td width="408">Linear Algebra</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">Compulsory</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">CS-204</td>
                                                <td width="408">Digital Logic Design</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">Computing Core</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">CS-112</td>
                                                <td width="408">Object Oriented Programming</td>
                                                <td width="102">4</td>
{{--                                                <td width="150">Computing Core</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="93">MATH-104</td>
                                                <td width="408">Calculus and Analytical Geometry</td>
                                                <td width="102">3</td>
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="93">GEN-304</td>--}}
{{--                                                <td width="408">Professional Practices</td>--}}
{{--                                                <td width="102">2(2-0)</td>--}}
{{--                                                <td width="150">General Education</td>--}}
{{--                                                <td width="150">-</td>--}}
{{--                                            </tr>--}}
{{--                                            <tr>--}}
{{--                                                <td width="93">MATH-106</td>--}}
{{--                                                <td width="408">Basic Math-II (Deficiency Subject for Pre-Medical--}}
{{--                                                    Students)--}}
{{--                                                </td>--}}
{{--                                                <td width="102">3(3-0)</td>--}}
{{--                                                <td width="150">Compulsory for Pre-Med</td>--}}
{{--                                                <td width="150">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="130">&nbsp;</td>
                                                <td width="453"><strong>Credit Hours</strong></td>
                                                <td width="102"><strong>18 </strong></td>
                                                <td colspan="2">&nbsp;</td>
                                            </tr>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="129">CS-202</td>
                                                <td width="406">Discrete Structures</td>
                                                <td width="120">3</td>
{{--                                                <td width="120">Compulsory</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-404</td>
                                                <td width="406">Information Security</td>
                                                <td width="120">3</td>
{{--                                                <td width="120">Math and Supporting</td>--}}
{{--                                                <td width="120">ENG-102</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-216</td>
                                                <td width="406">Data Structures</td>
                                                <td width="120">4</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-308</td>
                                                <td width="406">Artificial Intelligence</td>
                                                <td width="120">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-112</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">IT-326</td>
                                                <td width="406">Web Technologies</td>
                                                <td width="120">3</td>
{{--                                                <td width="120">General Education</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">GEN-203</td>
                                                <td width="406">Community Service Learning</td>
                                                <td width="120">3</td>
{{--                                                <td width="120">General Education</td>--}}
{{--                                                <td width="120">&nbsp;</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="129">CS-317</td>--}}
{{--                                                <td width="406">Theory of Automata</td>--}}
{{--                                                <td width="120">3(3-0)</td>--}}
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td>&nbsp;</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>19</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>


                            <div class="semester-detail ">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="129">CS-302</td>
                                                <td width="395">Computer Organization and Assembly Language</td>
                                                <td width="133">4</td>
{{--                                                <td width="120">Math and Supporting</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-213</td>
                                                <td width="395">Database Systems</td>
                                                <td width="133">4</td>
{{--                                                <td width="120">General Education</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-113</td>
                                                <td width="395">Software Engineering</td>
                                                <td width="133">3</td>
{{--                                                <td width="120">General Education</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-307</td>
                                                <td width="395">Computer Networks</td>
                                                <td width="133">3</td>
{{--                                                <td width="120">Compulsory</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">CS-319</td>
                                                <td width="395">Mobile Applications & Development</td>
                                                <td width="133">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-216</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="129">GEN-205</td>
                                                <td width="395">Entrepreneurship</td>
                                                <td width="133">3</td>
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="129">CS-221</td>--}}
{{--                                                <td width="395">Operating Systems</td>--}}
{{--                                                <td width="133">3(2-1)</td>--}}
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-216</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>20</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 5</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="131">CS-321</td>
                                                <td width="390">HCI and Compuer Graphics</td>
                                                <td width="131">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-111</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="131">CS-303</td>
                                                <td width="390">Object Oriented Analysis and Design</td>
                                                <td width="131">4</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-216</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="131">CS-211</td>
                                                <td width="390">Visual Programming</td>
                                                <td width="131">3</td>
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td width="120">MATH-104</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="131">ENG-201</td>
                                                <td width="390">Technical Report Writing</td>
                                                <td width="131">3</td>
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="131">STAT-311</td>
                                                <td width="390">Probability and Statistics</td>
                                                <td width="131">3</td>
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="131">CS-303</td>--}}
{{--                                                <td width="390">Object Oriented Analysis and Design</td>--}}
{{--                                                <td width="131">3(2-1)</td>--}}
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>16</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 6</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="125">CS-317</td>
                                                <td width="399">Theory of Automata</td>
                                                <td width="134">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="125">CS-305</td>
                                                <td width="399">Computer Architecture</td>
                                                <td width="134">3</td>
{{--                                                <td width="120">Math and Supporting</td>--}}
{{--                                                <td width="120">MATH-104</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="125">CS-221</td>
                                                <td width="399">Operating Systems</td>
                                                <td width="134">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-112</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="125">CS-301</td>
                                                <td width="399">Analysis of Algorithms</td>
                                                <td width="134">3</td>
{{--                                                <td width="120">Math and Supporting</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="125">PSY-112</td>
                                                <td width="399">Probability and Statistics</td>
                                                <td width="134">3</td>
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td width="120">CS-311</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="125">CS-306</td>--}}
{{--                                                <td width="399">Software Testing and Quality Assurance</td>--}}
{{--                                                <td width="134">3(2-1)</td>--}}
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td colspan="5" width="133">Summer</td>--}}
{{--                                            </tr>--}}
{{--                                            <tr>--}}
{{--                                                <td width="133">GEN-401</td>--}}
{{--                                                <td width="372">Internship</td>--}}
{{--                                                <td width="133">3(0-3)</td>--}}
{{--                                                <td colspan="2">Compulsory</td>--}}
{{--                                            </tr>--}}
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>


                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 7</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="121">CS-405</td>
                                                <td width="403">Compiler Construction</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td width="120">CS-317</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="121">CS-401</td>
                                                <td width="403">Cloud Computing</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="121">SE-402</td>
                                                <td width="403">Software Project Management</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="121">GEN-310</td>
                                                <td width="403">Research Methodology</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">CS-112</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="121">CS-425</td>
                                                <td width="403">Final Year Project - I</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Elective Supporting</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
{{--                                            <tr>--}}
{{--                                                <td width="121">CS-425</td>--}}
{{--                                                <td width="403">Final Year Project(Phase –I)</td>--}}
{{--                                                <td width="132">2(0-2)</td>--}}
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">-</td>--}}
{{--                                            </tr>--}}
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>


                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 8</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
{{--                                                <th class="width border-left">Category</th>--}}
{{--                                                <th class="width border-left">Pre-Requisite</th>--}}
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="117">CS-402</td>
                                                <td width="406">Cyber Security</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Domain Elective</td>--}}
{{--                                                <td width="120">CS-307</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="117">CS-403</td>
                                                <td width="406">Parallel and Distributed Computing</td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Domain Core</td>--}}
{{--                                                <td width="120">CS-221</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="117">GEN-304</td>
                                                <td width="406">Professional Practices</td>
                                                <td width="132">3</td>
                                            </tr>
                                            <tr>
                                                <td width="117">CS-320</td>
                                                <td width="406">Advanced Database Management System</td>
                                                <td width="132">3</td>
                                            </tr>
                                            <tr>
                                                <td width="117">CS-427</td>
                                                <td width="406">Final Year Project–II </td>
                                                <td width="132">3</td>
{{--                                                <td width="120">Computing Core</td>--}}
{{--                                                <td width="120">CS-415</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Total Credit Hours:</strong></td>
                                                <td width="133"><strong>133</strong></td>
{{--                                                <td width="120">-</td>--}}
{{--                                                <td width="120">-</td>--}}
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- Admission Area End Here -->

@endsection
