@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">8 Semesters, (4 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">133</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate or equivalent with a minimum 45%
                                            marks.</p>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3"> BS Accounting and Finance</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>A strong foundation in the fundamentals of contemporary accounting and finance is provided by
                            the University of Rawalpindi's Bachelor of Science (BS) in Accounting and Finance program.
                            This program ensures that students are well-prepared for the ever-changing financial sector
                            by fusing academic knowledge with practical abilities. Along with more complex subjects like
                            corporate finance, investment analysis, and financial reporting, the program covers the
                            fundamentals of accounting, financial management, auditing, and taxation. This program seeks
                            to create competent professionals who can navigate and thrive in a variety of financial
                            contexts. It is designed to give students the tools they need to excel in a variety of
                            financial industries.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Dive into a broad range of topics, including financial and management accounting,
                                auditing, taxation, and financial management, giving you a solid foundation in both
                                fields.
                            </li>
                            <li>Gain real-world experience through internships and practical assignments, working with
                                financial statements, tax planning, and investment analysis to build your professional
                                portfolio.
                            </li>
                            <li>Learn from experienced professionals and academics who bring practical insights and
                                industry knowledge into the classroom, ensuring a high-quality, relevant education.
                            </li>
                            <li>Prepare for certifications like ACCA, CFA, and CPA with a curriculum designed to meet
                                professional standards, enhancing your career prospects.
                            </li>
                            <li>Understand global financial markets and international accounting standards, preparing
                                you for a career in the global finance industry with the skills needed to succeed
                                worldwide.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Professional Accountancy: Auditors, tax advisors, financial accountants
                            </li>
                            <li>Investment Banking: Financial analysts, mergers and acquisitions advisors
                            </li>
                            <li>Investment Analysis and Management: Portfolio managers, investment advisors
                            </li>
                            <li>Management Consultancy: Business consultants, financial strategists
                            </li>
                            <li>Financial Management: Corporate finance managers, financial controllers
                            </li>
                        </ul>
{{--                        <div class="semester-detail  table-responsive">--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <table class="table table-bordered">--}}
{{--                                        <thead>--}}
{{--                                        <tr>--}}
{{--                                            <th class="text-center min-width">Program Title</th>--}}
{{--                                            <th class="width  border-left">Number of semesters</th>--}}
{{--                                            <th class="width text-center border-left ">Course category</th>--}}
{{--                                            <th class="width text-center border-left ">Number of courses</th>--}}
{{--                                            <th class="width text-center border-left ">Credit hours</th>--}}
{{--                                            <th class="width text-center border-left ">Internship requirement</th>--}}
{{--                                            <th class="width text-center border-left ">Final year project/report/ viva--}}
{{--                                            </th>--}}
{{--                                        </tr>--}}
{{--                                        </thead>--}}
{{--                                        <tbody>--}}
{{--                                        <tr>--}}
{{--                                            <td rowspan="6" width="133">BS Accounting and Finance (BSAF)</td>--}}
{{--                                            <td rowspan="6" width="372">8</td>--}}
{{--                                            <td width="133">Major</td>--}}
{{--                                            <td width="133">23</td>--}}
{{--                                            <td width="133">69</td>--}}
{{--                                            <td rowspan="6" width="133">Yes</td>--}}
{{--                                            <td rowspan="6" width="133">Yes</td>--}}
{{--                                        </tr>--}}
{{--                                        <tr>--}}
{{--                                            <td width="133">Allied</td>--}}
{{--                                            <td width="133">04</td>--}}
{{--                                            <td width="133">12</td>--}}
{{--                                        </tr>--}}
{{--                                        <tr>--}}
{{--                                            <td width="133">Specialization</td>--}}
{{--                                            <td width="133">04</td>--}}
{{--                                            <td width="133">12</td>--}}
{{--                                        </tr>--}}
{{--                                        <tr>--}}
{{--                                            <td width="133">General/Compulsory</td>--}}
{{--                                            <td width="133">16</td>--}}
{{--                                            <td width="133">30</td>--}}
{{--                                        </tr>--}}
{{--                                        <tr>--}}
{{--                                            <td width="133">Project+ Internship</td>--}}
{{--                                            <td width="133">02</td>--}}
{{--                                            <td width="133">(06+03)09</td>--}}
{{--                                        </tr>--}}
{{--                                        <tr>--}}
{{--                                            <td width="372"><strong>Total</strong></td>--}}
{{--                                            <td width="133"><strong>49</strong></td>--}}
{{--                                            <td width="133"><strong>132</strong></td>--}}
{{--                                        </tr>--}}
{{--                                        </tbody>--}}
{{--                                    </table>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                <div class="semester-detail table-responsive">
                    <h2 class="my-3 sub-title">Semesters and Courses</h2>
                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 1</h2>
                                </div>

                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width  border-left">Course Title</th>
                                        <th class="width text-center border-left ">Credit Hours</th>
{{--                                        <th class="width text-center border-left ">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">GEN-104</td>
                                        <td width="372">Ideology and Constitution of Pakistan</td>
                                        <td width="133">2</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ENG-107</td>
                                        <td width="372">Functional English</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">CS-102</td>
                                        <td width="372">Applications of Information & Communication Technologies</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">CS-102</td>--}}
{{--                                        <td width="372">Application of Information &amp; Communication Technologies</td>--}}
{{--                                        <td width="133">3(2-1)</td>--}}
{{--                                        <td width="133">Compulsory</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">MATH-114</td>
                                        <td width="372">Business Mathematics</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Allied</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-111</td>
                                        <td width="372">Introduction to Business</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Allied</td>--}}

                                    </tr>
                                    <tr>
                                        <td width="133">MGT-112</td>
                                        <td width="372">Principles of Management</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>17</strong></td>
                                    </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 2</h2>
                                </div>

                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width  border-left">Course Title</th>
                                        <th class="width text-center border-left ">Credit Hours</th>
{{--                                        <th class="width text-center border-left ">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">ISL-101</td>
                                        <td width="372">Islamic Studies</td>
                                        <td width="133">2</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ENG-108</td>
                                        <td width="372">Expository Writing</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ECO-201</td>
                                        <td width="372">Microeconomics</td>
                                        <td  width="133">3</td>
{{--                                        <td rowspan="2" width="133">Compulsory</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">ETH-100</td>--}}
{{--                                        <td width="372">Ethics</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">MGT-114</td>
                                        <td width="372">Fundamentals of Accounting</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-211</td>
                                        <td width="372">Principles of Marketing</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">PSY-112</td>
                                        <td width="372">Introduction to Psychology</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">MGT-115</td>--}}
{{--                                        <td width="372">Introduction to Computing Application</td>--}}
{{--                                        <td width="133">3(2-1)</td>--}}
{{--                                        <td width="133">Allied</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>17</strong></td>
                                    </tr>
                                    </tbody>


                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 3</h2>
                                </div>

                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">MGT-212</td>
                                        <td width="372">Business Communication</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ECO-202</td>
                                        <td width="372">Macroeconomics</td>
                                        <td width="133">3 </td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">STAT-301</td>
                                        <td width="372">Statistics</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-300</td>
                                        <td width="372">Business Finance</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-213</td>
                                        <td width="372">Human Resource Management</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Allied</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">GEN-203</td>
                                        <td width="372">Community Service Learning</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">MGT-211</td>--}}
{{--                                        <td width="372">Principles of Marketing</td>--}}
{{--                                        <td width="133">3(3-0)</td>--}}
{{--                                        <td width="133">Major</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>18</strong></td>
                                    </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 4</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">MGT-413</td>
                                        <td width="372">Business Ethics & CSR</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-313</td>
                                        <td width="372">Cost & Management Accounting</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-414</td>
                                        <td width="372">Business Law</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">FIN-111</td>
                                        <td width="372">Finacial Markets & Institutions</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-315</td>
                                        <td width="372">Management Information Systems</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">GEN-205</td>
                                        <td width="372">Entrepreneurship</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">MGT-214</td>--}}
{{--                                        <td width="372">Financial Management</td>--}}
{{--                                        <td width="133">3(3-0)</td>--}}
{{--                                        <td width="133">Major</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>18</strong></td>
                                    </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 5</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">GEN-310</td>
                                        <td width="372">Research Methodology</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-316</td>
                                        <td width="372">Organizational Behaviour</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ENG-201</td>
                                        <td width="372">Technical Report Writing</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-214</td>
                                        <td width="372">Financial Management</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">GEN-410</td>
                                        <td width="372">International Business</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>15</strong></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 6</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">GEN-106</td>
                                        <td width="372">Logical & Critical Thinking</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-318</td>
                                        <td width="372">Total Quality Management</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">MGT-317</td>
                                        <td width="372">Operations Management</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">FIN-313</td>
                                        <td width="372">Corporate Governance</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ARAB-101</td>
                                        <td width="372">Arabic Language - I</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Specialization</td>--}}
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td width="133">-</td>--}}
{{--                                        <td width="372">Elective-II</td>--}}
{{--                                        <td width="133">3(3-0)</td>--}}
{{--                                        <td width="133">Specialization</td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>15</strong></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 7</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">FIN-320</td>
                                        <td width="372">Econometrics</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">FIN-312</td>
                                        <td width="372">Financial Reporting</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">FIN-319</td>
                                        <td width="372">Principles of Auditing</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ACT-414</td>
                                        <td width="372">Essential Softwares of Accounting</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Minor</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ACT-411</td>
                                        <td width="372">Financial Statements Analysis</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>15</strong></td>
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td colspan="4" width="133">Summer</td>--}}
{{--                                    </tr>--}}
{{--                                    <tr>--}}
{{--                                        <td width="133">GEN-410</td>--}}
{{--                                        <td width="372">Internship</td>--}}
{{--                                        <td width="133">3(0-3)</td>--}}
{{--                                        <td colspan="2">Compulsory</td>--}}
{{--                                    </tr>--}}
{{--                                    <tr>--}}
{{--                                        <td colspan="2" width="133">&nbsp;</td>--}}
{{--                                        <td width="133"><strong>03</strong></td>--}}
{{--                                        <td width="372">&nbsp;</td>--}}
{{--                                    </tr>--}}
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text">
                                    <h2>Semester 8</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center min-width">Course Code</th>
                                        <th class="width border-left">Course Title</th>
                                        <th class="width text-center border-left">Credit Hours</th>
{{--                                        <th class="width border-left">Category</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td width="133">MGT-425</td>
                                        <td width="372">Finacial Technologies</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Compulsory</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">GEN-304</td>
                                        <td width="372">Professional Practices</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Major</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">FIN-311</td>
                                        <td width="372">Principles of Taxation</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Specialization</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">ACT-416</td>
                                        <td width="372">Accounting Advisory Services</td>
                                        <td width="133">3</td>
{{--                                        <td width="133">Specialization</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">GEN-401</td>
                                        <td width="372">Final Year Project/ Dissertation</td>
                                        <td width="133">6</td>
                                        {{--                                        <td width="133">Specialization</td>--}}
                                    </tr>
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Credit Hours:</strong></td>
                                        <td width="133"><strong>18</strong></td>
                                    </tr>
{{--                                    <tr>--}}
{{--                                        <td colspan="4" width="133"><strong>Total Courses: 49</strong></td>--}}
{{--                                    </tr>--}}
{{--                                    <tr>--}}
{{--                                        <td colspan="4" width="133"><strong>Total Credit Hours: 132</strong></td>--}}
{{--                                    </tr>--}}
                                    <tr>
                                        <td width="133">&nbsp;</td>
                                        <td width="372"><strong>Total Credit Hours:</strong></td>
                                        <td width="133"><strong>133</strong></td>

                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="semester-detail">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="toper-text bg- ">
                                    <h2>Elective Courses :</h2>
                                    <h2>Finance</h2>

                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Course Code</th>
                                        <th class="width text-center border-left">Course Title</th>
                                        <th class="text-center border-left">Credit Hours</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>FIN-315</td>
                                        <td>Investment Banking</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-316</td>
                                        <td>Treasury and Fund Management</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-321</td>
                                        <td>Financial Risk Management</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-322</td>
                                        <td>Investment and Portfolio Management</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-415</td>
                                        <td>Advance Corporate Finance</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-421</td>
                                        <td>Islamic Banking Practices</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-418</td>
                                        <td>Behavioral Finance</td>
                                        <td class="text-center">3(3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>FIN-419</td>
                                        <td>International Banking</td>
                                        <td class="text-center">3(3-0)</td>
                                    </tr>
                                    </tbody>
                                </table>
                                <p>&nbsp;</p>
                                <div class="toper-text">
                                    <h2>Accounting</h2>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Course Code</th>
                                        <th class="width text-center border-left">Course Title</th>
                                        <th class="text-center border-left">Credit Hours</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>ACT-411</td>
                                        <td>Financial Statement Analysis</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-412</td>
                                        <td>Tax Management and Optimization</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-413</td>
                                        <td>Advanced Financial Accounting</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-414</td>
                                        <td>Essential Software of Accounting</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-314</td>
                                        <td>Accounting Theory</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-415</td>
                                        <td>Opinion Reporting</td>
                                        <td class="text-center">3 (3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-416</td>
                                        <td>Accounting Advisory Services</td>
                                        <td class="text-center">3(3-0)</td>
                                    </tr>
                                    <tr>
                                        <td>ACT-417</td>
                                        <td>Accounting Information System</td>
                                        <td class="text-center">3(3-0)</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </div>
    </section>
    </div>
    <!-- Admission Area End Here -->
@endsection
