@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">4 Semesters, 2 years</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">72</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <ul class="mx-4 text-start">
                                            <li>Intermediate or equivalent level with Mathematics
                                                at least 50% marks.
                                            </li>

                                        </ul>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3"> ADP Software Engineering</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>The University of Rawalpindi's Software Engineering curriculum is painstakingly designed to
                            offer a thorough grounding in both the fundamental and sophisticated aspects of software
                            engineering. The goal of this curriculum is to give students the technical know-how and
                            analytical abilities necessary to thrive in the quickly changing tech sector. In addition to
                            specific topics like software project management, software architecture, and the newest
                            technologies, the program covers fundamental concepts in software development, system
                            analysis, design, and testing. Our goal is to produce skilled software engineers who can
                            spearhead innovation and take the lead in the rapidly evolving technology industry.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Immerse yourself in comprehensive courses covering software development, algorithms,
                                preparing you to tackle complex engineering challenges.
                            </li>
                            <li>Engage in real-world projects and internships that provide practical experience in
                                coding, system design, and software testing, enhancing your technical skills.
                            </li>
                            <li>Learn the latest programming languages, frameworks, and tools, keeping you up-to-date
                                with industry standards and technological advancements.
                            </li>
                            <li>Benefit from strong ties with tech companies and professionals, offering networking
                                opportunities, mentorship, and pathways to internships and jobs in leading firms.
                            </li>
                            <li>Equip yourself for various career paths in software development, IT consulting,
                                cybersecurity, and more, with skills that are highly sought after in the tech industry.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Software Development: Software engineers, application developers.
                            </li>
                            <li>Quality Assurance: QA engineers, test analysts
                            </li>
                            <li>Project Management: Project managers, software development managers
                            </li>
                            <li>Systems Analysis: Systems analysts, business analysts
                            </li>
                            <li>Research and Development: Research scientists, IT researchers.
                            </li>
                        </ul>
                        <h2 class="my-3 sub-title">Semesters and Courses</h2>
                        <div class="semester-detail table-responsive">

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-104</td>
                                                <td width="372">Ideology and Constitution of Pakistan</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-107</td>
                                                <td width="372">Functional English</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-102</td>
                                                <td width="372">Applications of Information & Communication Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">PHY-103</td>
                                                <td width="372">Applied Physics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-111</td>
                                                <td width="372">Programming Fundamentals</td>
                                                <td width="133">4</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>15</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ISL-101</td>
                                                <td width="372">Islamic Studies</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-108</td>
                                                <td width="372">Expository Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MATH-214</td>
                                                <td width="372">Linear Algebra</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-204</td>
                                                <td width="372">Digital Logic Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-112</td>
                                                <td width="372">Object Oriented Programming</td>
                                                <td width="133">4</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MATH-104</td>
                                                <td width="372">Calculus and Analytical Geometry</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CS-202</td>
                                                <td width="372">Discrete Structures</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-404</td>
                                                <td width="372">Information Security</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-216</td>
                                                <td width="372">Data Structures</td>
                                                <td width="133">4</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-308</td>
                                                <td width="372">Artificial Intelligence</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">IT-326</td>
                                                <td width="372">Web Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-203</td>
                                                <td width="372">Community Service Learning</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>19</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CS-302</td>
                                                <td width="372">Computer Organization and Assembly Language</td>
                                                <td width="133">4</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-213</td>
                                                <td width="372">Database Systems</td>
                                                <td width="133">4</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-113</td>
                                                <td width="372">Software Engineering</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-307</td>
                                                <td width="372">Computer Networks</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">SE-402</td>
                                                <td width="372">Software Project Management</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-205</td>
                                                <td width="372">Entrepreneurship</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>20</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- Admission Area End Here -->

@endsection
