@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">4 Semesters, (2 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">70</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate or equivalent with a minimum 35%
                                            marks.</p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3"> ADP Business Administration</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>The University of Rawalpindi's Bachelor of Business Administration (BBA) program has been
                            skillfully designed to offer a strong foundation in both the fundamental and cutting-edge
                            areas of business administration. The goal of this program is to give students the
                            managerial and leadership abilities they need to succeed in the fast-paced corporate world
                            of today. In addition to covering specialist subjects like business analytics, international
                            business, and strategic management, the curriculum also covers fundamental concepts in
                            management, marketing, finance, human resource management, and entrepreneurship. Our goal is
                            to produce capable business leaders who can foster creativity and perform well in a variety
                            of corporate environments.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Study various aspects of business, including management, marketing, finance,
                                entrepreneurship, and international business, providing a well-rounded education that
                                prepares you for diverse career paths.
                            </li>

                            <li>Participate in internships, case studies, and business simulations that provide
                                real-world business experience, enhancing your practical skills and business acumen.
                            </li>
                            <li>Develop leadership and managerial skills through workshops, seminars, and group
                                projects, preparing you to lead teams and manage organizations effectively.
                            </li>
                            <li>Understand global business trends and practices, preparing you for a career in the
                                international business arena and equipping you with the skills needed to succeed in a
                                globalized economy.
                            </li>
                            <li>Connect with successful business professionals and alumni, enhancing your career
                                prospects and providing valuable insights into the business world.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Management: General managers, operations managers
                            </li>
                            <li>Marketing: Marketing managers, brand managers
                            </li>
                            <li>Finance: Financial analysts, corporate finance managers
                            </li>
                            <li>Human Resources: HR managers, talent acquisition specialists
                            </li>
                            <li>Entrepreneurship: Start-up founders, business consultants
                            </li>
                            <li>Sales: Sales managers, business development managers
                            </li>
                            <li>Public Relations: PR specialists, corporate communications managers
                            </li>
                            <li>Supply Chain: Logistics managers, procurement specialists
                            </li>
                        </ul>

                        <div class="semester-detail table-responsive">
                            <h2 class="my-3 sub-title">Semesters and Courses</h2>
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-104</td>
                                                <td width="372">Ideology and Constitution of Pakistan</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-107</td>
                                                <td width="372">Functional English</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-102</td>
                                                <td width="372">Applications of Information & Communication Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MATH-114</td>
                                                <td width="372">Business Mathematics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-111</td>
                                                <td width="372">Introduction to Business</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-112</td>
                                                <td width="372">Principles of Management</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ISL-101</td>
                                                <td width="372">Islamic Studies</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-108</td>
                                                <td width="372">Expository Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ECO-201</td>
                                                <td width="372">Microeconomics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-114</td>
                                                <td width="372">Fundamentals of Accounting</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-211</td>
                                                <td width="372">Principles of Marketing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">PSY-112</td>
                                                <td width="372">Introduction to Psychology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">MGT-212</td>
                                                <td width="372">Business Communication</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ECO-202</td>
                                                <td width="372">Macroeconomics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">STAT-301</td>
                                                <td width="372">Statistics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-300</td>
                                                <td width="372">Business Finance</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-213</td>
                                                <td width="372">Human Resource Management</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-203</td>
                                                <td width="372">Community Service Learning</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">MGT-413</td>
                                                <td width="372">Business Ethics & CSR</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-313</td>
                                                <td width="372">Cost & Management Accounting</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-414</td>
                                                <td width="372">Business Law</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">FIN-111</td>
                                                <td width="372">Financial Markets & Institutions</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-315</td>
                                                <td width="372">Management Information Systems</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-205</td>
                                                <td width="372">Entrepreneurship</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- Admission Area End Here -->

@endsection
