@extends('front.layouts.app')
@section('content')

    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Program Details</h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Admission <i class="fa fa-angle-double-right ms-2"></i></li>
                    <li><a class="text-white" href="{{route('front.programs')}}">Programs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Admission Area Start Here -->
    <div class="course-detail-page">
        <section class="course-details-wrap pt-3">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12">
                        <div class="table-responsive mt-5">
                            <table class="table my-3 table-bordered course-fact" id="table-course">
                                <thead>
                                <tr class="bg-blue">
                                    <th colspan="5" class="text-nowrap text-center course-fact-new pt-3 pb-2">
                                        <h2 class="text-white">COURSE FACT</h2>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="table-data">
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY LEVEL
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red" style="width: 200px;">
                                        STUDY NOTE
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        PROGRAM DURATION
                                    </td>
                                    <td class="text-center text-white fs-5 fw-bold bg-red">
                                        CREDITS HOURS
                                    </td>
                                    <td rowspan="5" class="text-center align-middle bt-apply apply-back"
                                        style="width: 200px;">
                                        <a href="{{url('https://admission.uor.edu.pk/')}}">
                                            <button class="apply-now-new">Apply Now <i class="fa fa-angle-right ms-1"
                                                                                       aria-hidden="true"></i>
                                            </button>
                                        </a>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Undergraduate</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">Full-Time</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">4 Semesters, (2 years)</p>
                                    </td>
                                    <td>
                                        <p class="fs-5 pt-2">70</p>
                                    </td>
                                </tr>
                                <tr class="table-data table-detail text-center">
                                    <td>
                                        <p class="fs-5 pt-2">Eligibility Criteria</p>
                                    </td>
                                    <td colspan="3">
                                        <p class="fs-5 pt-2 align-left">Intermediate or equivalent with a minimum of 35% marks</p>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Sidebar Quick Links Start Here -->
                    <div class="col-lg-3 mt-3">
                        <div class="course-details-widget sidebar-box">

                            <div class="quick-link-pages pt-4 pb-2 px-3 mb-4">
                                <div class="heading text-center">
                                    <button class="btn py-3 w-100">QUICK LINKS</button>
                                </div>
                                <div class="pages mt-4">
                                    <div class="d-flex mb-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/news-events" class="text-decoration-none">
                                                <p>News and Events</p></a>
                                        </div>
                                    </div>
                                    <div class="d-flex my-2">
                                        <div class="tab-icon">
                                            <i class="fa fa-external-link pe-2"></i>
                                        </div>
                                        <div class="tab-texts">
                                            <a href="{{ URL('/') }}/co-curricular-activities"
                                               class="text-decoration-none">
                                                <p>Co-Curricular Activities</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Sidebar Quick Links End Here -->

                    <div class="col-lg-9 mt-3">
                        <h1 class="color-change mt-3">ADP Digital Design and Computer Arts</h1>
                        <hr class="mt-0">
                        <h2 class="sub-title">Program Overview</h2>
                        <p>A thorough examination of digital media, graphic design, and computer-aided design (CAD) is
                            provided by the carefully crafted Bachelor of Science (BS) in Digital Design and Computer
                            Arts program at the University of Rawalpindi. The goal of this program is to give students
                            the practical knowledge and abilities necessary for success in the rapidly changing fields
                            of computer graphics and digital design. The program covers specialist topics including user
                            experience (UX) design and game design in addition to diving deeply into fundamental ideas
                            of visual communication, digital imagery, 3D modeling, animation, and interactive design.
                            Our goal is to produce creative and technically proficient designers who can lead innovation
                            and succeed in a variety of fields.</p>
                        <h2 class="mt-3 sub-title">Why choose this course?</h2>
                        <ul>
                            <li>Explore digital media, graphic design, 3D modeling, animation, and interactive design,
                                fostering both creativity and technical skills that are essential in the digital design
                                industry.
                            </li>
                            <li>Access advanced software and tools used in the industry, ensuring you stay ahead in the
                                rapidly evolving field of digital design.
                            </li>
                            <li>Build a professional portfolio through diverse projects and assignments, showcasing your
                                design talents and technical proficiency to potential employers.
                            </li>
                            <li>Learn from instructors with industry experience and connections, keeping you informed
                                about the latest trends, practices, and technological advancements in digital design.
                            </li>
                            <li>Prepare for diverse roles in graphic design, web development, animation, game design,
                                and more, equipping you with the skills needed to adapt to various career paths in the
                                digital and creative industries.
                            </li>
                        </ul>
                        <h2 class="mt-3 sub-title">Career Opportunities</h2>
                        <p>Graduates of this program can pursue various career paths in:</p>
                        <ul>
                            <li>Graphic Design: Graphic designers, creative directors
                            </li>
                            <li>Web Design and Development: Web designers, front-end developers
                            </li>
                            <li>Animation and Motion Graphics: Animators, visual effects (VFX) artists
                            </li>
                            <li>User Experience (UX) Design: UX designers, usability specialists
                            </li>
                            <li>Game Design: Game designers, level designers
                            </li>
                            <li>Digital Marketing: Digital marketers, content strategists
                            </li>
                            <li>Advertising: Art directors, advertising designers
                            </li>
                            <li>Multimedia Production: Multimedia artists, multimedia developers
                            </li>
                        </ul>

                        <div class="semester-detail table-responsive">
                            <h2 class="my-3 sub-title">Semesters and Courses</h2>
                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 1</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">GEN-104</td>
                                                <td width="372">Ideology and Constitution of Pakistan</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-107</td>
                                                <td width="372">Functional English</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CS-102</td>
                                                <td width="372">Applications of Information & Communication Technologies</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-410</td>
                                                <td width="372">History of Art in Ancient Civilizations</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-400</td>
                                                <td width="372">Basic Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-420</td>
                                                <td width="372">Basic Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 2</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ISL-101</td>
                                                <td width="372">Islamic Studies</td>
                                                <td width="133">2</td>
                                            </tr>
                                            <tr>
                                                <td width="133">ENG-108</td>
                                                <td width="372">Expository Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-411</td>
                                                <td width="372">History of Western Arts</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-402</td>
                                                <td width="372">Still Life Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-412</td>
                                                <td width="372">History of Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">PSY-112</td>
                                                <td width="372">Introduction to Psychology</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>17</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 3</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">ENG-201</td>
                                                <td width="372">Technical Report Writing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">STAT-301</td>
                                                <td width="372">Statistics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-403</td>
                                                <td width="372">Landscape Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-421</td>
                                                <td width="372">Graphic Design</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-440</td>
                                                <td width="372">Drafting</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-203</td>
                                                <td width="372">Community Service Learning</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>

                            <div class="semester-detail">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="toper-text">
                                            <h2>Semester 4</h2>
                                        </div>

                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th class="text-center min-width">Course Code</th>
                                                <th class="width border-left">Course Title</th>
                                                <th class="width text-center border-left">Credit Hours</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td width="133">CA-404</td>
                                                <td width="372">Portrait Drawing</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-470</td>
                                                <td width="372">Fundamentals of Photography</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-423</td>
                                                <td width="372">Computer Graphics</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">CA-430</td>
                                                <td width="372">Basic Animation</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">MGT-315</td>
                                                <td width="372">Management Information Systems</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">GEN-205</td>
                                                <td width="372">Entrepreneurship</td>
                                                <td width="133">3</td>
                                            </tr>
                                            <tr>
                                                <td width="133">&nbsp;</td>
                                                <td width="372"><strong>Credit Hours:</strong></td>
                                                <td width="133"><strong>18</strong></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Admission Area End Here -->
@endsection
