@extends('front.layouts.app')
@section('content')
    <!-- Inner Page Banner Area Start Here -->
    <div class="inner-page-banner-area">
        <div class="container">
            <div class="pagination-area">
                <h1>Contact Us </h1>
                <ul>
                    <li><a href="{{route('front.home')}}">Home</a> -</li>
                    <li>Contact</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Inner Page Banner Area End Here -->

    <!-- Contact Us Page Area Start Here -->
    <div class="contact-us-page1-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                    <div class="contact-us-info1">
                        <ul>
                            <li>
                                <i class="fa fa-phone" aria-hidden="true"></i>
                                <h3>Phone</h3>
                                <p>051-8770171-76</p>
                            </li>
                            <li>
                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                <h3>Address</h3>
                                <p>Main Grand Trunk Rd, near DHA-1, <br> opposite High Court, Rawalpindi, Punjab 46000</p>
                            </li>
                            <li>
                                <i class="fa fa-envelope-o" aria-hidden="true"></i>
                                <h3>E-mail</h3>
                                <p>info@uor.edu.pk</p>
                            </li>
                            <li>
                                <h3>Follow Us</h3>
                                <ul class="contact-social">
                                    <li><a href="https://facebook.com/uniofrawalpindi"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                    <li><a href="https://twitter.com/uniofrawalpindi"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                                    <li><a href="https://www.linkedin.com/company/uniofrawalpindi"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                                    <li><a href="https://www.instagram.com/uniofrawalpindi"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>

                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
                    <div class="row">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <h2 class="title-default-left title-bar-high">Contact With Us</h2>
                        </div>
                    </div>
                    <div class="row">
                        <div class="contact-form1">
                            <form method="{{$method}}" action="{{$action}}" enctype="{{$enctype}}">
                                @csrf
                                <fieldset>
                                    @if (Session::has('success'))
                                        <div class="alert alert-success">{{ Session::get('success') }}</div>
                                    @endif
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="text" placeholder="Name*" class="form-control @error('name') is-invalid @enderror" name="name" id="form-name" data-error="Name field is required" required>
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="email" placeholder="Email*" class="form-control @error('email') is-invalid @enderror" name="email" id="form-email" data-error="Email field is required" required>
                                            <div class="help-block with-errors"></div>
                                            @error('email')
                                            <strong class="text-danger">{{ $message }}</strong>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <textarea placeholder="Message*" class="textarea form-control @error('message') is-invalid @enderror" name="message" id="form-message" rows="8" cols="20" data-error="Message field is required" required maxlength="250"></textarea>
                                            <div class="help-block with-errors"></div>
                                            @error('message')
                                            <strong class="text-danger">{{ $message }}</strong>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-6 col-md-12">
                                        <div class="form-group margin-bottom-none">
                                            <button type="submit" class="default-big-btn">Send Message</button>
                                        </div>
                                    </div>
                                    <div class="col-xl-8 col-lg-8 col-md-6 col-md-12">
                                        <div class='form-response'></div>
                                    </div>
                                </fieldset>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid mt-5">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3325.0042001318243!2d73.0975878!3d33.55326720000001!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x38dfed003c55e41b%3A0xcf43579445729b6c!2sUniversity%20of%20Rawalpindi!5e0!3m2!1sen!2s!4v1720181125223!5m2!1sen!2s" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </div>
    <!-- Contact Us Page Area End Here -->
@endsection

@push('footer-scripts')
    <!-- Google Map js -->
    <script src="https://maps.app.goo.gl/vegZFdcmdUntuDTCA?g_st=iw"></script>

    <script>
        $(document).ready(function() {
            /*-------------------------------------
     Google Map
     -------------------------------------*/
            if ($('#googleMap').length) {

                //Google map icon
                let icon= "{{asset('frontend/academics/img/map-marker.png')}}";

                //Map initialize
                var initialize = function() {
                    var mapOptions = {
                        zoom: 15,
                        scrollwheel: false,
                        center: new google.maps.LatLng(-37.81618, 144.95692)
                    };
                    var map = new google.maps.Map(document.getElementById("googleMap"),
                        mapOptions);
                    var marker = new google.maps.Marker({
                        position: map.getCenter(),
                        animation: google.maps.Animation.BOUNCE,
                        icon: icon,
                        map: map
                    });
                }

                google.maps.event.addDomListener(window, "load", initialize);
            }
        });
    </script>
    {{-- Toastr : Script : Start --}}
    @if(Session::has('messages'))
        <script>
            noti({!! json_encode((Session::get('messages'))) !!});
        </script>
    @endif
    {{-- Toastr : Script : End --}}

@endpush

