@extends('front.layouts.app')
@push('head-scripts')
@endpush
@section('content')
    <!-- Banner -->
    <div class="inner-page-banner-area"
         style="background-image: url('{{ asset('frontend/academics/img/scholarship/scholarship1.jpg') }}');">
        <div class="container">
            <div class="pagination-area">
                <h1>Scholarship</h1>
                <ul>
                    <li><a href="https://uor.edu.pk/">Home</a> -</li>
                    <li>Scholarship</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Scholarship Section -->
    <div class="research-page1-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                            <div class="research-box1">
                                <a href="{{ URL('/') }}/scholarship-detail/merit_scholarship" class="card-link" style="text-decoration: none; color: inherit; display: block;">
                                    <div class="featured-img-holder hvr-bounce-to-right"
                                         style="width: 100%; height: 240px; overflow: hidden;">
                                        <img src="{{ asset('frontend/academics/img/scholarship/merit.jpg') }}"
                                             class="img-responsive"
                                             alt="Merit Scholarship"
                                             style="width: 100%; height: 100%; object-fit: cover;">
                                        <span class="zoom"></span>
                                    </div>
                                    <h3 class="sidebar-title">
                                        Merit Scholarship
                                    </h3>
                                    <p>Awarded to students with exceptional academic records in previous examinations.
                                        Recognizing consistent excellence and hard work.</p>
                                </a>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                            <div class="research-box1">
                                <a href="{{ URL('/') }}/scholarship-detail/high_achiever_scholarship" class="card-link" style="text-decoration: none; color: inherit; display: block;">
                                    <div class="featured-img-holder hvr-bounce-to-right"
                                         style="width: 100%; height: 240px; overflow: hidden;">
                                        <img src="{{ asset('frontend/academics/img/scholarship/acheivers.png') }}"
                                             class="img-responsive"
                                             alt="Merit Scholarship"
                                             style="width: 100%; height: 100%; object-fit: cover;">
                                        <span class="zoom"></span>
                                    </div>
                                    <h3 class="sidebar-title">
                                        High Achiever Scholarship
                                    </h3>
                                    <p>For students who rank among the top percentile in semester results. Excellence
                                        deserves to be celebrated and supported</p>
                                </a>
                            </div>
                        </div>

                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                            <div class="research-box1">
                                <a href="{{ URL('/') }}/scholarship-detail/special_scholarship" class="card-link" style="text-decoration: none; color: inherit; display: block;">
                                    <div class="featured-img-holder hvr-bounce-to-right"
                                         style="width: 100%; height: 240px; overflow: hidden;">
                                        <img src="{{ asset('frontend/academics/img/scholarship/special.jpg') }}"
                                             class="img-responsive"
                                             alt="Merit Scholarship"
                                             style="width: 100%; height: 100%; object-fit: cover;">
                                        <span class="zoom"></span>
                                    </div>
                                    <h3 class="sidebar-title">
                                        Special Scholarship
                                    </h3>
                                    <p>Designed for students with financial hardships, special needs, or from
                                        underrepresented communities. We believe in equal opportunity for all.</p>
                                </a>
                            </div>
                        </div>



                    </div>
                </div>

                <!-- Scholarship -->
                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                    <div class="sidebar">
                        <div class="sidebar-box">
                            <div class="sidebar-box">
                                <div class="sidebar-box-inner">
                                    <h3 class="sidebar-title">Events</h3>
                                    <div class="sidebar-latest-research-area">
                                        <ul>
                                            <li>
                                                <div class="latest-research-img">
                                                    <a href="{{ route('scholarship') }}"><img
                                                            src="{{'frontend/academics/'}}/img/scholarship/student.jpg"
                                                            class="img-responsive" alt="skilled"></a>
                                                </div>
                                                <div class="latest-research-content">
                                                    <h4>6,June 2025</h4>
                                                    <p>Join with us should be Apply Now
                                                        and take to scholarship test google form</p>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="sidebar-box mt-4">
                        <div class="sidebar-add-area overlay-primaryColor">
                            <img src="{{ asset('frontend/academics/img/scholarship/apply.jpg') }}"
                                 class="img-responsive"
                                 alt="banner">
                            <a href="https://docs.google.com/forms/d/e/1FAIpQLSe5zmD-WswfvxGK6KtNX_maau0WfClzi5ScSlw8VvhZ-GLA3g/viewform"
                               class="sidebar-ghost-btn">Apply Now!</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container scholarship-awa-wrapper">
        <!-- Scholarship Policy Section -->
        <div class="mb-5">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0">University of Rawalpindi – Scholarship Policy</h2>
                <button id="policyToggle" class="btn btn-light scholarship-awa-toggle-btn">+</button>
            </div>
            <hr/>
            <div id="policyContent" class="mt-3" style="display: none;">
                <h6 class="fw-bold mb-3">
                    Please read the following carefully and ensure that you understand the conditions of the scholarship
                    you have applied for or been offered to.
                </h6>
                <p>
                    University of Rawalpindi – Scholarship Policy
                </p>
                <p class="fw-semibold mt-4">Purpose:</p>
                <ol class="ps-3">
                    <li class="mb-3">The University of Rawalpindi is committed to making quality education accessible to
                        all, regardless of financial status or background. This scholarship policy outlines the various
                        merit-based, and special assistance programs designed to reward academic excellence and support
                        deserving students.
                    </li>
                </ol>
                <p class="fw-semibold mt-4">Scholarship Categories:</p>
                <p class="fw-semibold mt-4"> A Merit Scholarship for Intermediate Board High Achiever</p>
                <p class="fw-semibold mt-4">Eligibility:</p>
                <ol class="ps-3">
                    <li class="mb-3">For new entrants in undergraduate programs only.</li>
                    <li class="mb-3">Based on Intermediate performance.</li>
                    <li class="mb-3">Based on admission test performance.</li>
                </ol>

                <p class="fw-semibold mt-4">Award Criteria:</p>
                <table class="table table-bordered">
                    <thead>
                    <tr>
                        <th>Academic Achievement</th>
                        <th>Tuition Fee Waiver</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>Board Position Holders (All BISEs in Pakistan)</td>
                        <td>100% (First Semester only)</td>
                    </tr>
                    <tr>
                        <td>90% and above</td>
                        <td>20% (First Semester only)</td>
                    </tr>
                    <tr>
                        <td>80% – 89.99%</td>
                        <td>10% (First Semester only)</td>
                    </tr>
                    <tr>
                        <td>Top Performer in Admission Test</td>
                        <td>100% (First Semester only)</td>
                    </tr>
                    </tbody>
                </table>
                <p>Applicable only for the first semester.</p>

                <p class="fw-semibold mt-4">B. High Achiever Scholarship (Academic Performance Based)</p>
                <p class="fw-semibold mt-4">Eligibility: </p>
                <ul class="ps-3">
                    <li class="mb-3">Available to current students in undergraduate and postgraduate programs.</li>
                    <li class="mb-3"> Based on GPA in the <b> previous semester</b>.</li>
                    <li class="mb-3">Student must be regular, with no failed course or disciplinary action.</li>
                </ul>

                <p class="fw-semibold mt-4">Award Criteria:</p>
                <table class="table table-bordered">
                    <thead>
                    <tr>
                        <th>Semester GPA</th>
                        <th>Tuition Fee Waiver (Next Semester)</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>3.91 and above</td>
                        <td>50%</td>
                    </tr>
                    <tr>
                        <td> 3.76 to 3.90</td>
                        <td>25%</td>
                    </tr>
                    <tr>
                        <td>3.50 to 3.75</td>
                        <td>10%</td>
                    </tr>
                    </tbody>
                </table>

                <p class="fw-semibold mt-4">C Special Scholarships (Financial Assistance & Concessions)</p>
                <p class="fw-semibold mt-4">Eligibility:</p>
                <ul class="ps-3">
                    <li class="mb-3">Based on documented financial need.</li>
                    <li class="mb-3">For students with specific circumstances including family enrollment, regional
                        background, or early admission.
                    </li>
                </ul>

                <p class="fw-semibold mt-4">Components & Benefits:</p>
                <ul class="ps-3">
                    <li class="mb-3"><strong>Sibling Concession:</strong> 20% waiver for second and onward siblings
                        studying concurrently.
                    </li>
                    <li class="mb-3"><strong>Early Bird Discount:</strong> 10% tuition fee waiver on the entire degree
                        (if admitted within the early admission window).
                    </li>
                    <li class="mb-3"><strong>Orphan Students:</strong> 20% tuition fee waiver (upon official
                        documentation).
                    </li>
                    <li class="mb-3"><strong>Students from Tribal Areas:</strong> 20% tuition fee waiver (proof of
                        domicile required).
                    </li>
                </ul>


                <p class="fw-semibold mt-4">3. General Rules and Conditions</p>
                <ol class="ps-3">
                    <li class="mb-3">A student can only avail one scholarship at any given time.</li>
                    <li class="mb-3">In case of eligibility for multiple scholarships, the highest-value scholarship
                        will be applied.
                    </li>
                    <li class="mb-3">All scholarships and financial aid are subject to approval by the University's
                        Scholarship/Financial Assistance Committee.
                    </li>
                    <li class="mb-3">The university reserves the right to amend the scholarship policy without prior
                        notice.
                    </li>
                    <li class="mb-3">Scholarships apply to tuition fees only, unless otherwise specified.</li>
                    <li class="mb-3">All waivers are non-transferable and may be revoked in case of misconduct or
                        academic dishonesty.
                    </li>
                </ol>

                <p class="fw-semibold mt-4">4. Approval and Oversight</p>
                <ul class="ps-3">
                    <li class="mb-3">The Scholarship Committee, in coordination with Admissions and Finance departments,
                        is responsible for processing, reviewing, and approving scholarships.
                    </li>
                    <li class="mb-3">Any misuse or misrepresentation will lead to immediate cancellation and
                        disciplinary action.
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="container-fluid mt-2 py-3 py-md-4 px-3 px-md-5 px-lg-5 px-xl-5" style="background-color: #F5F5F5;">
        <!-- FAQs Section -->
        <div class="mx-auto" style="max-width: 1200px;">
            <h2 class="fw-bold">FAQs</h2>

            <div class="scholarship-awa-faq-item">
                <div class="scholarship-awa-faq-question d-flex justify-content-between align-items-center">
                    <span>Can I get more than one scholarship at the same time?</span>
                    <button class="btn scholarship-awa-faq-toggle bg-light">+</button>
                </div>
                <div class="scholarship-awa-faq-answer">No, a student can only avail one scholarship at a time. If you
                    are eligible
                    for multiple scholarships, the one with the highest financial benefit will be applied automatically.
                </div>
            </div>

            <div class="scholarship-awa-faq-item">
                <div class="scholarship-awa-faq-question d-flex justify-content-between align-items-center">
                    <span>How do I apply for a scholarship at the time of admission?</span>
                    <button class="btn scholarship-awa-faq-toggle bg-light">+</button>
                </div>
                <div class="scholarship-awa-faq-answer">For merit-based and test-based scholarships, no separate
                    application is
                    required. Your eligibility is automatically assessed based on your academic records and admission
                    test performance. For special scholarships, you must submit a Financial Assistance Form with
                    supporting documents.
                </div>
            </div>

            <div class="scholarship-awa-faq-item">
                <div class="scholarship-awa-faq-question d-flex justify-content-between align-items-center">
                    <span>Are scholarships available for the entire duration of the degree program?</span>
                    <button class="btn scholarship-awa-faq-toggle bg-light">+</button>
                </div>
                <div class="scholarship-awa-faq-answer">Most scholarships (like merit and test-based) are awarded for
                    the first
                    semester only. However, performance-based (High Achiever) and Special scholarships may be renewed
                    each semester, subject to eligibility and university approval.
                </div>
            </div>

            <div class="scholarship-awa-faq-item">
                <div class="scholarship-awa-faq-question d-flex justify-content-between align-items-center">
                    <span>What documents are required for special scholarships like orphan or tribal area concessions?</span>
                    <button class="btn scholarship-awa-faq-toggle bg-light">+</button>
                </div>
                <div class="scholarship-awa-faq-answer">You'll need to submit:<br>
                    • For orphans: Death certificate of parent(s) and NADRA Family Registration Certificate<br>
                    • For tribal area students: Domicile or official document verifying residence in a tribal area
                </div>
            </div>

            <div class="scholarship-awa-faq-item">
                <div class="scholarship-awa-faq-question d-flex justify-content-between align-items-center">
                    <span>Who decides whether I will receive a scholarship?</span>
                    <button class="btn scholarship-awa-faq-toggle bg-light">+</button>
                </div>
                <div class="scholarship-awa-faq-answer">All scholarship awards are finalized by the University of
                    Rawalpindi
                    Scholarship Committee, after reviewing eligibility criteria, documents, and available quotas. The
                    committee's decision is final and binding.
                </div>
            </div>

        </div>
    </div>








@endsection
@push('footer-scripts')
    <script>
        $(document).ready(function () {
            $('#policyToggle').click(function () {
                $('#policyContent').slideToggle();
                const btn = $(this);
                btn.text(btn.text() === '+' ? '-' : '+');
            });

            $('.scholarship-awa-faq-question').click(function () {
                const answer = $(this).next('.scholarship-awa-faq-answer');
                const toggle = $(this).find('.scholarship-awa-faq-toggle');

                $('.scholarship-awa-faq-answer').not(answer).slideUp();
                $('.scholarship-awa-faq-toggle').not(toggle).text('+');

                if (answer.is(':visible')) {
                    answer.slideUp();
                    toggle.text('+');
                } else {
                    answer.slideDown();
                    toggle.text('-');
                }
            });
        });
    </script>
    <script>
        const countdownTarget = new Date('2025/06/06 12:00:00');

        function updateCountdown() {
            const now = new Date();
            const timeDiff = countdownTarget - now;

            const days = Math.floor(timeDiff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((timeDiff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((timeDiff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((timeDiff % (1000 * 60)) / 1000);

            document.getElementById('days').textContent = String(days).padStart(2, '0');
            document.getElementById('hours').textContent = String(hours).padStart(2, '0');
            document.getElementById('minutes').textContent = String(minutes).padStart(2, '0');
            document.getElementById('seconds').textContent = String(seconds).padStart(2, '0');
        }

        updateCountdown();
        setInterval(updateCountdown, 1000);
    </script>

@endpush
