<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            ['name' => 'admin_user-management_module-list', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-create', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-show', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-edit', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-delete', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-activity-log', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_module-activity-log-trash', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-list', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-create', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-show', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-edit', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-activity-log', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-activity-log-trash', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-group-delete', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-list', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-create', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-show', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-edit', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_permission-delete', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_role-list', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_role-create', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_role-show', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_role-edit', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_role-delete', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-list', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-create', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-show', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-edit', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-activity-log', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-activity-log-trash', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_user-delete', 'group_id' => 1, 'module_id'=>1],
            ['name' => 'admin_user-management_backup-list', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_backup-create', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_backup-download', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_backup-delete', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_log-dashboard', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_log-list', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_log-show', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_log-download', 'group_id' => 2, 'module_id'=>1],
            ['name' => 'admin_user-management_log-delete', 'group_id' => 2, 'module_id'=>1],

            //Manager Dashboard
            ['name' => 'manager_manager_dashboard', 'group_id' => 3, 'module_id'=>2],

            //News and Events
                //Category
            ['name' => 'manager_news-event_category-list', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-create', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-show', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-edit', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-activity-log', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-activity-log-trash', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-delete', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_category-status', 'group_id' => 4, 'module_id'=>2],

            ['name' => 'manager_news-event_list', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_create', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_show', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_edit', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_activity-log', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_activity-log-trash', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_delete', 'group_id' => 4, 'module_id'=>2],
            ['name' => 'manager_news-event_status', 'group_id' => 4, 'module_id'=>2],

            ['name' => 'manager_contact-us_list', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_create', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_show', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_edit', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_activity-log', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_activity-log-trash', 'group_id' => 5, 'module_id'=>2],
            ['name' => 'manager_contact-us_delete', 'group_id' => 5, 'module_id'=>2],

            //career-assessments
            ['name' => 'manager_career-assessments_list', 'group_id' => 6, 'module_id'=>2],

        ];
        foreach ($permissions as $permission){
            Permission::create($permission);
        }
    }
}
