<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('career_assessments', function (Blueprint $table) {
            $table->id();
            $table->string('student_name');
            $table->string('institute');
            $table->string('class');
            $table->bigInteger('contact');
            $table->integer('analytical_logical');
            $table->integer('business_management');
            $table->integer('creative_artistic');
            $table->integer('language_communication');
            $table->integer('social_human_sciences');
            $table->integer('scientific_healthcare');
            $table->string('primary_dimension');
            $table->string('secondary_dimension');
            $table->string('primary_recommendation');
            $table->string('primary_major_career_pathways');
            $table->string('secondary_recommendation');
            $table->string('secondary_major_career_pathways');
            $table->text('primary_secondary_major_description');

//            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('career_assessments');
    }
};
