<?php

namespace App\Http\Controllers\Manager\CareerAssessment;

use App\Http\Controllers\Controller;
use App\Imports\CareerAssessmentImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class CareerAssessmentController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manager_career-assessments_list', ['only' => ['index','importExcel']]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('manager.career-assessment.index');
    }
    public function importExcel(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,csv|max:2048'
        ]);

        Excel::import(new CareerAssessmentImport, $request->file('file'));

        try {
            return redirect()->back()->with('success', 'File uploaded successfully!');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'File upload failed: ' . $e->getMessage());
        }
    }



    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
