<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Subscribers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Exception;

class SubscribersController extends Controller
{
    public function subscribe(Request $request)
    {
        // Validate incoming request data
        $request->validate([
            'email' => 'required|email|unique:subscribers,email',
        ]);

        // Create a new subscriber record in your local database
        $subscriber = Subscribers::create([
            'email' => $request->input('email'),
        ]);

        if ($subscriber) {
            // Set Mailchimp API credentials and list ID
            $apiKey = 'c2553f3496e9d48a91f92b899fc7e528-us13';
            $serverPrefix = 'us13';
            $listId = '38465d8c63';
            // Mailchimp API endpoint URL
            $url = "https://$serverPrefix.api.mailchimp.com/3.0/lists/$listId/members";

            // Prepare data for the API request
            $data = [
                'email_address' => $subscriber->email,
                'status' => 'subscribed',
            ];

            // Make the HTTP POST request to Mailchimp API
            $response = Http::withHeaders([
                'Authorization' => 'Basic ' . base64_encode("anystring:$apiKey"),
                'Content-Type' => 'application/json',
            ])->post($url, $data);
            // Check response status
            if ($response->successful()) {
                // Update subscriber status to 1 (subscribed in Mailchimp)
                $subscriber->update(['status' => 1]);

            }
        }

        return redirect()->route('front.home');

    }
}
