<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactUs;
use Illuminate\Support\Facades\Session;

class ScholarshipController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = array(
            'page_title' => 'Scholarship Details',
            'p_title'=>'Scholarship Details',
        );
        return view('front.scholarship')->with($data);
    }

    public function scholarshipDetail($slug){
        $data = array(
            'page_title' => 'Scholarship Details',
            'p_title'=>'Scholarship Details',
            'method' => 'POST',
            'action' => route('contact-us.store'),
            'enctype' => 'application/x-www-form-urlencoded',
        );
        $view = str_replace('-', '_', $slug);
        return view('front.scholarship-detail.'.$view)->with($data);
    }


    public function scholarshipAll(){
        $data = array(
            'page_title' => 'Scholarship All',
            'p_title'=>'Scholarship All',
        );
        return view('front.all-scholarship')->with($data);
    }





    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
