<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\NewsAndEvents;
use App\Models\NewsAndEventsCategory;
use Illuminate\Http\Request;

class HomePageController extends Controller
{
    public function index() {
        $newsAndEvents = NewsAndEvents::where('status', 1)
            ->orderBy('date', 'desc')
            ->latest()
            ->take(6)
            ->get();
        $data = array(
            'newsAndEvents' => $newsAndEvents,
        );
        return view('front.index')->with($data);
    }
    public function newsEvent(Request $request) {
        $search = $request->input('search');

        $category_id = $request->input('category_id');

        $events = NewsAndEvents::where('status', 1)->with('category')
            ->when($search, function ($query) use ($search) {
                $query->where('title', 'like', "%{$search}%")
                    ->orWhere('description', 'like', "%{$search}%")
                    ->orWhere('date', 'like', "%{$search}%");
            });
        if ($request->has('type')) {
            $events->where('type', $request->type);
        }

        if ($category_id) {
            $events->where('news_and_events_category_id', $category_id);
        }
        $events = $events->orderby('date', 'desc')->paginate(4);

        $categories = NewsAndEventsCategory::where('status', 1)->get();

        $data = array(
            'events' => $events,
            'categories' => $categories,

        );

        return view('front.news_events',)->with($data);
    }
   public function newsEventDetail($slug)
   {
       $event = NewsAndEvents::where('status',1)->where('slug', $slug)->first();
       $data = array(
           'event' => $event
       );

       if (!$event){
           abort(404,'Not Found');
       }

       return view('front.news-event-detail')->with($data);
   }
}
