<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\ContactUs;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class ContactUsController extends Controller
{
    public function index(){

        $contact  = ContactUs::get();
        $data = array(
            'page_title' => 'Contact Us',
            'p_title' => 'Contact Us',
            'method' => 'POST',
            'action' => route('contact-us.store'),
            // 'enctype' => 'multipart/form-data' // (Default)Without attachment
            'enctype' => 'application/x-www-form-urlencoded', // With attachment like file or images in form
        );
        return view('front.contact_us')->with($data);

    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required',
            'message' => 'required|max:250',
        ]);
        //
        $arr = [
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'message' => $request->input('message'),
        ];
        $record = ContactUs::create($arr);
        $messages = [
            array(
                'message' => 'Message sent successfully',
                'message_type' => 'success'
            ),
        ];
        Session::flash('messages', $messages);
        return redirect()->back();
    }
}
