<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\CareerAssessment;
use Illuminate\Http\Request;

use Barryvdh\DomPDF\Facade\Pdf;


class CarrerAssessmentController extends Controller
{
    public function index(Request $request){
        return view('front.carrer_assessment');
    }
    public function checkPhoneNumber(Request $request)
    {
        $request->validate([
            'phone_number' => ['required', 'regex:/^03[0-9]{2}-[0-9]{7}$/'],
        ]);

        $phoneNumber = $request->input('phone_number');
        $phoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

        if (str_starts_with($phoneNumber, '0')) {
            $phoneNumber = '92' . substr($phoneNumber, 1);
        }

        $students = CareerAssessment::where('contact', $phoneNumber)->get();

        if ($students->count() === 1) {
            return view('front.carrer_assessment_detail', ['student' => $students->first()]);
        } elseif ($students->count() > 1) {
            return view('front.career_assessment_list', ['students' => $students]);
        } else {
            return redirect()->back()->with('error', 'Number does not exist');
        }
    }

    public function showDetail($id)
    {
        $student = CareerAssessment::findOrFail($id);
        return view('front.carrer_assessment_detail', ['student' => $student]);
    }


    public function generatePDF($id)
    {
        $student = CareerAssessment::findOrFail($id);

        $pdf = pdf::loadView('front.carrer_assessment_pdf', compact('student'))
            ->setPaper('a4', 'portrait')
            ->setOption('isHtml5ParserEnabled', true)
            ->setOption('isRemoteEnabled', true); // Allow external images/CSS

        return $pdf->stream('career_assessment_'.$student->id.'.pdf');
    }




}
